/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.subscriptions;

import com.dataiku.dip.dao.DkuGroup;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.roles.permissions.EffectivePermissionsItem;
import com.dataiku.gh.core.models.subscriptions.Subscription;
import com.dataiku.gh.core.models.subscriptions.SubscriptionId;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.subscriptions.ISubscriptionsDataService;
import com.dataiku.gh.core.services.subscriptions.ISubscriptionsService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.ISubscriptionValidationService;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.server.services.UsersService;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubscriptionsService
implements ISubscriptionsService {
    @Autowired
    private ISubscriptionsDataService subscriptionsDataService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private ISubscriptionValidationService subscriptionValidationService;
    @Autowired
    private IRolesAndPermissionsService rolesAndPermissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;

    @Override
    @GHWriteTransaction
    public Subscription subscribe(AuthCtx authCtx, String artifactId, Subscription.SubscriptionLevel subscriptionLevel) throws IOException {
        if (authCtx.getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
            throw new ValidationException("Only users can subscribe");
        }
        if (subscriptionLevel != Subscription.SubscriptionLevel.YES && subscriptionLevel != Subscription.SubscriptionLevel.FULL) {
            throw new ValidationException("Can only subscribe at levels YES and FULL");
        }
        Subscription subscription = Subscription.buildSubscription(artifactId, authCtx.getIdentifier(), subscriptionLevel);
        this.subscriptionValidationService.validateSubscription(subscription);
        return this.subscriptionsDataService.storeSubscription(subscription);
    }

    @Override
    @GHWriteTransaction
    @Nullable
    public Subscription automaticSubscribe(AuthCtx authCtx, String artifactId) throws IOException {
        if (authCtx.getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
            return null;
        }
        Subscription oldSubscription = this.getSubscriptionOrNull(authCtx, artifactId);
        if (oldSubscription == null) {
            return this.subscribe(authCtx, artifactId, Subscription.SubscriptionLevel.YES);
        }
        return oldSubscription;
    }

    @Override
    @GHWriteTransaction
    public Subscription unsubscribe(AuthCtx authCtx, String artifactId) throws IOException {
        if (authCtx.getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
            throw new ValidationException("Only users can unsubscribe");
        }
        Subscription subscription = Subscription.buildSubscription(artifactId, authCtx.getIdentifier(), Subscription.SubscriptionLevel.ENO);
        this.subscriptionValidationService.validateSubscription(subscription);
        return this.subscriptionsDataService.storeSubscription(subscription);
    }

    @Override
    @GHReadonlyTransaction
    @Nullable
    public Subscription getSubscriptionOrNull(AuthCtx authCtx, String artifactId) throws IOException {
        if (authCtx.getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
            return null;
        }
        return this.subscriptionsDataService.getSubscriptionOrNull(SubscriptionId.build(artifactId, authCtx.getIdentifier()));
    }

    @Override
    @GHReadonlyTransaction
    public Map<String, Subscription.SubscriptionLevel> getSubscriptionsMapForUser(AuthCtx authCtx) throws IOException {
        if (authCtx.getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
            return Collections.emptyMap();
        }
        List<Subscription> subscriptions = this.subscriptionsDataService.listSubscriptionsForUser(authCtx.getIdentifier());
        return subscriptions.stream().collect(Collectors.toMap(Subscription::getArtifactId, Subscription::getSubscriptionLevel));
    }

    @Override
    @GHReadonlyTransaction
    public Map<String, Subscription.SubscriptionLevel> getSubscriptionsMap(AuthCtx authCtx, List<String> artifactIds) throws IOException {
        if (authCtx.getAuthSource() != AuthCtx.AuthSource.USER_FROM_UI) {
            return Collections.emptyMap();
        }
        List<Subscription> subscriptions = this.subscriptionsDataService.listSubscriptionsForUserAndArtifacts(authCtx.getIdentifier(), artifactIds);
        return subscriptions.stream().collect(Collectors.toMap(Subscription::getArtifactId, Subscription::getSubscriptionLevel));
    }

    @Override
    @GHReadonlyTransaction
    public Set<String> getSubscribers(String artifactId) throws IOException {
        return this.getSubscribersAndReason(artifactId).keySet();
    }

    @Override
    @GHReadonlyTransaction
    public Map<String, EnrichedArtifact> getSubscribersAndReason(String artifactId) throws IOException {
        List<EnrichedArtifact> artifactAncestry = this.artifactsDataService.getArtifactAndAncestry(artifactId);
        Map<String, List<Subscription>> subscriptionsPerUser = this.subscriptionsDataService.listSubscriptionsForArtifacts(artifactAncestry.stream().map(artifact -> artifact.artifact.id).collect(Collectors.toList())).stream().collect(Collectors.groupingBy(subscription -> subscription.subscriptionId.userLogin));
        Map<String, Boolean> mayManageGovernMapping = this.loadUserLoginToMayManageGovernMapping(subscriptionsPerUser.keySet());
        HashMap<String, Map> fullAncestryPermissionMapping = new HashMap<String, Map>();
        for (EnrichedArtifact ea : artifactAncestry) {
            Map<String, EffectivePermissionsItem> mappingForArtifact = this.rolesAndPermissionsService.computeAllUsersEffectivePermissionsItemAtExistingArtifactLevel(ea, mayManageGovernMapping);
            for (Map.Entry<String, EffectivePermissionsItem> entry : mappingForArtifact.entrySet()) {
                fullAncestryPermissionMapping.computeIfAbsent(entry.getKey(), key -> new HashMap()).put(ea.artifact.id, entry.getValue());
            }
        }
        HashMap<String, EnrichedArtifact> subscribersWithReason = new HashMap<String, EnrichedArtifact>();
        for (Map.Entry<String, List<Subscription>> entry : subscriptionsPerUser.entrySet()) {
            EnrichedArtifact ea = this.getArtifactThatCausesInheritedSubscription(artifactAncestry, entry.getValue(), (Map)fullAncestryPermissionMapping.get(entry.getKey()));
            if (ea == null) continue;
            subscribersWithReason.put(entry.getKey(), ea);
        }
        return subscribersWithReason;
    }

    @Nullable
    private EnrichedArtifact getArtifactThatCausesInheritedSubscription(List<EnrichedArtifact> artifactAncestry, List<Subscription> subscriptions, Map<String, EffectivePermissionsItem> permissionsMapping) {
        Map<String, Subscription.SubscriptionLevel> subscriptionsMap = subscriptions.stream().collect(Collectors.toMap(Subscription::getArtifactId, Subscription::getSubscriptionLevel));
        for (int n = 0; n < artifactAncestry.size(); ++n) {
            EnrichedArtifact ea = artifactAncestry.get(n);
            if (!permissionsMapping.get((Object)ea.artifact.id).artifactPermissionsItem.hasReadPermission()) {
                return null;
            }
            Subscription.SubscriptionLevel ancestorLevel = subscriptionsMap.getOrDefault(ea.artifact.id, Subscription.SubscriptionLevel.INO);
            if (n == 0 && ancestorLevel == Subscription.SubscriptionLevel.YES || ancestorLevel == Subscription.SubscriptionLevel.FULL) {
                return ea;
            }
            if (ancestorLevel != Subscription.SubscriptionLevel.ENO) continue;
            return null;
        }
        return null;
    }

    private Map<String, Boolean> loadUserLoginToMayManageGovernMapping(Set<String> usersToRetrieve) throws IOException {
        try (Transaction t = this.transactionService.beginRead();){
            List<? extends DkuGroup> groups = this.usersService.listGroups();
            Map<String, Boolean> map = this.usersService.listUsersInternalUnsafeEnabledOnly().stream().filter(u -> usersToRetrieve.contains(u.login)).collect(Collectors.toMap(u -> u.login, u -> {
                UsersDAO.GroupPermissions computed = UsersDAO.GroupPermissions.baseGroupPermissionsForUnion();
                for (DkuGroup group : groups) {
                    if (!u.groups.contains(group.getName())) continue;
                    computed = computed.union((UsersDAO.Group)group);
                }
                return computed.mayManageGovern();
            }));
            return map;
        }
    }
}

