/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.utils;

import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionUtils {
    public static void executeAfterCommitWithinNewTransaction(PlatformTransactionManager transactionManager, final Runnable runnable) {
        TransactionUtils.executeAfterCommit(() -> {
            TransactionTemplate transactionTemplate = new TransactionTemplate(transactionManager);
            transactionTemplate.setPropagationBehavior(3);
            transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus status) {
                    runnable.run();
                }
            });
        });
    }

    public static void executeAfterCommit(final Runnable runnable) {
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                runnable.run();
            }
        });
    }
}

