/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.search.FieldLogic;
import com.dataiku.gh.core.services.validation.validators.ArtifactFilterValidator;
import com.dataiku.gh.core.utils.DateUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;

public class FieldLogicValidator
implements FieldLogic.IFieldLogicVisitor {
    private void validateFieldLogicCombinator(FieldLogic.FieldLogicCombinator fieldLogicCombinator) {
        ValidatorUtils.validateThat(CollectionUtils.isNotEmpty(fieldLogicCombinator.logics), "OR/AND field logic combinator cannot be empty.", new Object[0]);
        FieldType fieldType = fieldLogicCombinator.logics.get(0).getFieldType();
        ValidatorUtils.validateThat(fieldLogicCombinator.logics.stream().allMatch(l -> l.getFieldType() == fieldType), "All field logic inside an OR/AND combinator must be of the same type.", new Object[0]);
    }

    @Override
    public void visit(FieldLogic.FieldLogicOr fieldLogicOr) {
        this.validateFieldLogicCombinator(fieldLogicOr);
    }

    @Override
    public void visit(FieldLogic.FieldLogicAnd fieldLogicAnd) {
        this.validateFieldLogicCombinator(fieldLogicAnd);
    }

    @Override
    public void visit(FieldLogic.NumberFieldLogic numberFieldLogic) {
        ValidatorUtils.validateThat(numberFieldLogic.condition != null, "Field required: 'condition', on logic of type '%s'", "number");
        ValidatorUtils.validateThat(numberFieldLogic.conditionType != null, "Field required: 'conditionType', on logic of type '%s'", "number");
    }

    @Override
    public void visit(FieldLogic.DateFieldLogic dateFieldLogic) {
        ValidatorUtils.validateThat(dateFieldLogic.condition != null, "Field required: 'condition', on logic of type '%s'", "date");
        ValidatorUtils.validateThat(DateUtils.isValidDateString(dateFieldLogic.condition), "Condition on logic of type 'date' is not a valid date format.", new Object[0]);
        ValidatorUtils.validateThat(dateFieldLogic.conditionType != null, "Field required: 'conditionType', on logic of type '%s'", "date");
    }

    @Override
    public void visit(FieldLogic.TextFieldLogic textFieldLogic) {
        ValidatorUtils.validateThat(textFieldLogic.condition != null, "Field required: 'condition', on logic of type '%s'", textFieldLogic.getFieldType().toString().toLowerCase());
        ValidatorUtils.validateThat(textFieldLogic.conditionType != null, "Field required: 'conditionType', on logic of type '%s'", "text");
    }

    @Override
    public void visit(FieldLogic.CategoryFieldLogic categoryFieldLogic) {
        ValidatorUtils.validateThat(categoryFieldLogic.condition != null, "Field required: 'condition', on logic of type '%s'", categoryFieldLogic.getFieldType().toString().toLowerCase());
        ValidatorUtils.validateThat(categoryFieldLogic.condition.stream().noneMatch(Objects::isNull), "'condition' cannot have null values, on logic of type '%s'", categoryFieldLogic.getFieldType().toString().toLowerCase());
    }

    @Override
    public void visit(FieldLogic.BooleanFieldLogic booleanFieldLogic) {
        ValidatorUtils.validateThat(booleanFieldLogic.conditionType != null, "Field required: 'conditionType', on logic of type '%s'", "boolean");
    }

    @Override
    public void visit(FieldLogic.ReferenceFieldLogic referenceFieldLogic) {
        ValidatorUtils.validateThat(referenceFieldLogic.artifactFilter != null, "Field required: 'artifactFilter', on logic of type '%s'", "reference");
        ArtifactFilterValidator filterValidator = new ArtifactFilterValidator();
        referenceFieldLogic.artifactFilter.accept(filterValidator);
    }
}

