/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.validation.validators;

import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.models.signoff.SignoffApproval;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffFeedback;
import com.dataiku.gh.core.services.validation.validators.SignoffConfigurationValidator;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import com.dataiku.gh.core.utils.ValidatorUtils;
import com.dataiku.gh.core.visitors.ISignoffVisitor;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SignoffValidator
implements ISignoffVisitor {
    public final SignoffConfigurationValidator signoffConfigurationValidator = new SignoffConfigurationValidator();

    @Override
    public void visit(Signoff signoff) {
        ValidatorUtils.validateThat(signoff.signoffId != null, "Sign-off id cannot be null", new Object[0]);
        ValidatorUtils.validateThat(IdentifiersUtils.isValidArtifactId(signoff.signoffId.artifactId), "Invalid artifact Id: '%s'", signoff.signoffId.artifactId);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)signoff.signoffId.stepId), "StepId cannot be empty", new Object[0]);
        ValidatorUtils.validateThat(signoff.status != null, "Sign-off status cannot be null", new Object[0]);
        ValidatorUtils.validateIsIsoOffsetDateTime(signoff.statusDate, "Sign-off statusDate has the wrong format '%s', use ISO date-time", signoff.statusDate);
        ValidatorUtils.validateThat(signoff.cycleIndex >= 0, "Invalid cycleIndex: '%d', it must be positive", signoff.cycleIndex);
        Set feedbacksGroupsIds = signoff.configuration.feedbackUsersGroups.stream().map(group -> group.id).collect(Collectors.toSet());
        Set feedbacksResponsesGroupsIds = signoff.feedbackResponses.stream().map(response -> response.groupId).collect(Collectors.toSet());
        ValidatorUtils.validateThat(feedbacksGroupsIds.containsAll(feedbacksResponsesGroupsIds), "There is at least one commenter group id in the sign-off object that does not exist in the sign-off configuration. Group ids in sign-off: '%s', Group ids in sign-off configuration: '%s'", feedbacksResponsesGroupsIds, feedbacksGroupsIds);
    }

    @Override
    public void visit(SignoffFeedback feedback) {
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)feedback.id), "Id is required", new Object[0]);
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)feedback.groupId), "Group id is required", new Object[0]);
        ValidatorUtils.validateThat(feedback.status != null, "Status is required", new Object[0]);
        ValidatorUtils.validateIsIsoOffsetDateTime(feedback.creationDate, "Creation Date has the wrong format '%s', use ISO date-time", feedback.creationDate);
        if (feedback.editionDate != null) {
            ValidatorUtils.validateIsIsoOffsetDateTime(feedback.editionDate, "Edition Date has the wrong format '%s', use ISO date-time", feedback.editionDate);
        }
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)feedback.user), "Feedback user identifier is required", new Object[0]);
    }

    @Override
    public void visit(SignoffApproval approval) {
        ValidatorUtils.validateThat(approval.status != null, "Status is required", new Object[0]);
        ValidatorUtils.validateIsIsoOffsetDateTime(approval.creationDate, "Creation Date has the wrong format '%s', use ISO date-time", approval.creationDate);
        if (approval.editionDate != null) {
            ValidatorUtils.validateIsIsoOffsetDateTime(approval.editionDate, "Edition Date has the wrong format '%s', use ISO date-time", approval.editionDate);
        }
        ValidatorUtils.validateThat(StringUtils.isNotBlank((CharSequence)approval.user), "Approver user identifier is required", new Object[0]);
    }

    @Override
    public void visit(SignoffConfiguration signoffConfiguration) {
        signoffConfiguration.accept(this.signoffConfigurationValidator);
    }
}

