/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.history.RevisionType;
import com.dataiku.gh.core.services.history.IHistoryDataService;
import com.dataiku.gh.core.storage.IItemBasedDAO;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.IncorrectResultSizeDataAccessException;

public abstract class AbstractItemBasedDAO<ID, TYPE, ENRICHEDTYPE>
extends AbstractPostgreSQLClient
implements IItemBasedDAO<ID, TYPE, ENRICHEDTYPE> {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.item-based-postgresql-client");
    @Autowired
    private IHistoryDataService historyDataService;

    protected final String getItemName() {
        return this.getEntityType().entityName;
    }

    protected abstract EntityType getEntityType();

    protected abstract boolean sqlExists(ID var1);

    protected abstract void sqlLock(ID var1);

    protected abstract int sqlCreate(TYPE var1);

    protected abstract int sqlSave(TYPE var1);

    protected abstract int sqlDelete(ID var1);

    protected abstract int sqlCreateRevision(ID var1, HistoryRevision var2);

    protected abstract ENRICHEDTYPE sqlGet(ID var1);

    protected abstract Stream<ENRICHEDTYPE> sqlListStream();

    protected abstract ID getId(TYPE var1);

    @Override
    public boolean exists(ID id) throws IOException {
        if (id == null) {
            return false;
        }
        try {
            return this.sqlExists(id);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void lock(ID id) throws IOException {
        try {
            this.sqlLock(id);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void create(TYPE item) throws IOException {
        try {
            if (this.sqlCreate(item) != 1) {
                throw new DataStoreIOException("Cannot create " + this.getItemName() + ": " + String.valueOf(this.getId(item)));
            }
            this.createRevision(this.getId(item), RevisionType.ADD);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void save(TYPE item) throws IOException {
        try {
            if (this.sqlSave(item) != 1) {
                throw new DataStoreIOException("Cannot save " + this.getItemName() + ": " + String.valueOf(this.getId(item)));
            }
            this.createRevision(this.getId(item), RevisionType.UPDATE);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void delete(ID id) throws IOException {
        try {
            if (!this.exists(id)) {
                throw new NotFoundException(this.getItemName() + " does not exist: " + String.valueOf(id));
            }
            this.createRevision(id, RevisionType.DELETE);
            if (this.sqlDelete(id) != 1) {
                throw new DataStoreIOException("Cannot delete " + this.getItemName() + ": " + String.valueOf(id));
            }
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public ENRICHEDTYPE getOrNull(ID id) throws IOException {
        try {
            return this.sqlGet(id);
        }
        catch (IncorrectResultSizeDataAccessException e) {
            return null;
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public ENRICHEDTYPE getMandatory(ID id) throws IOException {
        ENRICHEDTYPE obj = this.getOrNull(id);
        if (obj == null) {
            throw new NotFoundException(this.getItemName() + " does not exist: " + String.valueOf(id));
        }
        return obj;
    }

    @Override
    public Stream<ENRICHEDTYPE> listStream() throws IOException {
        try {
            return this.sqlListStream();
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<ENRICHEDTYPE> list() throws IOException {
        try (Stream<ENRICHEDTYPE> stream = this.listStream();){
            List list = stream.collect(Collectors.toList());
            return list;
        }
    }

    private void createRevision(ID id, RevisionType revisionType) throws IOException {
        HistoryRevision revision = this.historyDataService.createRevision(revisionType, this.getEntityType());
        if (this.sqlCreateRevision(id, revision) != 1) {
            throw new DataStoreIOException("Cannot create revision for " + this.getItemName() + ": " + String.valueOf(id));
        }
    }
}

