/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.history.RevisionType;
import com.dataiku.gh.core.models.relationships.Relationship;
import com.dataiku.gh.core.services.history.IHistoryDataService;
import com.dataiku.gh.core.storage.IRelationshipDAO;
import com.dataiku.gh.core.storage.sql.AbstractPostgreSQLClient;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimplePath;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.RowMapper;

public abstract class AbstractSQLRelationshipDAO<T extends Relationship>
extends AbstractPostgreSQLClient
implements IRelationshipDAO<T> {
    @Autowired
    protected IHistoryDataService historyDataService;

    @Override
    public void lockRelationshipsForArtifactId(String artifactId) throws IOException {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from(this.getRelationshipTable())).innerJoin(this.getEntityTable())).on((Predicate)this.getEntityKey().eq((Expression)this.getRelationshipEntityKey()))).where((Predicate)this.getArtifactIdKey().eq((Object)artifactId))).forUpdate();
        try {
            this.querydslJdbcTemplate.queryForList(query);
        }
        catch (DataAccessException e) {
            this.getLogger().error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<T> getRelationshipsForArtifactId(String artifactId) throws IOException {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(this.getRelationshipJson()).from(this.getRelationshipTable())).where((Predicate)this.getArtifactIdKey().eq((Object)artifactId));
        try {
            return this.querydslJdbcTemplate.query(query, this.getRowMapper());
        }
        catch (DataAccessException e) {
            this.getLogger().error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void createRelationships(List<T> relationships) throws IOException {
        if (CollectionUtils.isEmpty(relationships)) {
            return;
        }
        try {
            SQLInsertClause insert = this.sqlQueryFactory.insert(this.getRelationshipTable());
            relationships.forEach(r -> ((SQLInsertClause)insert.set(this.getRelationshipJson(), QueryBuilderUtils.toJsonb(r))).addBatch());
            this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)insert);
            this.createRevision(relationships, RevisionType.ADD);
        }
        catch (DataAccessException e) {
            this.getLogger().error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void saveRelationships(List<T> relationships) throws IOException {
        if (CollectionUtils.isEmpty(relationships)) {
            return;
        }
        try {
            SQLDeleteClause delete = this.sqlQueryFactory.delete(this.getRelationshipTable());
            relationships.forEach(r -> ((SQLDeleteClause)delete.where((Predicate)this.getArtifactIdKey().eq((Object)r.getArtifactId()).and((Predicate)QueryBuilderUtils.jsonObject(this.getRelationshipJson(), new String[]{"relationshipData"}).eq(QueryBuilderUtils.toJsonbAsExpression(r.relationshipData))))).addBatch());
            SQLInsertClause insert = this.sqlQueryFactory.insert(this.getRelationshipTable());
            relationships.forEach(r -> ((SQLInsertClause)insert.set(this.getRelationshipJson(), QueryBuilderUtils.toJsonb(r))).addBatch());
            this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)delete);
            this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)insert);
            this.createRevision(relationships, RevisionType.UPDATE);
        }
        catch (DataAccessException e) {
            this.getLogger().error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void deleteRelationships(List<T> relationships) throws IOException {
        if (CollectionUtils.isEmpty(relationships)) {
            return;
        }
        try {
            this.createRevision(relationships, RevisionType.DELETE);
            SQLDeleteClause delete = this.sqlQueryFactory.delete(this.getRelationshipTable());
            relationships.forEach(r -> ((SQLDeleteClause)delete.where((Predicate)this.getArtifactIdKey().eq((Object)r.getArtifactId()).and((Predicate)this.getRelationshipJson().eq(QueryBuilderUtils.toJsonbAsExpression(r))))).addBatch());
            this.querydslJdbcTemplate.batchUpdate((AbstractSQLClause<?>)delete);
        }
        catch (DataAccessException e) {
            this.getLogger().error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<T> getRelationships(List<String> relationshipEntityIds) throws IOException {
        ArrayList<T> result = new ArrayList<T>();
        ArrayList<String> uniqueRelationshipEntityIds = new ArrayList<String>(new HashSet<String>(relationshipEntityIds));
        for (List currentRelationshipEntityIds : Lists.partition(uniqueRelationshipEntityIds, (int)250)) {
            SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(this.getRelationshipJson()).from(this.getRelationshipTable())).where((Predicate)this.getRelationshipEntityKey().in((Collection)currentRelationshipEntityIds));
            try {
                result.addAll(this.querydslJdbcTemplate.query(query, this.getRowMapper()));
            }
            catch (DataAccessException e) {
                this.getLogger().error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
                throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
            }
        }
        return result;
    }

    private void createRevision(List<T> relationships, RevisionType revisionType) throws IOException {
        for (Relationship relationship : relationships) {
            HistoryRevision revision = this.historyDataService.createRevision(revisionType, this.getEntityType());
            this.sqlCreateRevision(relationship, revision);
        }
    }

    protected abstract DKULogger getLogger();

    protected abstract RelationalPath<?> getRelationshipTable();

    protected abstract RelationalPath<?> getEntityTable();

    protected abstract StringExpression getEntityKey();

    protected abstract StringExpression getRelationshipEntityKey();

    protected abstract StringExpression getArtifactIdKey();

    protected abstract SimplePath<Object> getRelationshipJson();

    protected abstract RowMapper<T> getRowMapper();

    protected abstract EntityType getEntityType();

    protected abstract void sqlCreateRevision(T var1, HistoryRevision var2) throws DataStoreIOException;
}

