/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.utils.DKULogger;
import com.querydsl.sql.SQLBindings;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.types.Null;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.RowMapperResultSetExtractor;

public class QueryDslJdbcTemplate
extends JdbcTemplate {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.sql");

    public QueryDslJdbcTemplate(DataSource dataSource) {
        super(dataSource);
        this.setFetchSize(DKUApp.getParams().getIntParam("dku.govern.jdbc.stream-fetch-size", Integer.valueOf(5)));
    }

    public <T> T queryForObject(SQLQuery<?> sqlQuery, Class<T> requiredType) throws DataAccessException {
        SQLBindings sqlBindings = sqlQuery.getSQL();
        this.logRequest(sqlBindings);
        return (T)this.queryForObject(sqlBindings.getSQL(), requiredType, this.getBindingsObjArray(sqlBindings));
    }

    public <T> T queryForObject(SQLQuery<?> sqlQuery, RowMapper<T> rowMapper) {
        SQLBindings sqlBindings = sqlQuery.getSQL();
        this.logRequest(sqlBindings);
        return (T)this.queryForObject(sqlBindings.getSQL(), rowMapper, this.getBindingsObjArray(sqlBindings));
    }

    public <T> T queryForObject(AbstractSQLClause<?> sqlQuery, RowMapper<T> rowMapper) throws DataAccessException {
        SQLBindings sqlBindings = (SQLBindings)sqlQuery.getSQL().get(0);
        this.logRequest(sqlBindings);
        return (T)this.queryForObject(sqlBindings.getSQL(), rowMapper, this.getBindingsObjArray(sqlBindings));
    }

    public <T> List<T> query(SQLQuery<?> sqlQuery, RowMapper<T> rowMapper) throws DataAccessException {
        SQLBindings sqlBindings = sqlQuery.getSQL();
        this.logRequest(sqlBindings);
        return (List)this.query(sqlBindings.getSQL(), (ResultSetExtractor)new RowMapperResultSetExtractor(rowMapper), this.getBindingsObjArray(sqlBindings));
    }

    public <T> T query(SQLQuery<?> sqlQuery, ResultSetExtractor<T> resultSetExtractor) throws DataAccessException {
        SQLBindings sqlBindings = sqlQuery.getSQL();
        this.logRequest(sqlBindings);
        return (T)this.query(sqlBindings.getSQL(), resultSetExtractor, this.getBindingsObjArray(sqlBindings));
    }

    public List<Map<String, Object>> queryForList(SQLQuery<?> sqlQuery) throws DataAccessException {
        SQLBindings sqlBindings = sqlQuery.getSQL();
        this.logRequest(sqlBindings);
        return this.queryForList(sqlBindings.getSQL(), this.getBindingsObjArray(sqlBindings));
    }

    public int update(AbstractSQLClause<?> sqlQuery) throws DataAccessException {
        SQLBindings sqlBindings = (SQLBindings)sqlQuery.getSQL().get(0);
        return this.update(sqlBindings.getSQL(), this.getBindingsObjArray(sqlBindings));
    }

    public int[] batchUpdate(AbstractSQLClause<?> sqlQuery) throws DataAccessException {
        List listSqlBindings = sqlQuery.getSQL();
        String sql = ((SQLBindings)listSqlBindings.get(0)).getSQL();
        List batchArgs = listSqlBindings.stream().map(this::getBindingsObjArray).collect(Collectors.toList());
        return this.batchUpdate(sql, batchArgs);
    }

    public void execute(AbstractSQLClause<?> sqlQuery) {
        List listSqlBindings = sqlQuery.getSQL();
        String sql = ((SQLBindings)listSqlBindings.get(0)).getSQL();
        this.execute(sql);
    }

    private Object[] getBindingsObjArray(SQLBindings sqlBindings) {
        return sqlBindings.getNullFriendlyBindings().stream().map(obj -> {
            if (obj instanceof Null) {
                return null;
            }
            return obj;
        }).toArray();
    }

    public <T> Stream<T> queryForStream(SQLQuery<?> sqlQuery, RowMapper<T> rowMapper) {
        SQLBindings sqlBindings = sqlQuery.getSQL();
        this.logRequest(sqlBindings);
        return this.queryForStream(sqlBindings.getSQL(), rowMapper, this.getBindingsObjArray(sqlBindings));
    }

    private void logRequest(SQLBindings sqlBindings) {
        if ("1".equals(System.getenv("DSS_DEV")) && logger.isTraceEnabled()) {
            List args = Stream.of(this.getBindingsObjArray(sqlBindings)).map(obj -> obj instanceof String ? "'" + String.valueOf(obj) + "'" : obj).collect(Collectors.toList());
            logger.traceV("Query:%n%s;%n--Args: %s", new Object[]{sqlBindings.getSQL(), args});
        }
    }
}

