/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.auto_govern;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.governance.ArtifactAutoGovernanceConfiguration;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.storage.auto_govern.IArtifactGovernanceSettingsDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.auto_govern.ArtifactGovernanceSettingsRowMapper;
import com.dataiku.gh.core.storage.sql.model.QArtifactGovernanceSettings;
import com.dataiku.gh.core.storage.sql.model.QArtifactGovernanceSettingsHistory;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleTemplate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class ArtifactGovernanceSettingsDAO
extends AbstractItemBasedDAO<String, ArtifactAutoGovernanceConfiguration, ArtifactAutoGovernanceConfiguration>
implements IArtifactGovernanceSettingsDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.artifact-governance-settings");
    @Autowired
    private ArtifactGovernanceSettingsRowMapper artifactGovernanceSettingsRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.AUTO_GOVERN_CONFIGURATION;
    }

    @Override
    protected boolean sqlExists(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QArtifactGovernanceSettings.artifactGovernanceSettings)).where((Predicate)ArtifactGovernanceSettingsDAO.buildWhereCond(id));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    protected void sqlLock(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QArtifactGovernanceSettings.artifactGovernanceSettings)).where((Predicate)ArtifactGovernanceSettingsDAO.buildWhereCond(id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected int sqlCreate(ArtifactAutoGovernanceConfiguration item) {
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QArtifactGovernanceSettings.artifactGovernanceSettings).columns(new Path[]{QArtifactGovernanceSettings.artifactGovernanceSettings.artifactGovernanceSettingsJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlSave(ArtifactAutoGovernanceConfiguration item) {
        SQLUpdateClause query = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QArtifactGovernanceSettings.artifactGovernanceSettings).set(QArtifactGovernanceSettings.artifactGovernanceSettings.artifactGovernanceSettingsJson, QueryBuilderUtils.toJsonb(item))).where((Predicate)ArtifactGovernanceSettingsDAO.buildWhereCond(item));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlDelete(String id) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QArtifactGovernanceSettings.artifactGovernanceSettings).where((Predicate)ArtifactGovernanceSettingsDAO.buildWhereCond(id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlCreateRevision(String id, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QArtifactGovernanceSettings.artifactGovernanceSettings.artifactGovernanceSettingsJson).from((Expression)QArtifactGovernanceSettings.artifactGovernanceSettings)).where((Predicate)ArtifactGovernanceSettingsDAO.buildWhereCond(id));
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QArtifactGovernanceSettingsHistory.artifactGovernanceSettingsHistory).set(QArtifactGovernanceSettingsHistory.artifactGovernanceSettingsHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QArtifactGovernanceSettingsHistory.artifactGovernanceSettingsHistory.artifactGovernanceSettingsJson, (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected ArtifactAutoGovernanceConfiguration sqlGet(String id) {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)ArtifactGovernanceSettingsDAO.buildWhereCond(id));
        return this.querydslJdbcTemplate.queryForObject(query, this.artifactGovernanceSettingsRowMapper);
    }

    @Override
    protected Stream<ArtifactAutoGovernanceConfiguration> sqlListStream() {
        return this.querydslJdbcTemplate.queryForStream(this.buildSelectQuery(), this.artifactGovernanceSettingsRowMapper);
    }

    @Override
    protected String getId(ArtifactAutoGovernanceConfiguration item) {
        return item.artifactId;
    }

    private SQLQuery<Object> buildSelectQuery() {
        return (SQLQuery)this.sqlQueryFactory.select(QArtifactGovernanceSettings.artifactGovernanceSettings.artifactGovernanceSettingsJson).from((Expression)QArtifactGovernanceSettings.artifactGovernanceSettings);
    }

    private static BooleanExpression buildWhereCond(ArtifactAutoGovernanceConfiguration item) {
        return ArtifactGovernanceSettingsDAO.buildWhereCond(item.artifactId);
    }

    private static BooleanExpression buildWhereCond(String id) {
        return QArtifactGovernanceSettings.artifactGovernanceSettings.artifactGovernanceSettingsArtifactId.eq((Object)id);
    }

    @Override
    @Nonnull
    public List<ArtifactAutoGovernanceConfiguration> listByArtifactIds(Collection<String> artifactIds) throws IOException {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QArtifactGovernanceSettings.artifactGovernanceSettings.artifactGovernanceSettingsArtifactId.in(artifactIds));
        try {
            return this.querydslJdbcTemplate.query(query, this.artifactGovernanceSettingsRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    @Nonnull
    public Stream<ArtifactAutoGovernanceConfiguration> listFromUsedBPV(BlueprintVersionId blueprintVersionId) throws IOException {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)ArtifactGovernanceSettingsDAO.matchingBlueprintVersion(QueryBuilderUtils.jsonObject(QArtifactGovernanceSettings.artifactGovernanceSettings.artifactGovernanceSettingsJson, new String[]{"modelVersionsConfig", "blueprintVersionId"}), blueprintVersionId).or((Predicate)ArtifactGovernanceSettingsDAO.matchingBlueprintVersion(QueryBuilderUtils.jsonObject(QArtifactGovernanceSettings.artifactGovernanceSettings.artifactGovernanceSettingsJson, new String[]{"modelsConfig", "blueprintVersionId"}), blueprintVersionId)).or((Predicate)ArtifactGovernanceSettingsDAO.matchingBlueprintVersion(QueryBuilderUtils.jsonObject(QArtifactGovernanceSettings.artifactGovernanceSettings.artifactGovernanceSettingsJson, new String[]{"bundlesConfig", "blueprintVersionId"}), blueprintVersionId)));
        try {
            return this.querydslJdbcTemplate.queryForStream(query, this.artifactGovernanceSettingsRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    public static BooleanExpression matchingBlueprintVersion(SimpleTemplate<Object> blueprintVersionIdFromDB, BlueprintVersionId blueprintVersionIdToMatchWith) {
        return QueryBuilderUtils.jsonString(blueprintVersionIdFromDB, new String[]{"blueprintId"}).eq((Object)blueprintVersionIdToMatchWith.blueprintId).and((Predicate)QueryBuilderUtils.jsonString(blueprintVersionIdFromDB, new String[]{"versionId"}).eq((Object)blueprintVersionIdToMatchWith.versionId));
    }
}

