/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.blueprints;

import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.blueprints.Blueprint;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprint;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.storage.blueprints.IBlueprintDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.blueprints.EnrichedBlueprintRowMapper;
import com.dataiku.gh.core.storage.sql.model.QBlueprintPermissions;
import com.dataiku.gh.core.storage.sql.model.QBlueprintRoleAssignments;
import com.dataiku.gh.core.storage.sql.model.QBlueprints;
import com.dataiku.gh.core.storage.sql.model.QBlueprintsHistory;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class BlueprintDAO
extends AbstractItemBasedDAO<String, Blueprint, EnrichedBlueprint>
implements IBlueprintDAO {
    @Autowired
    private EnrichedBlueprintRowMapper enrichedBlueprintRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.BLUEPRINT;
    }

    @Override
    protected String getId(Blueprint item) {
        return item.id;
    }

    @Override
    protected boolean sqlExists(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QBlueprints.blueprints)).where((Predicate)QBlueprints.blueprints.blueprintId.eq((Object)id));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    protected void sqlLock(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QBlueprints.blueprints)).where((Predicate)QBlueprints.blueprints.blueprintId.eq((Object)id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected int sqlCreate(Blueprint item) {
        SQLInsertClause query = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QBlueprints.blueprints).columns(new Path[]{QBlueprints.blueprints.blueprintJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlCreateRevision(String id, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QBlueprints.blueprints.blueprintJson).from((Expression)QBlueprints.blueprints)).where((Predicate)QBlueprints.blueprints.blueprintId.eq((Object)id));
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QBlueprintsHistory.blueprintsHistory).set(QBlueprintsHistory.blueprintsHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QBlueprintsHistory.blueprintsHistory.blueprintJson, (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlSave(Blueprint item) {
        SQLUpdateClause query = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QBlueprints.blueprints).set(QBlueprints.blueprints.blueprintJson, QueryBuilderUtils.toJsonb(item))).where((Predicate)QBlueprints.blueprints.blueprintId.eq((Object)item.id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlDelete(String id) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QBlueprints.blueprints).where((Predicate)QBlueprints.blueprints.blueprintId.eq((Object)id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected EnrichedBlueprint sqlGet(String id) {
        SQLQuery query = (SQLQuery)BlueprintDAO.buildSelectFromEnrichedBlueprintQuery(this.sqlQueryFactory).where((Predicate)QBlueprints.blueprints.blueprintId.eq((Object)id));
        return this.querydslJdbcTemplate.queryForObject(query, this.enrichedBlueprintRowMapper);
    }

    @Override
    protected Stream<EnrichedBlueprint> sqlListStream() {
        SQLQuery<?> query = BlueprintDAO.buildSelectFromEnrichedBlueprintQuery(this.sqlQueryFactory);
        return this.querydslJdbcTemplate.queryForStream(query, this.enrichedBlueprintRowMapper);
    }

    private static SQLQuery<?> buildSelectFromEnrichedBlueprintQuery(SQLQueryFactory sqlQueryFactory) {
        SQLQuery sqlQuery = sqlQueryFactory.query();
        ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)sqlQuery.from((Expression)QBlueprints.blueprints)).leftJoin((EntityPath)QBlueprintRoleAssignments.blueprintRoleAssignments)).on((Predicate)QBlueprintRoleAssignments.blueprintRoleAssignments.blueprintRoleAssignmentsBlueprintId.eq((Expression)QBlueprints.blueprints.blueprintId))).leftJoin((EntityPath)QBlueprintPermissions.blueprintPermissions)).on((Predicate)QBlueprintPermissions.blueprintPermissions.blueprintPermissionsBlueprintId.eq((Expression)QBlueprints.blueprints.blueprintId))).select(new Expression[]{QBlueprints.blueprints.blueprintJson, QBlueprintRoleAssignments.blueprintRoleAssignments.blueprintRoleAssignmentsJson, QBlueprintPermissions.blueprintPermissions.blueprintPermissionsJson});
        return sqlQuery;
    }
}

