/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.blueprints;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.blueprints.BlueprintVersion;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.blueprints.EnrichedBlueprintVersionRowMapper;
import com.dataiku.gh.core.storage.sql.model.QBlueprintPermissions;
import com.dataiku.gh.core.storage.sql.model.QBlueprintRoleAssignments;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionTraces;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersions;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionsHistory;
import com.dataiku.gh.core.storage.sql.model.QBlueprints;
import com.dataiku.gh.core.storage.sql.signoff.SignoffsConfigurationsDAO;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.SQLQueryFactory;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class BlueprintVersionDAO
extends AbstractItemBasedDAO<BlueprintVersionId, BlueprintVersion, EnrichedBlueprintVersion>
implements IBlueprintVersionDAO {
    private static DKULogger logger = DKULogger.getLogger((String)"gh.storage.blueprint-versions");
    @Autowired
    private EnrichedBlueprintVersionRowMapper enrichedBlueprintVersionRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.BLUEPRINT_VERSION;
    }

    @Override
    protected BlueprintVersionId getId(BlueprintVersion item) {
        return item.id;
    }

    @Override
    protected boolean sqlExists(BlueprintVersionId id) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QBlueprintVersions.blueprintVersions)).where((Predicate)this.equalsBlueprintVersionId(id));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    protected void sqlLock(BlueprintVersionId id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QBlueprintVersions.blueprintVersions)).innerJoin((EntityPath)QBlueprints.blueprints)).on((Predicate)QBlueprints.blueprints.blueprintId.eq((Expression)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId))).where((Predicate)this.equalsBlueprintVersionId(id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected int sqlCreate(BlueprintVersion item) {
        SQLInsertClause query = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QBlueprintVersions.blueprintVersions).columns(new Path[]{QBlueprintVersions.blueprintVersions.blueprintVersionJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlCreateRevision(BlueprintVersionId blueprintVersionId, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QBlueprintVersions.blueprintVersions.blueprintVersionJson).from((Expression)QBlueprintVersions.blueprintVersions)).where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId));
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QBlueprintVersionsHistory.blueprintVersionsHistory).set(QBlueprintVersionsHistory.blueprintVersionsHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QBlueprintVersionsHistory.blueprintVersionsHistory.blueprintVersionJson, (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlSave(BlueprintVersion item) {
        SQLUpdateClause query = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QBlueprintVersions.blueprintVersions).set(QBlueprintVersions.blueprintVersions.blueprintVersionJson, QueryBuilderUtils.toJsonb(item))).where((Predicate)this.equalsBlueprintVersionId(item.id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlDelete(BlueprintVersionId id) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QBlueprintVersions.blueprintVersions).where((Predicate)this.equalsBlueprintVersionId(id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected EnrichedBlueprintVersion sqlGet(BlueprintVersionId id) {
        SQLQuery query = (SQLQuery)BlueprintVersionDAO.buildSelectFromEnrichedBlueprintVersionQuery(this.sqlQueryFactory).where((Predicate)this.equalsBlueprintVersionId(id));
        return this.querydslJdbcTemplate.queryForObject(query, this.enrichedBlueprintVersionRowMapper);
    }

    @Override
    protected Stream<EnrichedBlueprintVersion> sqlListStream() {
        return this.querydslJdbcTemplate.queryForStream(BlueprintVersionDAO.buildSelectFromEnrichedBlueprintVersionQuery(this.sqlQueryFactory), this.enrichedBlueprintVersionRowMapper);
    }

    @Override
    public List<EnrichedBlueprintVersion> listByBlueprint(String blueprintId) throws IOException {
        SQLQuery query = (SQLQuery)BlueprintVersionDAO.buildSelectFromEnrichedBlueprintVersionQuery(this.sqlQueryFactory).where((Predicate)QBlueprints.blueprints.blueprintId.eq((Object)blueprintId));
        try {
            return this.querydslJdbcTemplate.query(query, this.enrichedBlueprintVersionRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private BooleanExpression equalsBlueprintVersionId(BlueprintVersionId id) {
        if (id == null || StringUtils.isBlank((String)id.blueprintId) || StringUtils.isBlank((String)id.versionId)) {
            throw ErrorContext.iae((String)"Blueprint version ID is required");
        }
        return QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId.eq((Object)id.blueprintId).and((Predicate)QBlueprintVersions.blueprintVersions.blueprintVersionVersionId.eq((Object)id.versionId));
    }

    private static SQLQuery<?> buildSelectFromEnrichedBlueprintVersionQuery(SQLQueryFactory sqlQueryFactory) {
        SQLQuery sqlQuery = sqlQueryFactory.query();
        ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)sqlQuery.from((Expression)QBlueprintVersions.blueprintVersions)).innerJoin((EntityPath)QBlueprints.blueprints)).on((Predicate)QBlueprints.blueprints.blueprintId.eq((Expression)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId))).innerJoin((EntityPath)QBlueprintVersionTraces.blueprintVersionTraces)).on((Predicate)QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceBlueprintId.eq((Expression)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId).and((Predicate)QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceVersionId.eq((Expression)QBlueprintVersions.blueprintVersions.blueprintVersionVersionId)))).leftJoin((EntityPath)QBlueprintRoleAssignments.blueprintRoleAssignments)).on((Predicate)QBlueprintRoleAssignments.blueprintRoleAssignments.blueprintRoleAssignmentsBlueprintId.eq((Expression)QBlueprints.blueprints.blueprintId))).leftJoin((EntityPath)QBlueprintPermissions.blueprintPermissions)).on((Predicate)QBlueprintPermissions.blueprintPermissions.blueprintPermissionsBlueprintId.eq((Expression)QBlueprints.blueprints.blueprintId))).select(new Expression[]{QBlueprints.blueprints.blueprintJson, QBlueprintVersions.blueprintVersions.blueprintVersionJson, QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceJson, SignoffsConfigurationsDAO.buildSignoffsConfigurationsByBlueprintVersionSubQuery((Expression<String>)QBlueprintVersions.blueprintVersions.blueprintVersionBlueprintId, (Expression<String>)QBlueprintVersions.blueprintVersions.blueprintVersionVersionId), QBlueprintRoleAssignments.blueprintRoleAssignments.blueprintRoleAssignmentsJson, QBlueprintPermissions.blueprintPermissions.blueprintPermissionsJson});
        return sqlQuery;
    }
}

