/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.blueprints;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionTrace;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.storage.blueprints.IBlueprintVersionTraceDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.blueprints.BlueprintVersionTraceRowMapper;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionTraces;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionTracesHistory;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class BlueprintVersionTraceDAO
extends AbstractItemBasedDAO<BlueprintVersionId, BlueprintVersionTrace, BlueprintVersionTrace>
implements IBlueprintVersionTraceDAO {
    private static DKULogger logger = DKULogger.getLogger((String)"gh.storage.blueprint-version-traces");
    @Autowired
    private BlueprintVersionTraceRowMapper blueprintVersionTraceRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.BLUEPRINT_VERSION_TRACE;
    }

    @Override
    protected BlueprintVersionId getId(BlueprintVersionTrace item) {
        return item.blueprintVersionId;
    }

    @Override
    protected boolean sqlExists(BlueprintVersionId blueprintVersionId) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QBlueprintVersionTraces.blueprintVersionTraces)).where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    protected void sqlLock(BlueprintVersionId blueprintVersionId) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QBlueprintVersionTraces.blueprintVersionTraces)).where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected int sqlCreate(BlueprintVersionTrace item) {
        SQLInsertClause query = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QBlueprintVersionTraces.blueprintVersionTraces).columns(new Path[]{QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlCreateRevision(BlueprintVersionId blueprintVersionId, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)this.buildSelectQuery().where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId));
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QBlueprintVersionTracesHistory.blueprintVersionTracesHistory).set(QBlueprintVersionTracesHistory.blueprintVersionTracesHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QBlueprintVersionTracesHistory.blueprintVersionTracesHistory.blueprintVersionTraceJson, (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlSave(BlueprintVersionTrace item) {
        SQLUpdateClause query = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QBlueprintVersionTraces.blueprintVersionTraces).set(QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceJson, QueryBuilderUtils.toJsonb(item))).where((Predicate)this.equalsBlueprintVersionId(item.blueprintVersionId));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlDelete(BlueprintVersionId blueprintVersionId) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QBlueprintVersionTraces.blueprintVersionTraces).where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected BlueprintVersionTrace sqlGet(BlueprintVersionId blueprintVersionId) {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId));
        return this.querydslJdbcTemplate.queryForObject(query, this.blueprintVersionTraceRowMapper);
    }

    @Override
    protected Stream<BlueprintVersionTrace> sqlListStream() {
        return this.querydslJdbcTemplate.queryForStream(this.buildSelectQuery(), this.blueprintVersionTraceRowMapper);
    }

    @Override
    public List<BlueprintVersionTrace> listByOriginVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceBlueprintId.eq((Object)blueprintVersionId.blueprintId).and((Predicate)QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceOriginVersionId.eq((Object)blueprintVersionId.versionId)));
        try {
            return this.querydslJdbcTemplate.query(query, this.blueprintVersionTraceRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private BooleanExpression equalsBlueprintVersionId(BlueprintVersionId id) {
        return QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceBlueprintId.eq((Object)id.blueprintId).and((Predicate)QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceVersionId.eq((Object)id.versionId));
    }

    private SQLQuery<Object> buildSelectQuery() {
        return (SQLQuery)this.sqlQueryFactory.select(QBlueprintVersionTraces.blueprintVersionTraces.blueprintVersionTraceJson).from((Expression)QBlueprintVersionTraces.blueprintVersionTraces);
    }
}

