/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.configuration;

import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.configuration.GovernConfiguration;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.storage.configuration.IGovernConfigurationDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.configuration.GovernConfigurationRowMapper;
import com.dataiku.gh.core.storage.sql.model.QGovernConfiguration;
import com.dataiku.gh.core.storage.sql.model.QGovernConfigurationHistory;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public class GovernConfigurationDAO
extends AbstractItemBasedDAO<String, GovernConfiguration, GovernConfiguration>
implements IGovernConfigurationDAO {
    @Autowired
    private GovernConfigurationRowMapper governConfigurationRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.GOVERN_CONFIGURATION;
    }

    @Override
    protected String getId(GovernConfiguration item) {
        return item.getId();
    }

    @Override
    protected boolean sqlExists(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QGovernConfiguration.governConfiguration)).where((Predicate)QGovernConfiguration.governConfiguration.configurationItemId.eq((Object)id));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    protected void sqlLock(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QGovernConfiguration.governConfiguration)).where((Predicate)QGovernConfiguration.governConfiguration.configurationItemId.eq((Object)id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected int sqlCreate(GovernConfiguration item) {
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QGovernConfiguration.governConfiguration).columns(new Path[]{QGovernConfiguration.governConfiguration.configurationItemJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlCreateRevision(String id, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)this.buildSelectQuery().where((Predicate)QGovernConfiguration.governConfiguration.configurationItemId.eq((Object)id));
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QGovernConfigurationHistory.governConfigurationHistory).set(QGovernConfigurationHistory.governConfigurationHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QGovernConfigurationHistory.governConfigurationHistory.configurationItemJson, (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlSave(GovernConfiguration item) {
        SQLUpdateClause update = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QGovernConfiguration.governConfiguration).set(QGovernConfiguration.governConfiguration.configurationItemJson, QueryBuilderUtils.toJsonb(item))).where((Predicate)QGovernConfiguration.governConfiguration.configurationItemId.eq((Object)this.getId(item)));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)update);
    }

    @Override
    protected int sqlDelete(String id) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QGovernConfiguration.governConfiguration).where((Predicate)QGovernConfiguration.governConfiguration.configurationItemId.eq((Object)id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected GovernConfiguration sqlGet(String id) {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QGovernConfiguration.governConfiguration.configurationItemId.eq((Object)id));
        return this.querydslJdbcTemplate.queryForObject(query, this.governConfigurationRowMapper);
    }

    @Override
    protected Stream<GovernConfiguration> sqlListStream() {
        return this.querydslJdbcTemplate.queryForStream(this.buildSelectQuery(), this.governConfigurationRowMapper);
    }

    private SQLQuery<Object> buildSelectQuery() {
        return (SQLQuery)this.sqlQueryFactory.select(QGovernConfiguration.governConfiguration.configurationItemJson).from((Expression)QGovernConfiguration.governConfiguration);
    }
}

