/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.custom_pages;

import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.custom_pages.CustomPage;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.storage.custom_pages.ICustomPageDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.custom_pages.CustomPageRowMapper;
import com.dataiku.gh.core.storage.sql.model.QCustomPages;
import com.dataiku.gh.core.storage.sql.model.QCustomPagesHistory;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public class CustomPageDAO
extends AbstractItemBasedDAO<String, CustomPage, CustomPage>
implements ICustomPageDAO {
    @Autowired
    private CustomPageRowMapper customPageRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.CUSTOM_PAGE;
    }

    @Override
    protected String getId(CustomPage item) {
        return item.id;
    }

    @Override
    protected boolean sqlExists(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QCustomPages.customPages)).where((Predicate)QCustomPages.customPages.customPageId.eq((Object)id));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    protected void sqlLock(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QCustomPages.customPages)).where((Predicate)QCustomPages.customPages.customPageId.eq((Object)id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected int sqlCreate(CustomPage item) {
        SQLInsertClause query = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QCustomPages.customPages).columns(new Path[]{QCustomPages.customPages.customPageJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlCreateRevision(String id, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)this.buildSelectQuery().where((Predicate)QCustomPages.customPages.customPageId.eq((Object)id));
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QCustomPagesHistory.customPagesHistory).set(QCustomPagesHistory.customPagesHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QCustomPagesHistory.customPagesHistory.customPageJson, (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlSave(CustomPage item) {
        SQLUpdateClause query = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QCustomPages.customPages).set(QCustomPages.customPages.customPageJson, QueryBuilderUtils.toJsonb(item))).where((Predicate)QCustomPages.customPages.customPageId.eq((Object)item.id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlDelete(String id) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QCustomPages.customPages).where((Predicate)QCustomPages.customPages.customPageId.eq((Object)id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected CustomPage sqlGet(String id) {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QCustomPages.customPages.customPageId.eq((Object)id));
        return this.querydslJdbcTemplate.queryForObject(query, this.customPageRowMapper);
    }

    @Override
    protected Stream<CustomPage> sqlListStream() {
        SQLQuery<Object> query = this.buildSelectQuery();
        return this.querydslJdbcTemplate.queryForStream(query, this.customPageRowMapper);
    }

    private SQLQuery<Object> buildSelectQuery() {
        return (SQLQuery)this.sqlQueryFactory.select(QCustomPages.customPages.customPageJson).from((Expression)QCustomPages.customPages);
    }
}

