/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.migration_paths;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.migration_paths.BlueprintVersionMigrationPath;
import com.dataiku.gh.core.storage.migration_paths.IBlueprintVersionMigrationPathDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.migration_paths.BlueprintVersionMigrationPathRowMapper;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionMigrationPaths;
import com.dataiku.gh.core.storage.sql.model.QBlueprintVersionMigrationPathsHistory;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public class BlueprintVersionMigrationPathDAO
extends AbstractItemBasedDAO<String, BlueprintVersionMigrationPath, BlueprintVersionMigrationPath>
implements IBlueprintVersionMigrationPathDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.migrationPaths");
    @Autowired
    private BlueprintVersionMigrationPathRowMapper blueprintVersionMigrationPathRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.BLUEPRINT_VERSION_MIGRATION_PATH;
    }

    @Override
    protected boolean sqlExists(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths)).where((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationPathId.eq((Object)id));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    protected void sqlLock(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths)).where((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationPathId.eq((Object)id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected int sqlCreate(BlueprintVersionMigrationPath item) {
        SQLInsertClause query = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths).columns(new Path[]{QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlSave(BlueprintVersionMigrationPath item) {
        SQLUpdateClause query = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths).set(QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationJson, QueryBuilderUtils.toJsonb(item))).where((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationPathId.eq((Object)item.id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlDelete(String id) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths).where((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationPathId.eq((Object)id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlCreateRevision(String id, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationJson).from((Expression)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths)).where((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationPathId.eq((Object)id));
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QBlueprintVersionMigrationPathsHistory.blueprintVersionMigrationPathsHistory).set(QBlueprintVersionMigrationPathsHistory.blueprintVersionMigrationPathsHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QBlueprintVersionMigrationPathsHistory.blueprintVersionMigrationPathsHistory.blueprintVersionMigrationJson, (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected BlueprintVersionMigrationPath sqlGet(String id) {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationPathId.eq((Object)id));
        return this.querydslJdbcTemplate.queryForObject(query, this.blueprintVersionMigrationPathRowMapper);
    }

    @Override
    protected Stream<BlueprintVersionMigrationPath> sqlListStream() {
        return this.querydslJdbcTemplate.queryForStream(this.buildSelectQuery(), this.blueprintVersionMigrationPathRowMapper);
    }

    @Override
    public List<BlueprintVersionMigrationPath> listByRelatedBlueprintVersionSource(BlueprintVersionId blueprintVersionIdSource) throws IOException {
        try {
            return this.querydslJdbcTemplate.query((SQLQuery)this.buildSelectQuery().where((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationBlueprintIdFrom.eq((Object)blueprintVersionIdSource.blueprintId).and((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationVersionIdFrom.eq((Object)blueprintVersionIdSource.versionId))), this.blueprintVersionMigrationPathRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<BlueprintVersionMigrationPath> listByRelatedBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        try {
            return this.querydslJdbcTemplate.query((SQLQuery)this.buildSelectQuery().where((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationBlueprintIdFrom.eq((Object)blueprintVersionId.blueprintId).and((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationVersionIdFrom.eq((Object)blueprintVersionId.versionId)).or((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationBlueprintIdTo.eq((Object)blueprintVersionId.blueprintId).and((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationVersionIdTo.eq((Object)blueprintVersionId.versionId)))), this.blueprintVersionMigrationPathRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<BlueprintVersionMigrationPath> listByRelatedBlueprint(String blueprintId) throws IOException {
        try {
            return this.querydslJdbcTemplate.query((SQLQuery)this.buildSelectQuery().where((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationBlueprintIdFrom.eq((Object)blueprintId).or((Predicate)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationBlueprintIdTo.eq((Object)blueprintId))), this.blueprintVersionMigrationPathRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    protected String getId(BlueprintVersionMigrationPath item) {
        return item.id;
    }

    private SQLQuery<Object> buildSelectQuery() {
        return (SQLQuery)this.sqlQueryFactory.select(QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths.blueprintVersionMigrationJson).from((Expression)QBlueprintVersionMigrationPaths.blueprintVersionMigrationPaths);
    }
}

