/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.roles;

import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.roles.Role;
import com.dataiku.gh.core.storage.roles.IRoleDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.model.QRoles;
import com.dataiku.gh.core.storage.sql.model.QRolesHistory;
import com.dataiku.gh.core.storage.sql.roles.RoleRowMapper;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class RoleDAO
extends AbstractItemBasedDAO<String, Role, Role>
implements IRoleDAO {
    @Autowired
    private RoleRowMapper roleRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.ROLE;
    }

    @Override
    protected String getId(Role item) {
        return item.id;
    }

    @Override
    protected boolean sqlExists(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QRoles.roles)).where((Predicate)QRoles.roles.roleId.eq((Object)id));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    protected void sqlLock(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QRoles.roles)).where((Predicate)QRoles.roles.roleId.eq((Object)id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected int sqlCreate(Role item) {
        SQLInsertClause query = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QRoles.roles).columns(new Path[]{QRoles.roles.roleJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlCreateRevision(String id, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)this.buildSelectQuery().where((Predicate)QRoles.roles.roleId.eq((Object)id));
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QRolesHistory.rolesHistory).set(QRolesHistory.rolesHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QRolesHistory.rolesHistory.roleJson, (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlSave(Role item) {
        SQLUpdateClause query = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QRoles.roles).set(QRoles.roles.roleJson, QueryBuilderUtils.toJsonb(item))).where((Predicate)QRoles.roles.roleId.eq((Object)item.id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlDelete(String id) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QRoles.roles).where((Predicate)QRoles.roles.roleId.eq((Object)id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected Role sqlGet(String id) {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QRoles.roles.roleId.eq((Object)id));
        return this.querydslJdbcTemplate.queryForObject(query, this.roleRowMapper);
    }

    @Override
    protected Stream<Role> sqlListStream() {
        return this.querydslJdbcTemplate.queryForStream(this.buildSelectQuery(), this.roleRowMapper);
    }

    private SQLQuery<Object> buildSelectQuery() {
        return (SQLQuery)this.sqlQueryFactory.select(QRoles.roles.roleJson).from((Expression)QRoles.roles);
    }
}

