/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.search;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.search.ArtifactFilter;
import com.dataiku.gh.core.models.search.ArtifactSearchSort;
import com.dataiku.gh.core.models.search.ArtifactSearchSourceConfig;
import com.dataiku.gh.core.storage.search.IArtifactSearchDAO;
import com.dataiku.gh.core.storage.sql.artifacts.PartialEnrichedArtifactRowMapper;
import com.dataiku.gh.core.storage.sql.model.QPartialEnrichedArtifacts;
import com.dataiku.gh.core.storage.sql.search.AbstractArtifactSearchDAO;
import com.dataiku.gh.core.storage.sql.search.PartialEnrichedArtifact;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.google.common.annotations.VisibleForTesting;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.RelationalPathBase;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.stereotype.Service;

@Service
public class ArtifactSearchDAO
extends AbstractArtifactSearchDAO
implements IArtifactSearchDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.artifact-search");
    @Autowired
    private PartialEnrichedArtifactRowMapper partialEnrichedArtifactRowMapper;

    @Override
    protected RelationalPathBase<?> getRelationalPathBase() {
        return QPartialEnrichedArtifacts.partialEnrichedArtifacts;
    }

    protected StringPath getArtifactIdPath() {
        return QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactId;
    }

    @Override
    protected StringExpression getArtifactBlueprintIdPath() {
        return QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactBlueprintId;
    }

    @Override
    protected StringExpression getArtifactVersionIdPath() {
        return QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactVersionId;
    }

    @Override
    protected Expression<Object> getArtifactJsonWithoutRelationshipsPath() {
        return QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactJsonWithoutRelationships;
    }

    @Override
    protected Expression<Object> getArtifactJsonWithRelationshipsPath() {
        return QPartialEnrichedArtifacts.partialEnrichedArtifacts.artifactJsonWithRelationships;
    }

    @Override
    protected Expression<Object> getBlueprintVersionJsonPath() {
        return QPartialEnrichedArtifacts.partialEnrichedArtifacts.blueprintVersionJson;
    }

    @Override
    protected Expression<Object> getSignoffsPath() {
        return QPartialEnrichedArtifacts.partialEnrichedArtifacts.signoffs;
    }

    protected StringPath getUserMappingUserLoginPath() {
        return QPartialEnrichedArtifacts.partialEnrichedArtifacts.userMappingUserLogin;
    }

    protected StringPath getGroupMappingGroupNamePath() {
        return QPartialEnrichedArtifacts.partialEnrichedArtifacts.groupMappingGroupName;
    }

    protected StringPath getGlobalApiKeyMappingApiKeyIdPath() {
        return QPartialEnrichedArtifacts.partialEnrichedArtifacts.globalApiKeyMappingApiKeyId;
    }

    @Override
    protected Expression<?> getFromExpressionClause(@Nullable Long timestamp) {
        return QPartialEnrichedArtifacts.partialEnrichedArtifacts;
    }

    @Override
    public Stream<PartialEnrichedArtifact> searchStream(ArtifactSearchSourceConfig.ArtifactSearchSource artifactSearchSource, @Nullable List<ArtifactFilter> artifactFilters, @Nullable ArtifactSearchSort artifactSearchSort, @Nullable String lastArtifactId) throws IOException {
        if (artifactSearchSource.isSearchSourceEmpty() || this.doArtifactFiltersImplyEmptyResultSet(artifactFilters)) {
            return Stream.empty();
        }
        try {
            SQLQuery<?> sqlQuery = this.buildSqlQuery(artifactSearchSource, artifactFilters, artifactSearchSort, lastArtifactId);
            return this.querydslJdbcTemplate.queryForStream(sqlQuery, this.partialEnrichedArtifactRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @VisibleForTesting
    public SQLQuery<?> buildSqlQuery(ArtifactSearchSourceConfig.ArtifactSearchSource artifactSearchSource, List<ArtifactFilter> artifactFilters, @Nullable ArtifactSearchSort artifactSearchSort, @Nullable String lastArtifactId) {
        SQLQuery sqlQuery = this.buildQueryWithArtifactSource(artifactSearchSource, null);
        this.enrichQueryWithFilters(sqlQuery, artifactFilters, null);
        this.enrichQueryWithSort(sqlQuery, artifactSearchSort);
        this.enrichQueryWithPartialEnrichedArtifactProjection(sqlQuery);
        if (StringUtils.isNotBlank((CharSequence)lastArtifactId)) {
            SQLQuery baseQuery = sqlQuery;
            PathBuilder baseQueryPath = new PathBuilder(Tuple.class, "base");
            PathBuilder rowNumberPath = new PathBuilder(Tuple.class, "rowNumber");
            String rowNumberColumn = "row_number";
            sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.query().with((Path)baseQueryPath, baseQuery)).with((Path)rowNumberPath, (SubQueryExpression)SQLExpressions.select((Expression[])new Expression[]{QueryBuilderUtils.allStar(baseQueryPath), Expressions.numberTemplate(Long.class, (String)"row_number() over()", (Object[])new Object[0]).as(rowNumberColumn)}).from((Expression)baseQueryPath))).select(QueryBuilderUtils.allStar(rowNumberPath)).from((Expression)rowNumberPath)).where((Predicate)rowNumberPath.getComparable(rowNumberColumn, Long.class).gt((Expression)((SQLQuery)((SQLQuery)SQLExpressions.select((Expression)rowNumberPath.getComparable(rowNumberColumn, Long.class)).from((Expression)rowNumberPath)).where((Predicate)rowNumberPath.getString("artifact_id").eq((Object)lastArtifactId))).limit(1L)));
        }
        return sqlQuery;
    }

    @Override
    public long searchCount(ArtifactSearchSourceConfig.ArtifactSearchSource artifactSearchSource, @Nullable List<ArtifactFilter> artifactFilters) throws IOException {
        if (artifactSearchSource.isSearchSourceEmpty() || this.doArtifactFiltersImplyEmptyResultSet(artifactFilters)) {
            return 0L;
        }
        try {
            SQLQuery<?> sqlQuery = this.buildQueryWithArtifactSource(artifactSearchSource, null);
            this.enrichQueryWithFilters(sqlQuery, artifactFilters, null);
            sqlQuery.select((Expression)SQLExpressions.count());
            return this.querydslJdbcTemplate.queryForObject(sqlQuery, Long.class);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private void enrichQueryWithPartialEnrichedArtifactProjection(SQLQuery<?> sqlQuery) {
        sqlQuery.select(PartialEnrichedArtifactRowMapper.COLUMNS);
    }
}

