/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.signoff;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.signoff.EnrichedSignoff;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.models.signoff.SignoffId;
import com.dataiku.gh.core.models.signoff.SignoffIdAndBPVId;
import com.dataiku.gh.core.models.signoff.search.SignoffPagination;
import com.dataiku.gh.core.models.signoff.search.SignoffSearchConfig;
import com.dataiku.gh.core.storage.signoff.ISignoffDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.model.QArtifacts;
import com.dataiku.gh.core.storage.sql.model.QSignoffConfigurations;
import com.dataiku.gh.core.storage.sql.model.QSignoffs;
import com.dataiku.gh.core.storage.sql.model.QSignoffsHistory;
import com.dataiku.gh.core.storage.sql.signoff.EnrichedSignoffRowMapper;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.dataiku.gh.core.utils.DateUtils;
import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DateTemplate;
import com.querydsl.core.types.dsl.DateTimeTemplate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.sql.Date;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class SignoffDAO
extends AbstractItemBasedDAO<SignoffId, Signoff, EnrichedSignoff>
implements ISignoffDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.artifact-signoffs");
    @Autowired
    private EnrichedSignoffRowMapper enrichedSignoffRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.SIGNOFF;
    }

    @Override
    protected SignoffId getId(Signoff item) {
        return item.signoffId;
    }

    @Override
    protected boolean sqlExists(SignoffId id) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QSignoffs.signoffs)).where((Predicate)SignoffDAO.buildWhereCond(id));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    protected void sqlLock(SignoffId id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QSignoffs.signoffs)).where((Predicate)SignoffDAO.buildWhereCond(id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected int sqlCreate(Signoff item) {
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QSignoffs.signoffs).columns(new Path[]{QSignoffs.signoffs.signoffJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlCreateRevision(SignoffId id, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QSignoffs.signoffs.signoffJson).from((Expression)QSignoffs.signoffs)).where((Predicate)SignoffDAO.buildWhereCond(id));
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QSignoffsHistory.signoffsHistory).set(QSignoffsHistory.signoffsHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QSignoffsHistory.signoffsHistory.signoffJson, (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlSave(Signoff item) {
        SQLUpdateClause query = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QSignoffs.signoffs).set(QSignoffs.signoffs.signoffJson, QueryBuilderUtils.toJsonb(item))).where((Predicate)SignoffDAO.buildWhereCond(item));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlDelete(SignoffId id) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QSignoffs.signoffs).where((Predicate)SignoffDAO.buildWhereCond(id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected EnrichedSignoff sqlGet(SignoffId id) {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)SignoffDAO.buildWhereCond(id));
        return this.querydslJdbcTemplate.queryForObject(query, this.enrichedSignoffRowMapper);
    }

    @Override
    protected Stream<EnrichedSignoff> sqlListStream() {
        return this.querydslJdbcTemplate.queryForStream(this.buildSelectQuery(), this.enrichedSignoffRowMapper);
    }

    @Override
    public void lockByArtifact(String artifactId) throws DataStoreIOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QSignoffs.signoffs)).where((Predicate)QSignoffs.signoffs.signoffArtifactId.eq((Object)artifactId))).forUpdate();
            this.querydslJdbcTemplate.queryForList(query);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<EnrichedSignoff> listByArtifact(String artifactId) throws DataStoreIOException {
        try {
            SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QSignoffs.signoffs.signoffArtifactId.eq((Object)artifactId));
            return this.querydslJdbcTemplate.query(query, this.enrichedSignoffRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public Stream<EnrichedSignoff> listForNonExistingSteps(BlueprintVersionId blueprintVersionId, List<String> existingStepIds) throws DataStoreIOException {
        try {
            SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QSignoffs.signoffs.signoffBlueprintId.eq((Object)blueprintVersionId.blueprintId).and((Predicate)QSignoffs.signoffs.signoffVersionId.eq((Object)blueprintVersionId.versionId)).and((Predicate)QSignoffs.signoffs.signoffStepId.notIn(existingStepIds)));
            return this.querydslJdbcTemplate.queryForStream(query, this.enrichedSignoffRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<EnrichedSignoff> listByJsonContainingJsonToken(String token) throws DataStoreIOException {
        try {
            SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QueryBuilderUtils.castColumnToString(QSignoffs.signoffs.signoffJson).contains(String.format("\"%s\"", token)));
            return this.querydslJdbcTemplate.query(query, this.enrichedSignoffRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<SignoffIdAndBPVId> findScheduledSignoffsToReset() throws DataStoreIOException {
        try {
            SQLQuery<?> query = this.buildSelectSignoffIdToResetQuery();
            return this.querydslJdbcTemplate.query(query, (rs, i) -> SignoffIdAndBPVId.build(BlueprintVersionId.build(rs.getString("blueprintId"), rs.getString("versionId")), rs.getString(ColumnMetadata.getName((Path)QSignoffs.signoffs.signoffArtifactId)), rs.getString(ColumnMetadata.getName((Path)QSignoffs.signoffs.signoffStepId))));
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public boolean isSignoffScheduledToReset(SignoffId signoffId) throws DataStoreIOException {
        try {
            SQLQuery query = (SQLQuery)this.buildSelectSignoffIdToResetQuery().select(Expressions.constant((Object)1)).where((Predicate)SignoffDAO.buildWhereCond(signoffId));
            return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public Stream<EnrichedSignoff> searchSignoffsStream(SignoffSearchConfig signoffSearchConfig, SignoffPagination signoffPagination) throws DataStoreIOException {
        try {
            SQLQuery<?> query = this.buildSelectQueryWithPagination(signoffSearchConfig, signoffPagination);
            return this.querydslJdbcTemplate.queryForStream(query, this.enrichedSignoffRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private SQLQuery<Tuple> buildSelectQuery() {
        return (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(new Expression[]{QSignoffConfigurations.signoffConfigurations.signoffConfigurationJson, QSignoffs.signoffs.signoffJson, QSignoffs.signoffs.signoffArtifactId, QSignoffs.signoffs.signoffStepId, QArtifacts.artifacts.artifactBlueprintId, QArtifacts.artifacts.artifactVersionId}).from((Expression)QSignoffs.signoffs)).join((EntityPath)QArtifacts.artifacts)).on((Predicate)QSignoffs.signoffs.signoffArtifactId.eq((Expression)QArtifacts.artifacts.artifactId))).leftJoin((EntityPath)QSignoffConfigurations.signoffConfigurations)).on((Predicate)QSignoffConfigurations.signoffConfigurations.signoffConfigurationBlueprintId.eq((Expression)QArtifacts.artifacts.artifactBlueprintId).and((Predicate)QSignoffConfigurations.signoffConfigurations.signoffConfigurationVersionId.eq((Expression)QArtifacts.artifacts.artifactVersionId)).and((Predicate)QSignoffs.signoffs.signoffStepId.eq((Expression)QSignoffConfigurations.signoffConfigurations.signoffConfigurationStepId)));
    }

    private SQLQuery<?> buildSelectQueryWithPagination(SignoffSearchConfig signoffSearchConfig, SignoffPagination signoffPagination) {
        SQLQuery sqlQuery = this.buildSelectQuery();
        if (!CollectionUtils.isEmpty(signoffSearchConfig.signoffStatuses)) {
            BooleanBuilder booleanBuilder = new BooleanBuilder();
            signoffSearchConfig.signoffStatuses.forEach(status -> booleanBuilder.or((Predicate)QueryBuilderUtils.jsonString(QSignoffs.signoffs.signoffJson, new String[]{"status"}).eq((Object)status.toString())));
            sqlQuery.where((Predicate)booleanBuilder);
        }
        if (!signoffSearchConfig.includeArchivedArtifacts) {
            sqlQuery.where((Predicate)QueryBuilderUtils.jsonString(QArtifacts.artifacts.artifactJson, new String[]{"status", "archived"}).eq((Object)"false"));
        }
        DateTimeTemplate exprDateTime = Expressions.dateTimeTemplate(OffsetDateTime.class, (String)"{0}", (Object[])new Object[]{QueryBuilderUtils.jsonString(QSignoffs.signoffs.signoffJson, new String[]{"statusDate"})});
        sqlQuery.orderBy(exprDateTime.desc());
        if (signoffPagination.lastSignoffId != null) {
            SQLQuery baseQuery = sqlQuery;
            PathBuilder baseQueryPath = new PathBuilder(Tuple.class, "base");
            PathBuilder rowNumberPath = new PathBuilder(Tuple.class, "rowNumber");
            String rowNumberColumn = "row_number";
            SignoffId lastSignoffId = signoffPagination.lastSignoffId;
            sqlQuery = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.query().with((Path)baseQueryPath, baseQuery)).with((Path)rowNumberPath, (SubQueryExpression)SQLExpressions.select((Expression[])new Expression[]{QueryBuilderUtils.allStar(baseQueryPath), Expressions.numberTemplate(Long.class, (String)"row_number() over()", (Object[])new Object[0]).as(rowNumberColumn)}).from((Expression)baseQueryPath))).select(QueryBuilderUtils.allStar(rowNumberPath)).from((Expression)rowNumberPath)).where((Predicate)rowNumberPath.getComparable(rowNumberColumn, Long.class).gt((Expression)((SQLQuery)SQLExpressions.select((Expression)rowNumberPath.getComparable(rowNumberColumn, Long.class)).from((Expression)rowNumberPath)).where((Predicate)rowNumberPath.getString("signoff_artifact_id").eq((Object)lastSignoffId.artifactId).and((Predicate)rowNumberPath.getString("signoff_step_id").eq((Object)lastSignoffId.stepId)))));
        }
        return sqlQuery;
    }

    private SQLQuery<?> buildSelectSignoffIdToResetQuery() {
        DateTemplate nextOccurrenceExpr = Expressions.dateTemplate(Date.class, (String)"{0s} + {1s}", (Object[])new Object[]{QueryBuilderUtils.castToDate(QueryBuilderUtils.jsonString(QSignoffs.signoffs.signoffJson, new String[]{"statusDate"})), Expressions.stringTemplate((String)"make_interval({0s}, {1s}, {2s}, {3s})", (Object[])new Object[]{QueryBuilderUtils.castToInt(QueryBuilderUtils.jsonObject(QSignoffs.signoffs.signoffJson, new String[]{"configuration", "recurrenceConfiguration", "years"})), QueryBuilderUtils.castToInt(QueryBuilderUtils.jsonObject(QSignoffs.signoffs.signoffJson, new String[]{"configuration", "recurrenceConfiguration", "months"})), QueryBuilderUtils.castToInt(QueryBuilderUtils.jsonObject(QSignoffs.signoffs.signoffJson, new String[]{"configuration", "recurrenceConfiguration", "weeks"})), QueryBuilderUtils.castToInt(QueryBuilderUtils.jsonObject(QSignoffs.signoffs.signoffJson, new String[]{"configuration", "recurrenceConfiguration", "days"}))})});
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(new Expression[]{QArtifacts.artifacts.artifactBlueprintId, QArtifacts.artifacts.artifactVersionId, QSignoffs.signoffs.signoffArtifactId, QSignoffs.signoffs.signoffStepId}).from((Expression)QSignoffs.signoffs)).join((EntityPath)QArtifacts.artifacts)).on((Predicate)QArtifacts.artifacts.artifactId.eq((Expression)QSignoffs.signoffs.signoffArtifactId))).where(new Predicate[]{QSignoffs.signoffs.signoffStepId.eq((Expression)QueryBuilderUtils.jsonString(QArtifacts.artifacts.artifactJson, new String[]{"status", "stepId"})), QueryBuilderUtils.jsonString(QSignoffs.signoffs.signoffJson, new String[]{"status"}).eq((Object)"APPROVED"), QueryBuilderUtils.jsonString(QSignoffs.signoffs.signoffJson, new String[]{"configuration", "recurrenceConfiguration", "activated"}).eq((Object)"true"), QueryBuilderUtils.castToDate(Expressions.constant((Object)DateUtils.now())).goe((Expression)nextOccurrenceExpr)});
        return query;
    }

    private static BooleanExpression buildWhereCond(Signoff item) {
        return SignoffDAO.buildWhereCond(item.signoffId);
    }

    private static BooleanExpression buildWhereCond(SignoffId signoffId) {
        return QSignoffs.signoffs.signoffArtifactId.eq((Object)signoffId.artifactId).and((Predicate)QSignoffs.signoffs.signoffStepId.eq((Object)signoffId.stepId));
    }
}

