/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.signoff;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.signoff.SignoffConfiguration;
import com.dataiku.gh.core.models.signoff.SignoffConfigurationId;
import com.dataiku.gh.core.storage.signoff.ISignoffsConfigurationsDAO;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.model.QSignoffConfigurations;
import com.dataiku.gh.core.storage.sql.model.QSignoffConfigurationsHistory;
import com.dataiku.gh.core.storage.sql.signoff.SignoffConfigurationRowMapper;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.DslExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class SignoffsConfigurationsDAO
extends AbstractItemBasedDAO<SignoffConfigurationId, SignoffConfiguration, SignoffConfiguration>
implements ISignoffsConfigurationsDAO {
    @Autowired
    private SignoffConfigurationRowMapper signoffConfigurationRowMapper;
    public static final String SIGNOFFS_CONFIGURATIONS_BY_BLUEPRINT_VERSION_SUBQUERY_ALIAS = "signoffs_configurations_by_blueprint_version_subquery_alias";
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.signoffs-configurations");

    @Override
    protected EntityType getEntityType() {
        return EntityType.SIGNOFF_CONFIGURATION;
    }

    @Override
    protected SignoffConfigurationId getId(SignoffConfiguration item) {
        return item.id;
    }

    @Override
    protected boolean sqlExists(SignoffConfigurationId id) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QSignoffConfigurations.signoffConfigurations)).where((Predicate)this.equalsSignoffConfigurationId(id));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    protected void sqlLock(SignoffConfigurationId id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QSignoffConfigurations.signoffConfigurations)).where((Predicate)this.equalsSignoffConfigurationId(id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected int sqlCreate(SignoffConfiguration item) {
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QSignoffConfigurations.signoffConfigurations).columns(new Path[]{QSignoffConfigurations.signoffConfigurations.signoffConfigurationJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlCreateRevision(SignoffConfigurationId id, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)this.buildSelectQuery().where((Predicate)this.equalsSignoffConfigurationId(id));
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QSignoffConfigurationsHistory.signoffConfigurationsHistory).set(QSignoffConfigurationsHistory.signoffConfigurationsHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QSignoffConfigurationsHistory.signoffConfigurationsHistory.signoffConfigurationJson, (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlSave(SignoffConfiguration item) {
        SQLUpdateClause query = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QSignoffConfigurations.signoffConfigurations).set(QSignoffConfigurations.signoffConfigurations.signoffConfigurationJson, QueryBuilderUtils.toJsonb(item))).where((Predicate)this.equalsSignoffConfigurationId(item.id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlDelete(SignoffConfigurationId id) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QSignoffConfigurations.signoffConfigurations).where((Predicate)this.equalsSignoffConfigurationId(id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected SignoffConfiguration sqlGet(SignoffConfigurationId id) {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)this.equalsSignoffConfigurationId(id));
        return this.querydslJdbcTemplate.queryForObject(query, this.signoffConfigurationRowMapper);
    }

    @Override
    protected Stream<SignoffConfiguration> sqlListStream() {
        return this.querydslJdbcTemplate.queryForStream(this.buildSelectQuery(), this.signoffConfigurationRowMapper);
    }

    @Override
    public List<SignoffConfiguration> listByBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        try {
            SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId));
            return this.querydslJdbcTemplate.query(query, this.signoffConfigurationRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void lockByBlueprintVersion(BlueprintVersionId blueprintVersionId) throws IOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QSignoffConfigurations.signoffConfigurations)).where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId))).forUpdate();
            this.querydslJdbcTemplate.queryForList(query);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<SignoffConfiguration> listForNonExistingSteps(BlueprintVersionId blueprintVersionId, List<String> existingStepIds) throws IOException {
        try {
            SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)this.equalsBlueprintVersionId(blueprintVersionId).and((Predicate)QSignoffConfigurations.signoffConfigurations.signoffConfigurationStepId.notIn(existingStepIds)));
            return this.querydslJdbcTemplate.query(query, this.signoffConfigurationRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private BooleanExpression equalsBlueprintVersionId(BlueprintVersionId id) {
        return QSignoffConfigurations.signoffConfigurations.signoffConfigurationBlueprintId.eq((Object)id.blueprintId).and((Predicate)QSignoffConfigurations.signoffConfigurations.signoffConfigurationVersionId.eq((Object)id.versionId));
    }

    private BooleanExpression equalsSignoffConfigurationId(SignoffConfigurationId id) {
        return this.equalsBlueprintVersionId(id.blueprintVersionId).and((Predicate)QSignoffConfigurations.signoffConfigurations.signoffConfigurationStepId.eq((Object)id.stepId));
    }

    private SQLQuery<Object> buildSelectQuery() {
        return (SQLQuery)this.sqlQueryFactory.select(QSignoffConfigurations.signoffConfigurations.signoffConfigurationJson).from((Expression)QSignoffConfigurations.signoffConfigurations);
    }

    public static DslExpression<?> buildSignoffsConfigurationsByBlueprintVersionSubQuery(Expression<String> blueprintId, Expression<String> versionId) {
        return QueryBuilderUtils.coalesceToJsonbEmptyArray((Expression)((SQLQuery)((SQLQuery)SQLExpressions.select(QueryBuilderUtils.jsonAgg(QSignoffConfigurations.signoffConfigurations.signoffConfigurationJson, null)).from((Expression)QSignoffConfigurations.signoffConfigurations)).where((Predicate)QSignoffConfigurations.signoffConfigurations.signoffConfigurationBlueprintId.eq(blueprintId).and((Predicate)QSignoffConfigurations.signoffConfigurations.signoffConfigurationVersionId.eq(versionId)))).groupBy(new Expression[]{QSignoffConfigurations.signoffConfigurations.signoffConfigurationBlueprintId, QSignoffConfigurations.signoffConfigurations.signoffConfigurationVersionId})).as(SIGNOFFS_CONFIGURATIONS_BY_BLUEPRINT_VERSION_SUBQUERY_ALIAS);
    }
}

