/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.subscriptions;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.subscriptions.Subscription;
import com.dataiku.gh.core.models.subscriptions.SubscriptionId;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.model.QArtifactSubscriptions;
import com.dataiku.gh.core.storage.sql.model.QArtifactSubscriptionsHistory;
import com.dataiku.gh.core.storage.sql.subscriptions.SubscriptionRowMapper;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.dataiku.gh.core.storage.subscriptions.ISubscriptionDAO;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public class SubscriptionDAO
extends AbstractItemBasedDAO<SubscriptionId, Subscription, Subscription>
implements ISubscriptionDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.artifact-subscriptions");
    @Autowired
    private SubscriptionRowMapper subscriptionsRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.SUBSCRIPTION;
    }

    @Override
    protected SubscriptionId getId(Subscription item) {
        return item.subscriptionId;
    }

    @Override
    protected boolean sqlExists(SubscriptionId id) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QArtifactSubscriptions.artifactSubscriptions)).where((Predicate)SubscriptionDAO.buildWhereCond(id));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    protected void sqlLock(SubscriptionId id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QArtifactSubscriptions.artifactSubscriptions)).where((Predicate)SubscriptionDAO.buildWhereCond(id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected int sqlCreate(Subscription item) {
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QArtifactSubscriptions.artifactSubscriptions).columns(new Path[]{QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlCreateRevision(SubscriptionId id, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionJson).from((Expression)QArtifactSubscriptions.artifactSubscriptions)).where((Predicate)SubscriptionDAO.buildWhereCond(id));
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QArtifactSubscriptionsHistory.artifactSubscriptionsHistory).set(QArtifactSubscriptionsHistory.artifactSubscriptionsHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QArtifactSubscriptionsHistory.artifactSubscriptionsHistory.artifactSubscriptionJson, (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlSave(Subscription item) {
        SQLUpdateClause query = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QArtifactSubscriptions.artifactSubscriptions).set(QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionJson, QueryBuilderUtils.toJsonb(item))).where((Predicate)SubscriptionDAO.buildWhereCond(item));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlDelete(SubscriptionId id) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QArtifactSubscriptions.artifactSubscriptions).where((Predicate)SubscriptionDAO.buildWhereCond(id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected Subscription sqlGet(SubscriptionId id) {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)SubscriptionDAO.buildWhereCond(id));
        return this.querydslJdbcTemplate.queryForObject(query, this.subscriptionsRowMapper);
    }

    @Override
    public List<Subscription> listForUser(String userLogin) throws DataStoreIOException {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionUserLogin.eq((Object)userLogin));
        try {
            return this.querydslJdbcTemplate.query(query, this.subscriptionsRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<Subscription> listForArtifact(String artifactId) throws DataStoreIOException {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionArtifactId.eq((Object)artifactId));
        try {
            return this.querydslJdbcTemplate.query(query, this.subscriptionsRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<Subscription> listForArtifacts(List<String> artifactIds) throws DataStoreIOException {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionArtifactId.in(artifactIds));
        try {
            return this.querydslJdbcTemplate.query(query, this.subscriptionsRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public List<Subscription> listForUserAndArtifacts(String userLogin, List<String> artifactIds) throws DataStoreIOException {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionUserLogin.eq((Object)userLogin).and((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionArtifactId.in(artifactIds)));
        try {
            return this.querydslJdbcTemplate.query(query, this.subscriptionsRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    public void lockByArtifact(String artifactId) throws DataStoreIOException {
        try {
            SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QArtifactSubscriptions.artifactSubscriptions)).where((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionArtifactId.eq((Object)artifactId))).forUpdate();
            this.querydslJdbcTemplate.queryForList(query);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    @Override
    protected Stream<Subscription> sqlListStream() {
        return this.querydslJdbcTemplate.queryForStream(this.buildSelectQuery(), this.subscriptionsRowMapper);
    }

    private SQLQuery<Object> buildSelectQuery() {
        return (SQLQuery)this.sqlQueryFactory.select(QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionJson).from((Expression)QArtifactSubscriptions.artifactSubscriptions);
    }

    private static BooleanExpression buildWhereCond(Subscription item) {
        return SubscriptionDAO.buildWhereCond(item.subscriptionId);
    }

    private static BooleanExpression buildWhereCond(SubscriptionId subscriptionId) {
        return QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionArtifactId.eq((Object)subscriptionId.artifactId).and((Predicate)QArtifactSubscriptions.artifactSubscriptions.artifactSubscriptionUserLogin.eq((Object)subscriptionId.userLogin));
    }
}

