/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.user_config;

import com.dataiku.dip.exceptions.DataStoreIOException;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.EntityType;
import com.dataiku.gh.core.models.history.HistoryRevision;
import com.dataiku.gh.core.models.user_config.UserConfiguration;
import com.dataiku.gh.core.storage.sql.AbstractItemBasedDAO;
import com.dataiku.gh.core.storage.sql.model.QUserConfiguration;
import com.dataiku.gh.core.storage.sql.model.QUserConfigurationHistory;
import com.dataiku.gh.core.storage.sql.user_config.UserConfigurationRowMapper;
import com.dataiku.gh.core.storage.sql.utils.QueryBuilderUtils;
import com.dataiku.gh.core.storage.user_config.IUserConfigurationDAO;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanTemplate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.SimpleTemplate;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.AbstractSQLClause;
import com.querydsl.sql.dml.SQLDeleteClause;
import com.querydsl.sql.dml.SQLInsertClause;
import com.querydsl.sql.dml.SQLUpdateClause;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.SingleColumnRowMapper;

public class UserConfigurationDAO
extends AbstractItemBasedDAO<String, UserConfiguration, UserConfiguration>
implements IUserConfigurationDAO {
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.storage.user_config");
    @Autowired
    private UserConfigurationRowMapper userConfigurationRowMapper;

    @Override
    protected EntityType getEntityType() {
        return EntityType.USER_CONFIGURATION;
    }

    @Override
    protected String getId(UserConfiguration item) {
        return item.userIdentifier;
    }

    @Override
    protected boolean sqlExists(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QUserConfiguration.userConfiguration)).where((Predicate)QUserConfiguration.userConfiguration.userConfigurationId.eq((Object)id));
        return !this.querydslJdbcTemplate.query((SQLQuery<?>)query, new SingleColumnRowMapper(String.class)).isEmpty();
    }

    @Override
    protected void sqlLock(String id) {
        SQLQuery query = (SQLQuery)((SQLQuery)((SQLQuery)this.sqlQueryFactory.select(Expressions.constant((Object)1)).from((Expression)QUserConfiguration.userConfiguration)).where((Predicate)QUserConfiguration.userConfiguration.userConfigurationId.eq((Object)id))).forUpdate();
        this.querydslJdbcTemplate.queryForList(query);
    }

    @Override
    protected int sqlCreate(UserConfiguration item) {
        SQLInsertClause query = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QUserConfiguration.userConfiguration).columns(new Path[]{QUserConfiguration.userConfiguration.userConfigurationJson})).values(new Object[]{QueryBuilderUtils.toJsonbAsExpression(item)});
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlCreateRevision(String id, HistoryRevision revision) {
        SQLQuery selectData = (SQLQuery)this.buildSelectQuery().where((Predicate)QUserConfiguration.userConfiguration.userConfigurationId.eq((Object)id));
        SQLInsertClause insert = (SQLInsertClause)((SQLInsertClause)this.sqlQueryFactory.insert((RelationalPath)QUserConfigurationHistory.userConfigurationHistory).set(QUserConfigurationHistory.userConfigurationHistory._revisionJson, QueryBuilderUtils.toJsonb(revision))).set(QUserConfigurationHistory.userConfigurationHistory.userConfigurationJson, (Object)selectData);
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)insert);
    }

    @Override
    protected int sqlSave(UserConfiguration item) {
        SQLUpdateClause query = (SQLUpdateClause)((SQLUpdateClause)this.sqlQueryFactory.update((RelationalPath)QUserConfiguration.userConfiguration).set(QUserConfiguration.userConfiguration.userConfigurationJson, QueryBuilderUtils.toJsonb(item))).where((Predicate)QUserConfiguration.userConfiguration.userConfigurationId.eq((Object)item.userIdentifier));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected int sqlDelete(String id) {
        SQLDeleteClause query = (SQLDeleteClause)this.sqlQueryFactory.delete((RelationalPath)QUserConfiguration.userConfiguration).where((Predicate)QUserConfiguration.userConfiguration.userConfigurationId.eq((Object)id));
        return this.querydslJdbcTemplate.update((AbstractSQLClause<?>)query);
    }

    @Override
    protected UserConfiguration sqlGet(String id) {
        SQLQuery query = (SQLQuery)this.buildSelectQuery().where((Predicate)QUserConfiguration.userConfiguration.userConfigurationId.eq((Object)id));
        return this.querydslJdbcTemplate.queryForObject(query, this.userConfigurationRowMapper);
    }

    @Override
    protected Stream<UserConfiguration> sqlListStream() {
        SQLQuery<Object> query = this.buildSelectQuery();
        return this.querydslJdbcTemplate.queryForStream(query, this.userConfigurationRowMapper);
    }

    @Override
    public List<UserConfiguration> getAndLockConfigWithPageId(String pageId) throws IOException {
        SimpleTemplate<Object> fieldExpr = QueryBuilderUtils.jsonObjectDefaultSQLNull(QUserConfiguration.userConfiguration.userConfigurationJson, new String[]{"pages", pageId});
        BooleanTemplate booleanExpression = QueryBuilderUtils.jsonPathExists(fieldExpr, "strict $");
        SQLQuery query = (SQLQuery)((SQLQuery)this.buildSelectQuery().where((Predicate)booleanExpression)).forUpdate();
        try {
            return this.querydslJdbcTemplate.query(query, this.userConfigurationRowMapper);
        }
        catch (DataAccessException e) {
            logger.error((Object)"Cannot reach Dataiku Govern database", (Throwable)e);
            throw new DataStoreIOException("Cannot reach Dataiku Govern database", (Throwable)e);
        }
    }

    private SQLQuery<Object> buildSelectQuery() {
        return (SQLQuery)this.sqlQueryFactory.select(QUserConfiguration.userConfiguration.userConfigurationJson).from((Expression)QUserConfiguration.userConfiguration);
    }
}

