/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.storage.sql.utils;

import com.dataiku.dip.utils.JSON;
import com.querydsl.core.QueryFlag;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanTemplate;
import com.querydsl.core.types.dsl.ComparableExpressionBase;
import com.querydsl.core.types.dsl.ComparableOperation;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.SimpleOperation;
import com.querydsl.core.types.dsl.SimpleTemplate;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.core.types.dsl.StringOperation;
import com.querydsl.core.types.dsl.StringTemplate;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLOps;
import com.querydsl.sql.SQLQuery;
import com.querydsl.sql.dml.SQLInsertClause;
import java.sql.Date;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class QueryBuilderUtils {
    public static final Expression<String> TEXT_EXPRESSION = Expressions.constant((Object)"TEXT");
    public static final Expression<Object> JSONB_EXPRESSION = Expressions.constant((Object)"JSONB");
    public static final Expression<Object> DATE_EXPRESSION = Expressions.constant((Object)"DATE");
    public static final Expression<Object> INT_EXPRESSION = Expressions.constant((Object)"INT");
    public static final StringExpression EMPTY_TEXT_EXPRESSION = Expressions.stringTemplate((String)"''", (Object[])new Object[0]);
    public static final Expression<Object> JSONB_NULL = Expressions.template(Object.class, (String)"'null'::JSONB", (Object[])new Object[0]);
    public static final Expression<Object> JSONB_EMPTY = Expressions.template(Object.class, (String)"'{}'::JSONB", (Object[])new Object[0]);
    public static final Expression<Object> JSONB_EMPTY_ARRAY = Expressions.template(Object.class, (String)"'[]'::JSONB", (Object[])new Object[0]);
    public static final int PARTITION_CHUNK_SIZE = 250;
    private static final String QUOTE = "\"";

    public static SimpleTemplate<Object> jsonObjectDefaultSQLNull(Expression<Object> json, String ... path) {
        return Expressions.template(Object.class, (String)("{0} #> '{" + Arrays.stream(path).map(QueryBuilderUtils::quoteJsonPath).collect(Collectors.joining(",")) + "}'"), (Object[])new Object[]{json});
    }

    public static SimpleTemplate<Object> jsonObject(Expression<Object> json, String ... path) {
        return QueryBuilderUtils.coalesceToJsonbNull(QueryBuilderUtils.jsonObjectDefaultSQLNull(json, path));
    }

    public static SimpleTemplate<Object> jsonObjectDefaultEmpty(Expression<Object> json, String ... path) {
        return QueryBuilderUtils.coalesceToJsonbEmpty(QueryBuilderUtils.jsonObjectDefaultSQLNull(json, path));
    }

    public static StringTemplate jsonString(Expression<Object> json, String ... path) {
        return Expressions.stringTemplate((String)("{0} #>> '{" + Arrays.stream(path).map(QueryBuilderUtils::quoteJsonPath).collect(Collectors.joining(",")) + "}'"), (Object[])new Object[]{json});
    }

    public static SimpleTemplate<String> jsonFirstArrayElementAsText(Expression<Object> json) {
        return Expressions.template(String.class, (String)"{0} ->> 0", (Object[])new Object[]{json});
    }

    public static SimpleTemplate<Object> toJson(Expression<?> value) {
        return Expressions.template(Object.class, (String)"to_jsonb({0})", (Object[])new Object[]{value});
    }

    public static <T extends Comparable<T>> OrderSpecifier<T> order(ComparableExpressionBase<T> expression, boolean isAsc) {
        return isAsc ? expression.asc() : expression.desc();
    }

    public static SQLInsertClause withReturning(SQLInsertClause sqlQuery, Expression<?> ... returningExpr) {
        return (SQLInsertClause)sqlQuery.addFlag(QueryFlag.Position.END, (Expression)Expressions.stringTemplate((String)" RETURNING {0}", (Object[])new Object[]{QueryBuilderUtils.prepareReturningCols(returningExpr)}));
    }

    private static Expression<String> prepareReturningCols(Expression<?> ... returningExpr) {
        String template = IntStream.range(0, returningExpr.length).mapToObj(i -> "{" + i + "}").collect(Collectors.joining(", "));
        List expressions = Arrays.stream(returningExpr).map(expr -> {
            if (expr instanceof Path) {
                return Expressions.stringTemplate((String)QueryBuilderUtils.quoteJsonPath(ColumnMetadata.getName((Path)((Path)expr))), (Object[])new Object[0]);
            }
            if (expr instanceof SubQueryExpression) {
                return Expressions.stringTemplate((String)"({0})", (Object[])new Object[]{expr});
            }
            return expr;
        }).collect(Collectors.toList());
        return Expressions.stringTemplate((String)template, expressions);
    }

    public static Expression<Object> castToJsonb(String jsonString) {
        return Expressions.operation(Object.class, (Operator)SQLOps.CAST, (Expression[])new Expression[]{Expressions.constant((Object)jsonString), JSONB_EXPRESSION});
    }

    public static Object toJsonb(Object obj) {
        return QueryBuilderUtils.toJsonbAsExpression(obj);
    }

    public static Expression<Object> toJsonbAsExpression(Object obj) {
        return QueryBuilderUtils.castToJsonb(JSON.json((Object)obj));
    }

    public static SimpleTemplate<Object> coalesceToJsonbNull(SimpleExpression<?> expression) {
        return QueryBuilderUtils.coalesceTo(expression, JSONB_NULL);
    }

    public static SimpleTemplate<Object> coalesceToJsonbEmpty(SimpleTemplate<?> expression) {
        return QueryBuilderUtils.coalesceTo(expression, JSONB_EMPTY);
    }

    public static SimpleTemplate<Object> coalesceToJsonbEmptyArray(Expression<?> expression) {
        return QueryBuilderUtils.coalesceTo(expression, JSONB_EMPTY_ARRAY);
    }

    public static SimpleTemplate<Object> coalesceTo(Expression<?> expression1, Expression<?> expression2) {
        return Expressions.template(Object.class, (String)"COALESCE({0}, {1s})", (Object[])new Object[]{expression1, expression2});
    }

    public static SimpleTemplate<Object> nullIfJsonbEmptyArray(Expression<?> expression) {
        return Expressions.template(Object.class, (String)"NULLIF({0}, {1s})", (Object[])new Object[]{expression, JSONB_EMPTY_ARRAY});
    }

    public static StringOperation castColumnToString(SimpleExpression<?> path) {
        return Expressions.stringOperation((Operator)SQLOps.CAST, (Expression[])new Expression[]{path, TEXT_EXPRESSION});
    }

    public static String escapeJsonPathForRegex(String s) {
        StringBuilder builder = new StringBuilder(s.length());
        Set charToDoubleEscape = "{}()[]*+?.|^$".chars().mapToObj(c -> Character.valueOf((char)c)).collect(Collectors.toSet());
        for (int i = 0; i < s.length(); ++i) {
            char c2 = s.charAt(i);
            if (charToDoubleEscape.contains(Character.valueOf(c2))) {
                builder.append("\\\\");
                builder.append(c2);
                continue;
            }
            QueryBuilderUtils.escapeSpecialCharacter(builder, Character.valueOf(c2));
        }
        return builder.toString();
    }

    public static String quoteJsonPath(String s) {
        StringBuilder builder = new StringBuilder(s.length() + 2).append(QUOTE);
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            QueryBuilderUtils.escapeSpecialCharacter(builder, Character.valueOf(c));
        }
        builder.append(QUOTE);
        return builder.toString();
    }

    private static void escapeSpecialCharacter(StringBuilder builder, Character c) {
        if ('\"' == c.charValue()) {
            builder.append('\\');
        } else if ('\\' == c.charValue()) {
            builder.append("\\\\\\");
        } else if ('\'' == c.charValue()) {
            builder.append("'");
        }
        builder.append(c);
    }

    public static SimpleTemplate<Object> allStar(Path<?> path) {
        return Expressions.template(Object.class, (String)"{0}.*", (Object[])new Object[]{path});
    }

    public static Expression<?>[] allSortedProjections(RelationalPath<?> relationalPath) {
        return relationalPath.getColumns().stream().map(path -> Pair.of((Object)path, (Object)relationalPath.getMetadata(path))).filter(p -> p.getRight() != null).sorted(Comparator.comparingInt(p -> ((ColumnMetadata)p.getRight()).getIndex())).map(Pair::getLeft).collect(Collectors.toList()).toArray(new Expression[0]);
    }

    public static SimpleExpression<Object> jsonAgg(SimpleExpression<?> expression, @Nullable OrderSpecifier<?> orderBy) {
        return QueryBuilderUtils.jsonAgg(expression, orderBy, false);
    }

    public static SimpleExpression<Object> jsonAgg(SimpleExpression<?> expression, @Nullable OrderSpecifier<?> orderBy, boolean distinct) {
        String distinctTemplate;
        String string = distinctTemplate = distinct ? "DISTINCT " : "";
        if (orderBy != null) {
            return Expressions.template(Object.class, (String)("jsonb_agg(" + distinctTemplate + "{0s} ORDER BY {1s})"), (Object[])new Object[]{expression, orderBy});
        }
        return Expressions.template(Object.class, (String)("jsonb_agg(" + distinctTemplate + "{0s})"), (Object[])new Object[]{expression});
    }

    public static SimpleTemplate<Object> toNonEmptyArrayOrArrayContainingNull(Expression<Object> jsonbExpression) {
        return Expressions.template(Object.class, (String)"jsonb_element_to_jsonb_array_or_array_containing_null({0})", (Object[])new Object[]{jsonbExpression});
    }

    public static SimpleTemplate<Object> jsonBuildArray(Expression<Object> expression) {
        return Expressions.template(Object.class, (String)"jsonb_build_array({0})", (Object[])new Object[]{expression});
    }

    public static SimpleTemplate<Object> jsonArrayElementsText(Expression<Object> jsonbExpression) {
        return Expressions.template(Object.class, (String)"jsonb_array_elements_text({0})", (Object[])new Object[]{jsonbExpression});
    }

    public static BooleanTemplate jsonPathExists(Expression<Object> jsonbExpression, String jsonPath) {
        return Expressions.booleanTemplate((String)("jsonb_path_exists({0}, '" + jsonPath + "')"), (Object[])new Object[]{jsonbExpression});
    }

    public static StringTemplate jsonTypeof(Expression<Object> jsonbExpression) {
        return Expressions.stringTemplate((String)"jsonb_typeof({0})", (Object[])new Object[]{jsonbExpression});
    }

    public static Expression<Object> jsonPathQuery(Expression<Object> json, String jsonPathForQuery) {
        return Expressions.template(Object.class, (String)"jsonb_path_query({0}, '{1s}')", (Object[])new Object[]{json, jsonPathForQuery});
    }

    public static SimpleTemplate jsonPathQueryArray(Expression<Object> jsonbExpression, String jsonPath) {
        return Expressions.template(Object.class, (String)("jsonb_path_query_array({0}, '" + jsonPath + "')"), (Object[])new Object[]{jsonbExpression});
    }

    public static NumberExpression<Integer> jsonArrayLength(Expression<Object> jsonbExpression) {
        return Expressions.numberTemplate(Integer.class, (String)"jsonb_array_length({0})", (Object[])new Object[]{jsonbExpression});
    }

    public static ComparableOperation<Date> castToDate(Expression<?> expr) {
        return Expressions.comparableOperation(Date.class, (Operator)SQLOps.CAST, (Expression[])new Expression[]{expr, DATE_EXPRESSION});
    }

    public static SimpleOperation<Integer> castToInt(Expression<?> expr) {
        return Expressions.operation(Integer.class, (Operator)SQLOps.CAST, (Expression[])new Expression[]{expr, INT_EXPRESSION});
    }

    public static SimpleTemplate<Object> jsonEach(Expression<Object> object) {
        return Expressions.template(Object.class, (String)"JSONB_EACH({0})", (Object[])new Object[]{object});
    }

    public static <T> SQLQuery<T> distinctOn(SQLQuery<T> query, Path<?> path) {
        return (SQLQuery)query.addFlag(QueryFlag.Position.AFTER_SELECT, (Expression)Expressions.template(Object.class, (String)"DISTINCT ON ({0}) ", (Object[])new Object[]{path}));
    }

    public static NumberExpression<Integer> unsafeInQueryConstant(Integer value) {
        return Expressions.numberTemplate(Integer.class, (String)"{0s}", (Object[])new Object[]{value});
    }

    public static NumberExpression<Double> unsafeInQueryConstant(Double value) {
        return Expressions.numberTemplate(Double.class, (String)"{0s}", (Object[])new Object[]{value});
    }

    public static StringExpression unsafeInQueryConstant(Enum<?> enumValue) {
        return Expressions.stringTemplate((String)"'{0s}'", (Object[])new Object[]{enumValue.toString()});
    }

    public static PathBuilder<?> columnWithPrefix(String prefix, Path<?> path) {
        return new PathBuilder(String.class, (String)(StringUtils.isNotBlank((CharSequence)prefix) ? prefix + "_" : "") + ColumnMetadata.getName(path));
    }

    public static Expression<Long> extractTimestampFromPath(Path<?> fromPath, Expression<?> offsetTemplate) {
        return Expressions.template(Long.class, (String)"((((EXTRACT(EPOCH FROM {0}))::DOUBLE PRECISION) * (1000::DOUBLE PRECISION))::BIGINT + {1s})", (Object[])new Object[]{fromPath, offsetTemplate});
    }
}

