/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.utils;

import com.dataiku.gh.core.services.validation.errors.ValidationException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class ValidatorUtils {
    public static void validateThat(boolean condition, String errorMsg, Object ... errorMsgParams) {
        if (!condition) {
            throw new ValidationException(String.format(errorMsg, errorMsgParams));
        }
    }

    public static void validateIsIsoOffsetDateTime(String maybeDate, String errorMsg, Object ... errorMsgParams) {
        try {
            OffsetDateTime.parse(maybeDate, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        }
        catch (NullPointerException | DateTimeParseException e) {
            throw new ValidationException(String.format(errorMsg, errorMsgParams));
        }
    }
}

