/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.security;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.GHAuthCtx;
import com.dataiku.gh.security.IPermissionsService;
import com.dataiku.gh.security.model.GlobalScopePublicAPIKey;
import com.dataiku.gh.server.services.licensing.LicenseEnforcementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionsService
implements IPermissionsService {
    public static final String ALL_USERS_GROUP = "$$ALL_USERS$$";
    @Autowired
    private LicenseEnforcementService licenseEnforcementService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.security.permissions");

    @Override
    public boolean isAdmin(AuthCtx authCtx) {
        return authCtx.isAdmin();
    }

    @Override
    public void checkAdmin(AuthCtx authCtx) throws UnauthorizedException {
        if (!this.isAdmin(authCtx)) {
            throw new UnauthorizedException("Action forbidden, you are not admin", "not-admin");
        }
    }

    @Override
    public void checkAdmin(AuthCtx authCtx, String reason) throws UnauthorizedException {
        if (!this.isAdmin(authCtx)) {
            throw new UnauthorizedException("Action forbidden, you are not admin: " + reason, "not-admin");
        }
    }

    @Override
    public boolean hasAdditionalCloudDataikerAdminPermission(AuthCtx authCtx) throws UnauthorizedException {
        if (!this.isAdmin(authCtx)) {
            return false;
        }
        if (!DKUApp.isDataikuCloud()) {
            return true;
        }
        GHAuthCtx dAuthCtx = (GHAuthCtx)authCtx;
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_PROJECT: {
                throw new AssertionError((Object)"impossible");
            }
            case CONFIGURABLE_API_KEY_GLOBAL: {
                GlobalScopePublicAPIKey cpa = (GlobalScopePublicAPIKey)dAuthCtx.getAsConfigurableAPIKey();
                return cpa.managedKey;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                UsersDAO.GroupPermissions gp = dAuthCtx.getPermissions();
                return gp.dataikerAdmin != null && gp.dataikerAdmin != false;
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    @Override
    public void checkAdditionalCloudDataikerAdminPermission(AuthCtx authCtx) throws UnauthorizedException {
        this.checkAdmin(authCtx);
        if (!DKUApp.isDataikuCloud()) {
            return;
        }
        GHAuthCtx dAuthCtx = (GHAuthCtx)authCtx;
        switch (authCtx.getAuthSource()) {
            case CONFIGURABLE_API_KEY_PROJECT: {
                throw new AssertionError((Object)"impossible");
            }
            case CONFIGURABLE_API_KEY_GLOBAL: {
                GlobalScopePublicAPIKey cpa = (GlobalScopePublicAPIKey)dAuthCtx.getAsConfigurableAPIKey();
                if (!cpa.managedKey.booleanValue()) {
                    throw new UnauthorizedException("Action forbidden", "not-super-admin");
                }
                return;
            }
            case PERSONAL_API_KEY: 
            case USER_FROM_UI: {
                UsersDAO.GroupPermissions gp = dAuthCtx.getPermissions();
                if (gp.dataikerAdmin == null || !gp.dataikerAdmin.booleanValue()) {
                    throw new UnauthorizedException("Action forbidden", "not-dataiker-admin");
                }
                return;
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    @Override
    public boolean mayManageGovern(AuthCtx authCtx) {
        return ((GHAuthCtx)authCtx).getPermissions().mayManageGovern();
    }

    @Override
    public void checkMayManageGovern(AuthCtx authCtx) throws UnauthorizedException {
        if (!this.mayManageGovern(authCtx)) {
            throw new UnauthorizedException("Action forbidden, you are not a govern manager", "not-govern-manager");
        }
    }
}

