/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.intercom.p;

import com.dataiku.common.server.APIKeyBase;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.SharedSecretAuthService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.DIPInternalControllerBase;
import com.dataiku.gh.security.model.GlobalScopePublicAPIKey;
import com.dataiku.gh.server.api.auth.PublicAPIKeysService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AdminApiKeysPrivilegedIntercomController
extends DIPInternalControllerBase {
    @Autowired
    private AuditTrailService auditService;
    @Autowired
    private SharedSecretAuthService authService;
    @Autowired
    private PublicAPIKeysService publicApiKeysService;

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/api/pintercom/api-keys/get-temporary-admin-key"})
    public APIKeyBase requestApiKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam String requestedBy, @RequestParam(required=false) String label, @RequestParam(required=false) String dssUserForImpersonation) throws Exception {
        this.authService.failIfNoSharedSecret(req);
        GlobalScopePublicAPIKey inMemoryAPIKey = this.publicApiKeysService.getInMemoryAPIKey(requestedBy, label, dssUserForImpersonation);
        this.auditService.generic("in-memory-api-key-create").with("id", inMemoryAPIKey.id).emit();
        return inMemoryAPIKey;
    }
}

