/*
 * Decompiled with CFR 0.152.
 */
package com.querydsl.sql.namemapping;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.querydsl.sql.SchemaAndTable;
import com.querydsl.sql.namemapping.NameMapping;
import java.util.Locale;

public class ChangeLetterCaseNameMapping
implements NameMapping {
    private Locale locale;
    private final LetterCase targetCase;

    public ChangeLetterCaseNameMapping(LetterCase targetCase, Locale locale) {
        this.locale = (Locale)Preconditions.checkNotNull((Object)locale);
        this.targetCase = (LetterCase)((Object)Preconditions.checkNotNull((Object)((Object)targetCase)));
    }

    @Override
    public Optional<String> getColumnOverride(SchemaAndTable key, String column) {
        return Optional.of((Object)this.targetCaseOrNull(column));
    }

    @Override
    public Optional<SchemaAndTable> getOverride(SchemaAndTable key) {
        return Optional.of((Object)new SchemaAndTable(this.targetCaseOrNull(key.getSchema()), this.targetCaseOrNull(key.getTable())));
    }

    private String targetCaseOrNull(String text) {
        if (this.targetCase == LetterCase.LOWER) {
            return text.toLowerCase(this.locale);
        }
        return text.toUpperCase(this.locale);
    }

    public static enum LetterCase {
        LOWER,
        UPPER;

    }
}

