/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.lambda.mgmt;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.VersionTag;
import com.dataiku.dip.cuspol.CustomFieldsService;
import com.dataiku.dip.cuspol.CustomPolicyHooksRegistry;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.lambda.mgmt.LambdaServicesDAO;
import com.dataiku.dip.llm.PretrainedModelsService;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggableObjectsService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransactionRef;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.JSON;
import com.dataiku.lambda.model.serverconfig.LambdaAuthMethod;
import com.dataiku.lambda.model.serverconfig.OAuth2Config;
import com.dataiku.lambda.model.serverconfig.QueryAPIKey;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LambdaServicesCRUDService {
    @Autowired
    private LambdaServicesDAO dao;
    @Autowired
    private PubSubService messagingService;
    @Autowired
    private CustomFieldsService customFieldsService;
    @Autowired
    private CustomPolicyHooksRegistry customPolicyHooksRegistry;
    @Autowired
    private PretrainedModelsService pretrainedModelsService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.lambda.services");

    public LambdaService getOrNull(String projectKey, String id) throws IOException {
        return (LambdaService)this.dao.getOrNull(projectKey, id);
    }

    public LambdaService getMandatoryUnsafe(String projectKey, String id) throws IOException {
        return (LambdaService)this.dao.getMandatoryUnsafe(projectKey, id);
    }

    public LambdaService getMandatory(String projectKey, String id) throws IOException {
        return (LambdaService)this.dao.getMandatory(projectKey, id);
    }

    public void save(LambdaService config) throws IOException, CodedException {
        Preconditions.checkNotNull((Object)config.projectKey);
        Preconditions.checkNotNull((Object)config.id);
        RWTransactionRef t = TransactionContext.retrieveWrite();
        LambdaService preExisting = (LambdaService)this.dao.getOrNull(config.projectKey, config.id);
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), (TaggableObjectsService.TaggableObject)preExisting, (TaggableObjectsService.TaggableObject)config);
        config.versionTag = VersionTag.increment((VersionTag)preExisting.versionTag, (String)t.getUser().getIdentifier());
        LambdaService configCopy = (LambdaService)JSON.deepCopy((Object)config);
        Gson gsonWithSerializedNulls = JSON.gsonForNoNaNAndNull();
        configCopy.endpoints = config.endpoints.stream().map(e -> (DSSLambdaEndpointConfig)JSON.deepCopy((Object)e, (Gson)gsonWithSerializedNulls)).collect(Collectors.toList());
        if (configCopy.authRealm != null) {
            configCopy.authRealm.encryptKeysIfNotEncrypted(this.passwordEncryptionService);
        }
        this.dao.save(configCopy);
        TaggableObjectChangedEvent.ActionType action = TaggableObjectChangedEvent.ActionType.LAMBDA_SERVICE_EDIT;
        this.messagingService.publishAfterTransaction((DSSEvent)new TaggableObjectChangedEvent(ITaggingService.TaggableType.LAMBDA_SERVICE, config.projectKey, config.id, t.getUser(), action));
    }

    public LambdaService addEndpoint(String projectKey, String serviceId, DSSLambdaEndpointConfig endpoint, boolean serviceCreation) throws IOException, CodedException {
        LambdaService service;
        logger.info((Object)("Add an endpoint of type: " + String.valueOf(endpoint.type)));
        if (serviceCreation) {
            service = this.create(projectKey, serviceId);
        } else {
            service = (LambdaService)this.dao.getMandatory(projectKey, serviceId);
            if (service.endpoints.stream().anyMatch(ep -> ep.id.equals(endpoint.id))) {
                throw ErrorContext.iaef((String)"Endpoint ID %s already exists in service %s", (Object)endpoint.id, (Object[])new Object[]{serviceId});
            }
        }
        service.endpoints.add(endpoint);
        this.save(service);
        return service;
    }

    public List<LambdaService> list(String projectKey) throws IOException {
        return this.dao.listUnsafe(projectKey);
    }

    public LambdaService create(String projectKey, String id) throws IOException, CodedException {
        if (!id.matches("^[A-Za-z0-9_-]+$")) {
            throw ErrorContext.iaef((String)"Service id is invalid: %s", (Object)id, (Object[])new Object[0]);
        }
        if (this.getOrNull(projectKey, id) != null) {
            throw ErrorContext.iaef((String)"Service %s already exists", (Object)id, (Object[])new Object[0]);
        }
        TransactionContext.assertAttachedRWTransaction();
        RWTransactionRef t = TransactionContext.retrieveWrite();
        LambdaService newService = new LambdaService();
        newService.projectKey = projectKey;
        newService.id = id;
        if (DKUApp.isDataikuCloud()) {
            logger.debugV("Dataiku Cloud mode enabled - setting authorization method to API key and generating a default key for service %s.%s", new Object[]{projectKey, id});
            newService.authMethod = LambdaAuthMethod.API_KEYS;
            QueryAPIKey newKey = new QueryAPIKey();
            newKey.id = "DEFAULT_KEY";
            newKey.label = "Default API key";
            newKey.key = SecretKeyGenerator.generate((int)32);
            newKey.createdOn = System.currentTimeMillis();
            newKey.createdBy = t.getUser().getIdentifier();
            newService.authRealm.queryKeys.add(newKey);
        } else {
            newService.authMethod = LambdaAuthMethod.PUBLIC;
            newService.oauth2Config = new OAuth2Config();
        }
        this.customFieldsService.enrichWithDefaultCustomFieldsForTaggableObject((TaggableObjectsService.TaggableObject)newService);
        newService.versionTag = newService.creationTag = new VersionTag(t.getUser().getIdentifier());
        this.customPolicyHooksRegistry.onPreObjectSave(t.getUser(), null, (TaggableObjectsService.TaggableObject)newService);
        LambdaService newServiceCopy = (LambdaService)JSON.deepCopy((Object)newService);
        if (newServiceCopy.authRealm != null) {
            newServiceCopy.authRealm.encryptKeysIfNotEncrypted(this.passwordEncryptionService);
        }
        this.dao.save(newServiceCopy);
        this.messagingService.publishAfterTransaction((DSSEvent)new TaggableObjectChangedEvent(ITaggingService.TaggableType.LAMBDA_SERVICE, projectKey, id, t.getUser(), TaggableObjectChangedEvent.ActionType.LAMBDA_SERVICE_CREATE));
        return newService;
    }

    public void delete(String projectKey, String id) throws Exception {
        RWTransactionRef t = TransactionContext.retrieveWrite();
        LambdaService service = (LambdaService)this.dao.getMandatory(projectKey, id);
        this.customPolicyHooksRegistry.onPreObjectDelete(t.getUser(), (TaggableObjectsService.TaggableObject)service);
        this.dao.delete(projectKey, id);
        this.messagingService.publishAfterTransaction((DSSEvent)new TaggableObjectChangedEvent(ITaggingService.TaggableType.LAMBDA_SERVICE, projectKey, id, t.getUser(), TaggableObjectChangedEvent.ActionType.LAMBDA_SERVICE_DELETE));
    }
}

