/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.lambda.mgmt;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.analysis.coreservices.flow.ISavedModelsCRUDService;
import com.dataiku.dip.analysis.ml.FullModelId;
import com.dataiku.dip.analysis.ml.MLPluginsService;
import com.dataiku.dip.analysis.ml.clustering.flow.ClusteringSMMgmtService;
import com.dataiku.dip.analysis.ml.prediction.PredictionResultsReader;
import com.dataiku.dip.analysis.ml.prediction.flow.PredictionSMMgmtService;
import com.dataiku.dip.analysis.model.MLTask;
import com.dataiku.dip.analysis.model.core.ResolvedCoreParams;
import com.dataiku.dip.analysis.model.prediction.PredictionModelDetails;
import com.dataiku.dip.analysis.model.prediction.ResolvedPredictionCoreParams;
import com.dataiku.dip.code.AutomationNodeCodeEnvsService;
import com.dataiku.dip.code.CodeEnvModel;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.code.CodeEnvSelector;
import com.dataiku.dip.code.DesignNodeCodeEnvsService;
import com.dataiku.dip.code.ProjectLibPathHelper;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.coremodel.SerializedProject;
import com.dataiku.dip.dao.DatasetsDAO;
import com.dataiku.dip.dao.SavedModel;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.ConfValidators;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.export.output.ExportToStream;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.lambda.mgmt.LambdaMgmtCodes;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.managedfolder.ManagedFoldersService;
import com.dataiku.dip.meanings.MeaningsDAO;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.FilePartitioner;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.partitioning.PartitioningScheme;
import com.dataiku.dip.partitioning.PartitioningUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.openapi.OpenAPIService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.fs.NativeFS;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.fs.ZipWriteFS;
import com.dataiku.dip.transactions.fs.ifaces.ReadWriteFS;
import com.dataiku.dip.transactions.fs.utils.FSUtils;
import com.dataiku.dip.transactions.git.jgit.ProjectsJGitService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.DatasetFileTransferer;
import com.dataiku.dip.utils.ErrorContext;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.utils.NotImplementedException;
import com.dataiku.dip.utils.Pair;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.dss.shadelib.org.apache.commons.io.FileUtils;
import com.dataiku.lambda.APIServiceCodes;
import com.dataiku.lambda.model.serverconfig.BundledSMVersion;
import com.dataiku.lambda.model.serverconfig.CustomPythonPredictionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.CustomRPredictionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.DatasetResource;
import com.dataiku.lambda.model.serverconfig.DatasetsLookupEndpointConfig;
import com.dataiku.lambda.model.serverconfig.LambdaDesignPermissions;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceGenTag;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.PredictionFeaturesLeftJoinMapping;
import com.dataiku.lambda.model.serverconfig.PyFunctionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.RFunctionEndpointConfig;
import com.dataiku.lambda.model.serverconfig.SQLQueryEndpointConfig;
import com.dataiku.lambda.model.studioconfig.AbstractDSSFunctionEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSCustomPythonPredictionEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSCustomRPredictionEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSDatasetsLookupEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSLambdaEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSPredictionEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSPredictionEndpointConfigBase;
import com.dataiku.lambda.model.studioconfig.DSSPredictionFeaturesLeftJoinMapping;
import com.dataiku.lambda.model.studioconfig.DSSPyFunctionEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSRFunctionEndpointConfig;
import com.dataiku.lambda.model.studioconfig.DSSSQLQueryEndpointConfig;
import com.dataiku.lambda.model.studioconfig.LambdaService;
import com.dataiku.lambda.model.studioconfig.OpenAPIDoc;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class ServicePackager {
    public static final String PACKAGE_ARCHIVE = "package.zip";
    public static final String VARIABLES_CONTEXT_FILE_NAME = "variables_context.json";
    private static final int DEFAULT_EXPORT_MAX_SIZE_MB = 20000;
    @Autowired
    private PredictionSMMgmtService predictionMgmtService;
    @Autowired
    private ClusteringSMMgmtService clusteringMgmtService;
    @Autowired
    private ISavedModelsCRUDService smCRUDService;
    @Autowired
    private ManagedFoldersService foldersService;
    @Autowired
    private DatasetsDAO datasetsDAO;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MeaningsDAO meaningsDAO;
    @Autowired
    private MLPluginsService mlPluginsService;
    @Autowired
    private VariablesService variablesService;
    @Autowired
    private ProjectsJGitService projectsGitService;
    @Autowired
    private OpenAPIService openAPIService;
    @Autowired
    private PasswordEncryptionService passwordEncryptionService;
    File destdir;
    LambdaService srcConfig;
    private final LambdaDesignPermissions designPermissions;
    LambdaServiceConfig dstConfig;
    boolean forDev = false;
    private final String projectKey;
    private final AuthCtx authCtx;
    private ReadWriteFS targetPackageFS;
    Map<String, DatasetResource> builtDatasetResources = new HashMap<String, DatasetResource>();
    Map<AnyLoc, SavedModel> referencedModels = new HashMap<AnyLoc, SavedModel>();
    Map<String, Dataset> referencedDatasets = new HashMap<String, Dataset>();
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.lambda.packager");

    public ServicePackager(AuthCtx authCtx, String projectKey, LambdaService config, List<SerializedProject.PermissionItem> permissions, File destdir) {
        this.authCtx = authCtx;
        this.srcConfig = config;
        this.designPermissions = new LambdaDesignPermissions(permissions);
        this.destdir = destdir;
        this.projectKey = projectKey;
        SpringUtils.getInstance().autowire((Object)this);
        this.dstConfig = new LambdaServiceConfig();
    }

    public ServicePackager(AuthCtx authCtx, String projectKey, LambdaService config, List<SerializedProject.PermissionItem> permissions, File destdir, boolean forDev) {
        this(authCtx, projectKey, config, permissions, destdir);
        this.forDev = forDev;
    }

    @VisibleForTesting
    static List<DSSLambdaEndpointConfig> deDuplicateEndpointNames(List<DSSLambdaEndpointConfig> endpoints) {
        LinkedHashMap<String, DSSLambdaEndpointConfig> deduplicatedMap = new LinkedHashMap<String, DSSLambdaEndpointConfig>();
        for (DSSLambdaEndpointConfig endpoint : endpoints) {
            if (deduplicatedMap.containsKey(endpoint.id)) {
                logger.info((Object)String.format("Skipping duplicated endpoint %s", endpoint.id));
                deduplicatedMap.remove(endpoint.id);
            }
            deduplicatedMap.put(endpoint.id, endpoint);
        }
        return new ArrayList<DSSLambdaEndpointConfig>(deduplicatedMap.values());
    }

    public void init() throws IOException {
        TransactionContext.assertAttachedTransaction();
        List<DSSLambdaEndpointConfig> deduplicatedEndpoints = ServicePackager.deDuplicateEndpointNames(this.srcConfig.endpoints);
        block7: for (DSSLambdaEndpointConfig dpec : deduplicatedEndpoints) {
            switch (dpec.type) {
                case STD_PREDICTION: 
                case STD_CAUSAL_PREDICTION: 
                case STD_FORECAST: 
                case STD_CLUSTERING: {
                    this.initStdPredictionEndpoint((DSSPredictionEndpointConfig)dpec);
                    continue block7;
                }
                case CUSTOM_PREDICTION: {
                    this.initCustomPythonPredictionEndpoint((DSSCustomPythonPredictionEndpointConfig)dpec);
                    continue block7;
                }
                case CUSTOM_R_PREDICTION: {
                    this.initCustomRPredictionEndpoint((DSSCustomRPredictionEndpointConfig)dpec);
                    continue block7;
                }
                case DATASETS_LOOKUP: {
                    this.initDatasetsLookupEndpoint((DSSDatasetsLookupEndpointConfig)dpec);
                    continue block7;
                }
                case R_FUNCTION: 
                case PY_FUNCTION: 
                case SQL_QUERY: {
                    continue block7;
                }
            }
            throw new Error("unimplemented");
        }
    }

    public void build_NT(InfoMessage.InfoMessages messages) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        assert (this.destdir.isDirectory());
        LambdaServiceGenTag genTag = new LambdaServiceGenTag();
        genTag.generationId = this.destdir.getName();
        genTag.createdOn = System.currentTimeMillis();
        genTag.createdWithDSSVersion = ApplicationConfigurator.getDSSVersion().product_version;
        genTag.createdWithDSSConfVersion = ApplicationConfigurator.getDSSVersion().conf_version;
        genTag.createdWithInstallId = DKUApp.getInstallId();
        genTag.createdOnNodeId = DKUApp.getNodeId();
        genTag.createdOnNodeUrl = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().studioExternalUrl;
        genTag.originalProjectKey = this.projectKey;
        genTag.createdBy = this.authCtx.getIdentifier();
        genTag.releaseNotes = this.srcConfig.releaseNotes;
        File targetZipTmp = new File(this.destdir.getParent(), genTag.generationId + ".zip");
        FileOutputStream fileOutputStream = null;
        ExportToStream.MonitoredOutputStream monitoredStream = null;
        if (this.forDev) {
            this.targetPackageFS = NativeFS.from((File)this.destdir).build();
        } else {
            long maxFileSizeMB = DKUApp.getParams().getLongParam("dku.apiService.package.maxSizeMB", 20000L);
            fileOutputStream = new FileOutputStream(targetZipTmp, false);
            monitoredStream = new ExportToStream.MonitoredOutputStream((OutputStream)fileOutputStream, maxFileSizeMB);
            this.targetPackageFS = new ZipWriteFS((OutputStream)monitoredStream);
        }
        try {
            List<DSSLambdaEndpointConfig> deduplicatedEndpoints = ServicePackager.deDuplicateEndpointNames(this.srcConfig.endpoints);
            ArrayList<OpenAPIDoc> endpointsOAD = new ArrayList<OpenAPIDoc>();
            for (DSSLambdaEndpointConfig dpec : deduplicatedEndpoints) {
                if (dpec.openAPI != null && dpec.openAPI.enabled) {
                    endpointsOAD.add(dpec.openAPI);
                }
                try {
                    switch (dpec.type) {
                        case STD_PREDICTION: 
                        case STD_CAUSAL_PREDICTION: 
                        case STD_FORECAST: 
                        case STD_CLUSTERING: {
                            this.buildStdPredictionEndpoint((DSSPredictionEndpointConfig)dpec, messages);
                            break;
                        }
                        case CUSTOM_PREDICTION: {
                            this.buildCustomPythonPredictionEndpoint((DSSCustomPythonPredictionEndpointConfig)dpec);
                            break;
                        }
                        case CUSTOM_R_PREDICTION: {
                            this.buildCustomRPredictionEndpoint((DSSCustomRPredictionEndpointConfig)dpec);
                            break;
                        }
                        case R_FUNCTION: {
                            this.buildRFunctionEndpoint((DSSRFunctionEndpointConfig)dpec);
                            break;
                        }
                        case PY_FUNCTION: {
                            this.buildPyFunctionEndpoint((DSSPyFunctionEndpointConfig)dpec);
                            break;
                        }
                        case SQL_QUERY: {
                            this.buildSQLQueryEndpoint((DSSSQLQueryEndpointConfig)dpec);
                            break;
                        }
                        case DATASETS_LOOKUP: {
                            this.buildDatasetsLookupEndpoint((DSSDatasetsLookupEndpointConfig)dpec);
                            break;
                        }
                        default: {
                            throw new Error("unimplemented");
                        }
                    }
                }
                catch (Exception e) {
                    logger.errorV((Throwable)e, ServicePackager.toEndpointLog("Error while building endpoint", dpec), new Object[0]);
                    messages.withFatal((InfoMessage.MessageCode)LambdaMgmtCodes.ERR_APINODE_BUILDING_ENDPOINT, ServicePackager.toEndpointLog(ExceptionUtils.getMessageWithCauses((Throwable)e), dpec));
                }
            }
            if (!endpointsOAD.isEmpty()) {
                this.targetPackageFS.writeStringUTF8("swagger.json", this.openAPIService.generateServiceOpenAPIDocContent(this.srcConfig.id, this.destdir.getName(), this.srcConfig.description, endpointsOAD));
                this.dstConfig.hasOpenAPIDoc = true;
            }
            this.dstConfig.authMethod = this.srcConfig.authMethod;
            this.dstConfig.authRealm = this.srcConfig.authRealm;
            if (this.dstConfig.authRealm != null) {
                this.dstConfig.authRealm.decryptKeysIfEncrypted(this.passwordEncryptionService);
            }
            this.dstConfig.oauth2Config = this.srcConfig.oauth2Config;
            try (Transaction t = this.transactionService.beginRead();){
                this.dstConfig.userDefinedMeanings = this.meaningsDAO.listUnsafe();
            }
            this.targetPackageFS.writeObject("config.json", (Object)this.dstConfig);
            this.targetPackageFS.writeObject("tag.json", (Object)genTag);
            this.targetPackageFS.writeObject("design-permissions.json", (Object)this.designPermissions);
        }
        catch (Exception e) {
            if (!this.forDev) {
                DKUFileUtils.delete((File)targetZipTmp);
            }
            throw e;
        }
        finally {
            if (!this.forDev) {
                ((ZipWriteFS)this.targetPackageFS).close();
                if (monitoredStream != null) {
                    monitoredStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
            }
        }
        if (!this.forDev) {
            File packageFile = new File(this.destdir, PACKAGE_ARCHIVE);
            try {
                FileUtils.moveFile((File)targetZipTmp, (File)packageFile);
            }
            catch (Exception e) {
                DKUFileUtils.delete((File)targetZipTmp);
                DKUFileUtils.delete((File)packageFile);
            }
            String tag = "dss-api-" + this.projectKey + "-" + this.srcConfig.id + "-" + genTag.generationId;
            String message = "Created API service for project " + this.projectKey + ": " + this.srcConfig.id + " / " + genTag.generationId;
            this.projectsGitService.removeProjectTag_NT(this.projectKey, tag);
            this.projectsGitService.addProjectTag_NT(this.authCtx, this.projectKey, tag, message, null);
        }
        logger.info((Object)("Built service zip in " + this.destdir.getAbsolutePath()));
    }

    private void initStdPredictionEndpoint(DSSPredictionEndpointConfig srcEP) throws IOException {
        AnyLoc modelLoc = AnyLoc.resolveSmart((String)this.srcConfig.projectKey, (String)srcEP.modelRef);
        SavedModel sm = this.smCRUDService.getMandatory(modelLoc.getProjectKey(), modelLoc.getId());
        this.referencedModels.put(modelLoc, sm);
        this.initPredictionEndpoint((DSSPredictionEndpointConfigBase)srcEP);
    }

    private void initCustomPythonPredictionEndpoint(DSSCustomPythonPredictionEndpointConfig srcEP) throws IOException {
        this.initPredictionEndpoint((DSSPredictionEndpointConfigBase)srcEP);
    }

    private void initCustomRPredictionEndpoint(DSSCustomRPredictionEndpointConfig srcEP) throws IOException {
        this.initPredictionEndpoint((DSSPredictionEndpointConfigBase)srcEP);
    }

    private void initPredictionEndpoint(DSSPredictionEndpointConfigBase srcEP) throws IOException {
        this.initReferencedDatasets(srcEP.enrichMapping);
    }

    private void initDatasetsLookupEndpoint(DSSDatasetsLookupEndpointConfig srcEP) throws IOException {
        this.initReferencedDatasets(srcEP.lookups);
    }

    private void initReferencedDatasets(List<DSSPredictionFeaturesLeftJoinMapping> mappings) throws IOException {
        for (DSSPredictionFeaturesLeftJoinMapping mapping : mappings) {
            if (StringUtils.isBlank((String)mapping.datasetRef)) {
                logger.warn((Object)("Mapping of type " + mapping.packagingType.name() + " references no dataset, ignoring"));
                continue;
            }
            DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart((String)this.srcConfig.projectKey, (String)mapping.datasetRef);
            this.referencedDatasets.put(datasetLoc.getFullName(), this.datasetAccessService.getMandatory((AnyLoc)datasetLoc));
        }
    }

    private void dumpCodeEnv(CodeEnvModel.EnvLang envLang, String envName, RelFile endpointDir) throws IOException {
        RelFile targetDir = endpointDir.append(new String[]{envLang.getFolderName() + "-env-desc"});
        if (envName != null) {
            logger.info((Object)("Dumping code env " + String.valueOf(envLang) + " " + envName + " to " + String.valueOf(targetDir)));
            this.targetPackageFS.makeDirectory(targetDir);
            if (ApplicationConfigurator.getNodeType() == ApplicationConfigurator.DSSNodeType.DESIGN) {
                ((DesignNodeCodeEnvsService)SpringUtils.getBean(DesignNodeCodeEnvsService.class)).exportEnvDefToFS(envLang, envName, this.targetPackageFS.directoryView(targetDir));
            } else {
                ((AutomationNodeCodeEnvsService)SpringUtils.getBean(AutomationNodeCodeEnvsService.class)).exportEnvDefToFS(this.projectKey, envLang, envName, this.targetPackageFS.directoryView(targetDir));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private String getCodeEnvName(CodeEnvModel.EnvLang envLang, CodeEnvSelection selection) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        selector = new CodeEnvSelector();
        envName = null;
        t = this.transactionService.beginRead();
        try {
            switch (1.$SwitchMap$com$dataiku$dip$code$CodeEnvModel$EnvLang[envLang.ordinal()]) {
                case 1: {
                    envName = selector.selectForRRecipe(this.projectKey, selection);
                    ** break;
lbl10:
                    // 1 sources

                    break;
                }
                case 2: {
                    envName = selector.selectForPythonRecipe(this.projectKey, selection);
                    break;
                }
                ** default:
lbl15:
                // 1 sources

                break;
            }
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        ServicePackager.logger.info((Object)("Selected code env " + String.valueOf(envLang) + " " + envName + " from " + (selection != null ? JSON.pretty((Object)selection) : "")));
        return envName;
    }

    private void buildStdPredictionEndpoint(DSSPredictionEndpointConfig srcEP, InfoMessage.InfoMessages messages) throws Exception {
        AnyLoc modelLoc = AnyLoc.resolveSmart((String)this.srcConfig.projectKey, (String)srcEP.modelRef);
        SavedModel sm = this.referencedModels.get(modelLoc);
        if (sm == null) {
            throw ErrorContext.iaef((String)"Model is not referenced in the prediction endpoint: %s (project: %s)", (Object)srcEP.modelRef, (Object[])new Object[]{this.srcConfig.projectKey});
        }
        this.targetPackageFS.writeStringUTF8(String.format("testqueries-%s.json", srcEP.id), JSON.forFilePrettyWithNulls((Object)srcEP.testQueries));
        String targetModelId = modelLoc.getFullName();
        RelFile modelDestDir = new RelFile(new String[]{"models", targetModelId});
        FullModelId fmi = switch (sm.getType()) {
            case MLTask.MLTaskType.PREDICTION -> this.predictionMgmtService.getActiveVersionFMI(sm);
            case MLTask.MLTaskType.CLUSTERING -> this.clusteringMgmtService.getActiveVersionFMI(sm);
            case MLTask.MLTaskType.LLM_GENERIC_RAW, MLTask.MLTaskType.LLM_GENERIC_PROMPTABLE_COMPLETION, MLTask.MLTaskType.LLM_CLASSIFICATION -> throw new IllegalArgumentException("LLM not supported here");
            default -> throw new NotImplementedException("Unimplemented model type: " + String.valueOf(sm.getType()));
        };
        this.copyDirectoryIfNotExists(fmi.getModelFolder(), modelDestDir);
        BundledSMVersion smVersion = new BundledSMVersion();
        smVersion.originalProjectKey = modelLoc.getProjectKey();
        smVersion.originalSavedModelId = modelLoc.getId();
        smVersion.originalSavedModelName = sm.name;
        smVersion.originalSavedModelVersion = sm.activeVersion;
        smVersion.originalSavedModelVersionName = fmi.getUserMeta().name;
        smVersion.id = targetModelId;
        smVersion.modelType = sm.getType();
        this.dstConfig.stdModels.add(smVersion);
        PredictionEndpointConfig dstEP = new PredictionEndpointConfig();
        dstEP.type = srcEP.type;
        dstEP.id = srcEP.id;
        dstEP.modelId = targetModelId;
        dstEP.savedModelType = sm.savedModelType;
        this.prepareFeatureMapping(srcEP.enrichMapping, dstEP.enrichMapping);
        dstEP.returnPostEnrichData = srcEP.returnPostEnrichData;
        dstEP.auditPostEnrichData = srcEP.auditPostEnrichData;
        this.dstConfig.endpoints.add(dstEP);
        switch (sm.savedModelType.savedModelHandlingType) {
            case INTERNAL: {
                this.writeObjectIfNotExists(modelDestDir.append(new String[]{"conditional_outputs.json"}), sm.conditionalOutputs);
                ResolvedCoreParams coreParams = fmi.getResolvedCoreParams();
                if (coreParams instanceof ResolvedPredictionCoreParams && ((ResolvedPredictionCoreParams)coreParams).isPartitioned()) {
                    for (Map.Entry entry : fmi.getPartitionModelFolders().entrySet()) {
                        File modelFolder = (File)entry.getValue();
                        RelFile partsDestDir = modelDestDir.append(new String[]{"parts", PartitioningUtils.encode((String)((String)entry.getKey()))});
                        this.copyDirectoryIfNotExists(modelFolder, partsDestDir);
                    }
                }
                dstEP.computePropensity = srcEP.computePropensity;
                dstEP.individualExplanationParams = srcEP.individualExplanationParams;
                dstEP.outputExplanations = srcEP.outputExplanations;
                if (coreParams.backendType == MLTask.BackendType.PY_MEMORY || coreParams.backendType == MLTask.BackendType.KERAS || coreParams.backendType == MLTask.BackendType.DEEP_HUB) {
                    this.dumpCodeEnv(CodeEnvModel.EnvLang.PYTHON, coreParams.executionParams.envName, new RelFile(new String[]{"endpoint-" + srcEP.id}));
                }
                this.copyMLPluginsLibs(fmi);
                ServicePackager.checkScoringCompatibilityAndFixupScoringEngine(messages, fmi, dstEP, srcEP);
                break;
            }
            case EXTERNAL_MLFLOW: {
                dstEP.mlFlowOutputStyle = srcEP.mlFlowOutputStyle;
                String codeEnvName = fmi.getMLflowImportedModelMetadata().pythonCodeEnvName;
                this.dumpCodeEnv(CodeEnvModel.EnvLang.PYTHON, codeEnvName, new RelFile(new String[]{"endpoint-" + srcEP.id}));
                break;
            }
            case PYTHON_AGENT: 
            case PLUGIN_AGENT: 
            case TOOLS_USING_AGENT: {
                throw new IllegalArgumentException("Agents are not supported in API node");
            }
            case LLM_GENERIC: {
                throw new IllegalArgumentException("Fine tuned LLMs are not supported in API node");
            }
            case RETRIEVAL_AUGMENTED_LLM: {
                throw new IllegalArgumentException("Augmented LLMs are not supported in API node");
            }
        }
        this.copyPythonLibs(srcEP.id);
        this.packageVariablesContext();
    }

    private static void checkScoringCompatibilityAndFixupScoringEngine(InfoMessage.InfoMessages messages, FullModelId fmi, PredictionEndpointConfig dstEP, DSSPredictionEndpointConfig srcEP) throws IOException {
        boolean pythonScoringRequested;
        if (dstEP.type != LambdaEndpointConfig.EndpointType.STD_PREDICTION) {
            dstEP.useJava = false;
            return;
        }
        dstEP.useJava = srcEP.useJava;
        PredictionModelDetails details = PredictionResultsReader.makeModelDetails((FullModelId)fmi);
        if (!details.apiNodeScoreCompatibility.compatible) {
            messages.withFatal((InfoMessage.MessageCode)LambdaMgmtCodes.ERR_APINODE_NOT_COMPATIBLE, ServicePackager.toEndpointLog(details.apiNodeScoreCompatibility.reason, (DSSLambdaEndpointConfig)srcEP));
            return;
        }
        boolean bl = pythonScoringRequested = !dstEP.useJava;
        if (pythonScoringRequested && !details.pythonApiNodeScoreCompatibility.compatible) {
            messages.withFatal((InfoMessage.MessageCode)LambdaMgmtCodes.ERR_APINODE_NOT_COMPATIBLE, ServicePackager.toEndpointLog(details.pythonApiNodeScoreCompatibility.reason, (DSSLambdaEndpointConfig)srcEP));
            return;
        }
        boolean javaScoringRequested = dstEP.useJava;
        if (javaScoringRequested && !details.javaScoreCompatibility.compatible) {
            messages.withWarning((InfoMessage.MessageCode)LambdaMgmtCodes.WARN_APINODE_JAVA_SCORING_NOT_COMPATIBLE, ServicePackager.toEndpointLog(details.javaScoreCompatibility.reason, (DSSLambdaEndpointConfig)srcEP));
            assert (details.pythonApiNodeScoreCompatibility.compatible);
            dstEP.useJava = false;
            logger.warn((Object)("Java scoring not compatible, falling back to Python. Reason: " + details.javaScoreCompatibility.reason));
        }
    }

    private void packageVariablesContext() throws IOException {
        VariablesContext originModelVariablesContext = this.variablesService.getContext(this.srcConfig.projectKey);
        RelFile variablesContextFile = new RelFile(new String[]{VARIABLES_CONTEXT_FILE_NAME});
        logger.info((Object)"Packaging current state of variables context to endpoint");
        this.writeObjectIfNotExists(variablesContextFile, originModelVariablesContext);
    }

    private void buildCustomPythonPredictionEndpoint(DSSCustomPythonPredictionEndpointConfig srcEP) throws Exception {
        Validate.notNull((Object)srcEP.modelType);
        Validate.notNull((Object)srcEP.code);
        Validate.notEmpty((String)srcEP.code);
        CustomPythonPredictionEndpointConfig dstEP = new CustomPythonPredictionEndpointConfig();
        dstEP.id = srcEP.id;
        dstEP.type = LambdaEndpointConfig.EndpointType.CUSTOM_PREDICTION;
        dstEP.modelType = srcEP.modelType;
        this.targetPackageFS.writeObject("testqueries-" + srcEP.id + ".json", (Object)srcEP.testQueries);
        if (!StringUtils.isBlank((String)srcEP.inputFolderRef)) {
            ManagedFolder mf;
            AnyLoc folderLoc = AnyLoc.resolveSmart((String)this.srcConfig.projectKey, (String)srcEP.inputFolderRef);
            try (Transaction t = this.transactionService.beginRead();){
                mf = this.foldersService.getOrNull(folderLoc.getProjectKey(), folderLoc.getId());
            }
            if (mf != null) {
                try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(this.authCtx);){
                    RelFile targetFolderDir = new RelFile(new String[]{"managed_folders", folderLoc.getFullName()});
                    if (!this.targetPackageFS.exists(targetFolderDir)) {
                        handler.transferToReadWriteFS(this.targetPackageFS, targetFolderDir);
                        this.targetPackageFS.makeDirectory(targetFolderDir);
                    }
                }
            }
            dstEP.managedFolderRef = folderLoc.getFullName();
        }
        this.targetPackageFS.writeStringUTF8("endpoint-" + srcEP.id + "/code.py", srcEP.code);
        dstEP.returnPostEnrichData = srcEP.returnPostEnrichData;
        dstEP.auditPostEnrichData = srcEP.auditPostEnrichData;
        this.prepareFeatureMapping(srcEP.enrichMapping, dstEP.enrichMapping);
        this.dstConfig.endpoints.add(dstEP);
        dstEP.envName = this.getCodeEnvName(CodeEnvModel.EnvLang.PYTHON, srcEP.getCodeEnvSelection());
        this.dumpCodeEnv(CodeEnvModel.EnvLang.PYTHON, dstEP.envName, new RelFile(new String[]{"endpoint-" + srcEP.id}));
        this.copyPythonLibs(srcEP.id);
    }

    private void buildCustomRPredictionEndpoint(DSSCustomRPredictionEndpointConfig srcEP) throws Exception {
        Validate.notNull((Object)srcEP.modelType);
        Validate.notNull((Object)srcEP.code);
        Validate.notEmpty((String)srcEP.code);
        CustomRPredictionEndpointConfig dstEP = new CustomRPredictionEndpointConfig();
        dstEP.id = srcEP.id;
        dstEP.type = LambdaEndpointConfig.EndpointType.CUSTOM_R_PREDICTION;
        dstEP.modelType = srcEP.modelType;
        dstEP.userFunctionName = srcEP.userFunctionName;
        dstEP.passArgumentsAsList = srcEP.passArgumentsAsList;
        this.targetPackageFS.writeObject("testqueries-" + srcEP.id + ".json", (Object)srcEP.testQueries);
        if (!StringUtils.isBlank((String)srcEP.inputFolderRef)) {
            ManagedFolder mf;
            AnyLoc folderLoc = AnyLoc.resolveSmart((String)this.srcConfig.projectKey, (String)srcEP.inputFolderRef);
            try (Transaction t = this.transactionService.beginRead();){
                mf = this.foldersService.getOrNull(folderLoc.getProjectKey(), folderLoc.getId());
            }
            if (mf != null) {
                try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(this.authCtx);){
                    RelFile targetFolderDir = new RelFile(new String[]{"managed_folders", folderLoc.getFullName()});
                    if (!this.targetPackageFS.exists(targetFolderDir)) {
                        handler.transferToReadWriteFS(this.targetPackageFS, targetFolderDir);
                        this.targetPackageFS.makeDirectory(targetFolderDir);
                    }
                }
            }
            dstEP.managedFolderRefs.add(folderLoc.getFullName());
        }
        this.targetPackageFS.writeStringUTF8("endpoint-" + srcEP.id + "/code.R", srcEP.code);
        dstEP.returnPostEnrichData = srcEP.returnPostEnrichData;
        dstEP.auditPostEnrichData = srcEP.auditPostEnrichData;
        this.prepareFeatureMapping(srcEP.enrichMapping, dstEP.enrichMapping);
        this.dstConfig.endpoints.add(dstEP);
        dstEP.envName = this.getCodeEnvName(CodeEnvModel.EnvLang.R, srcEP.getCodeEnvSelection());
        this.dumpCodeEnv(CodeEnvModel.EnvLang.R, dstEP.envName, new RelFile(new String[]{"endpoint-" + srcEP.id}));
        this.copyRLibs(srcEP.id);
    }

    private void buildRFunctionEndpoint(DSSRFunctionEndpointConfig srcEP) throws Exception {
        Validate.notNull((Object)srcEP.code);
        Validate.notEmpty((String)srcEP.code);
        RFunctionEndpointConfig dstEP = new RFunctionEndpointConfig();
        dstEP.id = srcEP.id;
        dstEP.type = LambdaEndpointConfig.EndpointType.R_FUNCTION;
        dstEP.userFunctionName = srcEP.userFunctionName;
        dstEP.passArgumentsAsList = srcEP.passArgumentsAsList;
        this.targetPackageFS.writeObject("testqueries-" + srcEP.id + ".json", (Object)srcEP.testQueries);
        for (AbstractDSSFunctionEndpointConfig.ManagedFolderRef inputFolderRef : srcEP.inputFolderRefs) {
            ManagedFolder mf;
            AnyLoc folderLoc = AnyLoc.resolveSmart((String)this.srcConfig.projectKey, (String)inputFolderRef.ref);
            try (Transaction t = this.transactionService.beginRead();){
                mf = this.foldersService.getOrNull(folderLoc.getProjectKey(), folderLoc.getId());
            }
            if (mf != null) {
                try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(this.authCtx);){
                    RelFile targetFolderDir = new RelFile(new String[]{"managed_folders", folderLoc.getFullName()});
                    if (!this.targetPackageFS.exists(targetFolderDir)) {
                        handler.transferToReadWriteFS(this.targetPackageFS, targetFolderDir);
                        this.targetPackageFS.makeDirectory(targetFolderDir);
                    }
                }
            }
            dstEP.managedFolderRefs.add(folderLoc.getFullName());
        }
        this.targetPackageFS.writeStringUTF8("endpoint-" + srcEP.id + "/code.R", srcEP.code);
        this.dstConfig.endpoints.add(dstEP);
        dstEP.envName = this.getCodeEnvName(CodeEnvModel.EnvLang.R, srcEP.getCodeEnvSelection());
        this.dumpCodeEnv(CodeEnvModel.EnvLang.R, dstEP.envName, new RelFile(new String[]{"endpoint-" + srcEP.id}));
        this.copyRLibs(srcEP.id);
    }

    private void buildPyFunctionEndpoint(DSSPyFunctionEndpointConfig srcEP) throws Exception {
        Validate.notNull((Object)srcEP.code);
        Validate.notEmpty((String)srcEP.code);
        PyFunctionEndpointConfig dstEP = new PyFunctionEndpointConfig();
        dstEP.id = srcEP.id;
        dstEP.type = LambdaEndpointConfig.EndpointType.PY_FUNCTION;
        dstEP.userFunctionName = srcEP.userFunctionName;
        dstEP.hasCustomResponse = srcEP.hasCustomResponse;
        this.targetPackageFS.writeObject("testqueries-" + srcEP.id + ".json", (Object)srcEP.testQueries);
        for (AbstractDSSFunctionEndpointConfig.ManagedFolderRef inputFolderRef : srcEP.inputFolderRefs) {
            ManagedFolder mf;
            AnyLoc folderLoc = AnyLoc.resolveSmart((String)this.srcConfig.projectKey, (String)inputFolderRef.ref);
            try (Transaction t = this.transactionService.beginRead();){
                mf = this.foldersService.getOrNull(folderLoc.getProjectKey(), folderLoc.getId());
            }
            if (mf != null) {
                try (ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler(this.authCtx);){
                    RelFile targetFolderDir = new RelFile(new String[]{"managed_folders", folderLoc.getFullName()});
                    if (!this.targetPackageFS.exists(targetFolderDir)) {
                        handler.transferToReadWriteFS(this.targetPackageFS, targetFolderDir);
                        this.targetPackageFS.makeDirectory(targetFolderDir);
                    }
                }
            }
            dstEP.managedFolderRefs.add(folderLoc.getFullName());
        }
        this.targetPackageFS.writeStringUTF8("endpoint-" + srcEP.id + "/code.py", srcEP.code);
        this.dstConfig.endpoints.add(dstEP);
        dstEP.envName = this.getCodeEnvName(CodeEnvModel.EnvLang.PYTHON, srcEP.getCodeEnvSelection());
        this.dumpCodeEnv(CodeEnvModel.EnvLang.PYTHON, dstEP.envName, new RelFile(new String[]{"endpoint-" + srcEP.id}));
        this.copyPythonLibs(srcEP.id);
    }

    private void buildSQLQueryEndpoint(DSSSQLQueryEndpointConfig srcEP) throws Exception {
        for (DSSSQLQueryEndpointConfig.DSSSQLQueryEndpointQuery eq : srcEP.queries) {
            ConfValidators.checkNotBlank((String)eq.query, (InfoMessage.MessageCode)APIServiceCodes.ERR_ENDPOINT_INVALID_CONFIG, (String)"query");
        }
        this.targetPackageFS.writeObject("testqueries-" + srcEP.id + ".json", (Object)srcEP.testQueries);
        SQLQueryEndpointConfig dstEP = (SQLQueryEndpointConfig)JSON.parse((String)JSON.json((Object)srcEP), SQLQueryEndpointConfig.class);
        this.dstConfig.endpoints.add(dstEP);
    }

    private void buildDatasetsLookupEndpoint(DSSDatasetsLookupEndpointConfig srcEP) throws Exception {
        this.targetPackageFS.writeObject("testqueries-" + srcEP.id + ".json", (Object)srcEP.testQueries);
        DatasetsLookupEndpointConfig dstEP = new DatasetsLookupEndpointConfig();
        dstEP.id = srcEP.id;
        dstEP.type = srcEP.type;
        this.prepareFeatureMapping(srcEP.lookups, dstEP.lookups);
        this.dstConfig.endpoints.add(dstEP);
    }

    private void prepareFeatureMapping(List<DSSPredictionFeaturesLeftJoinMapping> srcMapping, List<PredictionFeaturesLeftJoinMapping> dstMapping) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        ArrayList<Pair> datasetsToDump = new ArrayList<Pair>();
        try (Transaction t = this.transactionService.beginRead();){
            for (DSSPredictionFeaturesLeftJoinMapping srcM : srcMapping) {
                if (StringUtils.isBlank((String)srcM.datasetRef)) {
                    throw ErrorContext.iae((String)"An enrichment is missing a referenced dataset");
                }
                logger.info((Object)("Handling mapping of " + String.valueOf(srcM)));
                PredictionFeaturesLeftJoinMapping dstM = new PredictionFeaturesLeftJoinMapping();
                DatasetLocUtils.DatasetLoc datasetLoc = DatasetLocUtils.resolveSmart((String)this.srcConfig.projectKey, (String)srcM.datasetRef);
                dstM.on = srcM.on;
                dstM.missingLookupKeyBehavior = srcM.missingLookupKeyBehavior;
                dstM.notFoundBehavior = srcM.notFoundBehavior;
                dstM.multimatchBehavior = srcM.multiMatchBehavior;
                dstM.columnsMapping = srcM.columnsMapping;
                dstM.lookupResource = datasetLoc.getFullName();
                dstMapping.add(dstM);
                DatasetResource res = this.builtDatasetResources.get(datasetLoc.getFullName());
                if (res != null) continue;
                res = new DatasetResource();
                res.resourceId = datasetLoc.getFullName();
                res.packagingType = srcM.packagingType;
                res.dssDataset = (SerializedDataset)this.datasetsDAO.getOrNull((AnyLoc)datasetLoc);
                if (srcM.packagingType == DatasetResource.PackagingType.BUNDLED_TOCONNECTION) {
                    RelFile datasetDestDir = new RelFile(new String[]{"datasets", res.resourceId});
                    this.targetPackageFS.makeDirectory(datasetDestDir);
                    res.bundledFormatType = "csv";
                    datasetsToDump.add(new Pair((Object)datasetDestDir, (Object)datasetLoc));
                } else if (srcM.packagingType == DatasetResource.PackagingType.REFERENCED) {
                    DatasetHandler.DatasetParams params = res.dssDataset.getParams();
                    if (!(params instanceof AbstractSQLDatasetHandler.AbstractSQLConfig)) {
                        throw ErrorContext.iaef((String)"Referenced dataset %s is not SQL", (Object)res.dssDataset.getFullName(), (Object[])new Object[0]);
                    }
                    res.dssDataset.setParams((DatasetHandler.DatasetParams)((AbstractSQLDatasetHandler.AbstractSQLConfig)params).getResolved(datasetLoc.getProjectKey()));
                }
                this.dstConfig.datasetResources.add(res);
                this.builtDatasetResources.put(datasetLoc.getFullName(), res);
            }
        }
        for (Pair ref : datasetsToDump) {
            this.dumpDataset(this.projectKey, (RelFile)ref.first, (DatasetLocUtils.DatasetLoc)ref.second);
        }
    }

    private void dumpDataset(String projectKey, RelFile destDir, DatasetLocUtils.DatasetLoc loc) throws Exception {
        TransactionContext.assertNoAttachedTransaction();
        logger.info((Object)("Dumping dataset " + String.valueOf(loc) + " to " + String.valueOf(destDir)));
        Dataset dataset = this.referencedDatasets.get(loc.getFullName());
        assert (dataset != null);
        WarningsContext wc = new WarningsContext();
        StreamColumnFactory scf = new StreamColumnFactory();
        StreamRowFactory srf = new StreamRowFactory();
        String outputDir = FilePartitioner.computePartitionRelPathAsFolder((Partition)new Partition(null), (PartitioningScheme)new PartitioningScheme());
        CSVFormatConfig outputFormatParams = CSVFormatConfig.getStandardTabExcelFormat();
        DatasetFileTransferer.ResplittableExtensibleReadWriteFSOutputWriter wr = new DatasetFileTransferer.ResplittableExtensibleReadWriteFSOutputWriter(this.authCtx, projectKey, this.targetPackageFS, destDir, outputDir, 0, 1, "csv", (FormatParams)outputFormatParams, dataset.getSchema(), wc, Output.WriteMode.APPEND, outputFormatParams.compress, null);
        wr.init((ColumnFactory)scf);
        try {
            UniversalSingleThreadPusher.push((AuthCtx)this.authCtx, (Dataset)dataset, (StreamableDatasetSelection)StreamableDatasetSelection.full(), (ProcessorOutput)wr, (ColumnFactory)scf, (RowFactory)srf);
            wr.lastRowEmitted();
        }
        catch (Exception e) {
            if (!this.forDev) {
                wr.cancel();
            }
            throw e;
        }
    }

    private void copyPythonLibs(String endpointId) throws IOException, DKUSecurityException {
        TransactionContext.assertNoAttachedTransaction();
        ProjectLibPathHelper.ProjectLibsPaths libPaths = null;
        try (Transaction t = this.transactionService.beginRead();){
            libPaths = ProjectLibPathHelper.preparePathsWithoutCopy((AuthCtx)this.authCtx, (String)this.projectKey);
        }
        int i = 0;
        for (String chunk : libPaths.pythonPath) {
            File pythonPathChunk = new File(chunk);
            if (pythonPathChunk.isDirectory()) {
                this.copyDirectoryIfNotExists(pythonPathChunk, "endpoint-" + endpointId + "/lib/" + String.format("%03d", i) + "-project");
            }
            ++i;
        }
        File globalPyLibsDir = new File(System.getenv("DIP_HOME") + "/lib/python");
        if (globalPyLibsDir.isDirectory()) {
            this.copyDirectoryIfNotExists(globalPyLibsDir, "endpoint-" + endpointId + "/lib/999-global");
        }
    }

    private void copyRLibs(String endpointId) throws IOException, DKUSecurityException {
        ProjectLibPathHelper.ProjectLibsPaths libPaths;
        TransactionContext.assertNoAttachedTransaction();
        try (Transaction t = this.transactionService.beginRead();){
            libPaths = ProjectLibPathHelper.preparePathsWithoutCopy((AuthCtx)this.authCtx, (String)this.projectKey);
        }
        int i = 0;
        for (String chunk : libPaths.rsrcPath) {
            File rPathChunk = new File(chunk);
            if (rPathChunk.isDirectory()) {
                this.copyDirectoryIfNotExists(rPathChunk, "endpoint-" + endpointId + "/lib/" + String.format("%03d", i) + "-project");
            }
            ++i;
        }
        File globalRLibsDir = new File(System.getenv("DIP_HOME") + "/lib/R");
        if (globalRLibsDir.isDirectory()) {
            this.copyDirectoryIfNotExists(globalRLibsDir, "endpoint-" + endpointId + "/lib/00-global");
        }
    }

    private void copyMLPluginsLibs(FullModelId fmi) throws IOException {
        TransactionContext.assertNoAttachedTransaction();
        RelFile mlPluginsFolder = new RelFile(new String[]{"ml-plugins-lib"});
        Map usedPlugins = this.mlPluginsService.getUsedPlugins(fmi);
        if (usedPlugins == null || usedPlugins.isEmpty()) {
            return;
        }
        this.targetPackageFS.makeDirectory(mlPluginsFolder);
        this.mlPluginsService.copyNecessaryPluginFiles(this.targetPackageFS.directoryView(mlPluginsFolder), usedPlugins);
    }

    private void copyDirectoryIfNotExists(File from, String to) throws IOException {
        this.copyDirectoryIfNotExists(from, RelFile.fromPath((String)to));
    }

    private void copyDirectoryIfNotExists(File from, RelFile to) throws IOException {
        if (this.targetPackageFS.exists(to)) {
            return;
        }
        FSUtils.newRecursiveCopy().from(from).to(this.targetPackageFS, to).run();
    }

    private void writeObjectIfNotExists(RelFile to, Object obj) throws IOException {
        if (this.targetPackageFS.exists(to)) {
            return;
        }
        this.targetPackageFS.writeObject(to, obj);
    }

    private static String toEndpointLog(String msg, DSSLambdaEndpointConfig endpointConfig) {
        return "[Endpoint '" + endpointConfig.id + "' (" + String.valueOf(endpointConfig.type) + ")] " + msg;
    }
}

