/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.coremodel.CreationJobDef;
import com.dataiku.dip.coremodel.JobDef;
import com.dataiku.dip.dataflow.graph.FlowComputable;
import com.dataiku.dip.dataflow.jobrunner.status.EnhancedSerializedJobStatus;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.FlowExecutionService2;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.ReadWriteJobsInternalDB;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.Id;
import com.dataiku.dip.utils.DKUFileUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.variables.VariablesContext;
import com.dataiku.dip.variables.VariablesService;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/jobs"})
public class PublicAPIJobsController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FlowExecutionService2 flowExecutionService;
    @Autowired
    private ReadWriteJobsInternalDB jobsService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private VariablesService variablesService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.jobs");

    @AuditedCall(value={"msgType", "jobs-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void listJobs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(defaultValue="100") String limit) throws Exception {
        Integer lim = Integer.parseInt(limit);
        if (lim < 0) {
            throw new DKUControllerBase.MalformedRequestException("limit parameter must be positive");
        }
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        List ret = this.jobsService.getLastJobs_NT(projectKey, lim.intValue());
        PublicAPIJobsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditInline
    @RequestMapping(value={"/"}, method={RequestMethod.POST})
    public void start(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        String jobId;
        CreationJobDef cjd = (CreationJobDef)this.getRequestBodyAs(req, CreationJobDef.class);
        JobDef jd = new JobDef();
        jd.projectKey = projectKey;
        VariablesContext vc = this.variablesService.getContext(jd.projectKey);
        this.require(cjd.outputs != null, "outputs is null");
        for (CreationJobDef.Output coutput : cjd.outputs) {
            this.require(!StringUtils.isBlank((String)coutput.id), "id in output is null");
            JobDef.JobOutput jo = new JobDef.JobOutput(null, coutput.id, coutput.partition);
            jo.targetDatasetProjectKey = StringUtils.isBlank((String)coutput.projectKey) ? projectKey : coutput.projectKey;
            jo.type = coutput.type == null ? FlowComputable.FCType.DATASET : coutput.type;
            jd.outputs.add(jo);
        }
        jd.expandInPlaceOutputsTargetPartition(vc);
        jd.type = cjd.type == null ? JobDef.JobType.NON_RECURSIVE_FORCED_BUILD : cjd.type;
        jd.refreshHiveMetastore = cjd.refreshHiveMetastore;
        jd.autoUpdateSchemaBeforeEachRecipeRun = cjd.autoUpdateSchemaBeforeEachRecipeRun;
        jd.stopAtComputableRefs = cjd.stopAtComputableRefs;
        jd.stopAtFlowZoneBoundary = cjd.stopAtFlowZoneBoundary;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, jd.projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            jd.initiationTimestamp = System.currentTimeMillis();
            jd.triggeredFrom = JobDef.JobTriggerType.API;
            jd.initiator = authCtx.getIdentifier();
            jobId = this.flowExecutionService.startJob(jd, authCtx);
        }
        Id ret = new Id(jobId);
        JobDef outputDef = (JobDef)JSON.deepCopy((Object)jd);
        outputDef.id = ret.id;
        this.auditTrailService.generic("job-start").with("projectKey", projectKey).with("jobId", outputDef.id).emit();
        PublicAPIJobsController.writeJSON((HttpServletResponse)resp, (Object)outputDef);
    }

    @AuditedCall(value={"msgType", "job-get-status", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/{jobId}/"}, method={RequestMethod.GET})
    public void status(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String jobId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        EnhancedSerializedJobStatus ret = this.flowExecutionService.getStatus_NT(projectKey, jobId);
        try (Transaction t = this.transactionService.beginRead();){
            this.flowExecutionService.addInitiator(ret);
            PublicAPIJobsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "job-abort", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/{jobId}/abort"}, method={RequestMethod.POST})
    public void abort(HttpServletRequest req, HttpServletResponse resp, @PathVariable String jobId, @PathVariable String projectKey) throws IOException, SQLException, Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        this.flowExecutionService.abort_NT(null, projectKey, jobId);
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("abort requested");
        PublicAPIJobsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "job-download-status", "projectKey", "${projectKey}", "jobId", "${jobId}"})
    @RequestMapping(value={"/{jobId}/log"}, method={RequestMethod.GET})
    public void getLogs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String jobId, @RequestParam(defaultValue="") String activity) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            if (!PublicAPIJobsController.canAccessLogs(authCtx)) {
                throw new UnauthorizedException("Access denied", "Logs visibility is restricted. Contact your administrator if you need to access these logs");
            }
        }
        File log = StringUtils.isNotBlank((String)activity) ? LogsService.getActivityLogFile((String)projectKey, (String)jobId, (String)activity) : LogsService.getOutputDotLogFile((String)projectKey, (String)jobId);
        log = DKUFileUtils.getWithAutoDecompress((File)log);
        if (!log.isFile()) {
            PublicAPIJobsController.send404((String)("Log file " + log.getAbsolutePath() + " for job " + jobId + " not found"), (HttpServletResponse)resp);
            return;
        }
        this.writeFileWithAutoDecompress(resp, log, "text/plain");
    }

    public static boolean canAccessLogs(AuthCtx authCtx) {
        return !ApplicationConfigurator.hideLogs() || authCtx.isAdmin();
    }
}

