/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.DSSEvent;
import com.dataiku.dip.server.notifications.backend.TaggableObjectChangedEvent;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.PubSubService;
import com.dataiku.dip.server.services.TaggingService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/jupyter-notebooks"})
public class PublicAPIJupyterNotebooksController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private TaggingService taggingService;
    @Autowired
    private PubSubService pubSub;

    @AuditedCall(value={"msgType", "jupyter-notebooks-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void listJupyterNotebooks(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(value="active", defaultValue="false", required=false) boolean active) throws IOException, DKUSecurityException {
        List notebooks;
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            notebooks = this.jupyterService.list(authCtx, projectKey);
        }
        boolean onlyPersonalSessions = !authCtx.isAdmin();
        this.jupyterService.addActiveSessions(authCtx, notebooks, onlyPersonalSessions);
        List result = notebooks.stream().filter(notebook -> !active || !notebook.activeSessions.isEmpty()).map(PublicAPIJupyterNotebookListItem::new).collect(Collectors.toList());
        PublicAPIJupyterNotebooksController.writeJSON((HttpServletResponse)resp, result);
    }

    @AuditedCall(value={"msgType", "jupyter-notebooks-get", "projectKey", "${projectKey}", "notebookName", "${notebookName}"})
    @RequestMapping(value={"/{notebookName}"}, method={RequestMethod.GET})
    public void getJupyterNotebook(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String notebookName) throws IOException, DKUSecurityException {
        JupyterService.NotebookSafeForWritingNew notebook;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            notebook = this.getNotebookMandatory(projectKey, notebookName);
        }
        PublicAPIJupyterNotebooksController.writeJSON((HttpServletResponse)resp, (Object)notebook);
    }

    @AuditedCall(value={"msgType", "jupyter-notebooks-update", "projectKey", "${projectKey}", "notebookName", "${notebookName}"})
    @RequestMapping(value={"/{notebookName}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    public void updateJupyterNotebook(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String notebookName, @RequestBody JupyterService.NotebookSafeForWritingNew newNotebook) throws IOException, DKUSecurityException {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = t.getUser();
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            authCtx.failIfNoSafeCode("update a Jupyter notebook");
            if (!this.jupyterService.exists(projectKey, notebookName)) {
                throw new NotFoundException("Notebook '" + notebookName + "' doesn't exist in " + projectKey);
            }
            this.jupyterService.setModifiedBy(newNotebook, authCtx.getIdentifier());
            this.jupyterService.saveNotebook(projectKey, notebookName, newNotebook);
            this.pubSub.publishAfterTransaction((DSSEvent)new TaggableObjectChangedEvent(ITaggingService.TaggableType.JUPYTER_NOTEBOOK, projectKey, notebookName, authCtx, TaggableObjectChangedEvent.ActionType.JUPYTER_NOTEBOOK_EDIT));
            this.taggingService.onObjectSaved(projectKey, this.jupyterService.getTags(projectKey, notebookName));
            t.commit("Updated Jupyter notebook '" + notebookName + "'");
        }
        PublicAPIJupyterNotebooksController.writeJSON((HttpServletResponse)resp, (Object)this.getNotebookMandatory(projectKey, notebookName));
    }

    @AuditedCall(value={"msgType", "jupyter-notebooks-create", "projectKey", "${projectKey}", "notebookName", "${notebookName}"})
    @RequestMapping(value={"/{notebookName}"}, method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    public void createJupyterNotebook(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String notebookName, @RequestBody JupyterService.NotebookSafeForWritingNew newNotebook) throws IOException, DKUSecurityException {
        String language = this.getLanguageForNotebook(newNotebook);
        if (StringUtils.isBlank((CharSequence)language)) {
            throw new IllegalArgumentException("Couldn't create notebook, missing language information in kernelspec");
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            authCtx.failIfNoSafeCode("create a Jupyter notebook");
            this.jupyterService.checkLicenceForLanguage(authCtx, language);
            this.jupyterService.installNotebookFromFile(authCtx, projectKey, notebookName, null, newNotebook);
            t.commit("Created Jupyter notebook '" + notebookName + "'");
        }
        PublicAPIJupyterNotebooksController.writeJSON((HttpServletResponse)resp, (Object)this.getNotebookMandatory(projectKey, notebookName));
    }

    @AuditedCall(value={"msgType", "jupyter-notebooks-delete", "projectKey", "${projectKey}", "notebookName", "${notebookName}"})
    @RequestMapping(value={"/{notebookName}"}, method={RequestMethod.DELETE})
    public void deleteJupyterNotebook(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String notebookName) throws IOException, DKUSecurityException, CodedException {
        AuthCtx authCtx;
        String commitMessage = "Deleted Jupyter notebook '" + notebookName + "'";
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        this.jupyterService.unloadNotebookSessionsBeforeDeletion(authCtx, projectKey, notebookName);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.jupyterService.delete(projectKey, notebookName, t.getUser());
            t.commit(commitMessage);
        }
        this.writeMessage(resp, commitMessage, new Object[0]);
    }

    @AuditedCall(value={"msgType", "jupyter-notebooks-clear-outputs", "projectKey", "${projectKey}", "notebookName", "${notebookName}"})
    @RequestMapping(value={"/{notebookName}/outputs"}, method={RequestMethod.DELETE})
    public void deleteJupyterNotebookOutputs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String notebookName) throws IOException, DKUSecurityException {
        AuthCtx authCtx;
        String commitMessage = "Cleared outputs for Jupyter notebook '" + notebookName + "'";
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        try (RWTransaction rwt = this.transactionService.beginWriteForAPI(req);){
            if (this.jupyterService.deleteOutputs(projectKey, notebookName, authCtx)) {
                rwt.commitV(commitMessage, new Object[0]);
            }
        }
        this.writeMessage(resp, commitMessage, new Object[0]);
    }

    @AuditedCall(value={"msgType", "jupyter-notebook-sessions", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/{notebookName}/sessions"}, method={RequestMethod.GET})
    public void getJupyterNotebookActiveSessions(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String notebookName) throws DKUSecurityException, IOException {
        JupyterService.JupyterNotebookListEntry notebook;
        boolean onlyPersonalSessions;
        AuthCtx authCtx;
        try (Transaction ignored = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            onlyPersonalSessions = !authCtx.isAdmin();
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            notebook = this.jupyterService.getMandatoryUnsafe(projectKey, notebookName, false);
        }
        this.jupyterService.addActiveSessions(authCtx, Collections.singletonList(notebook), onlyPersonalSessions);
        PublicAPIJupyterNotebooksController.writeJSON((HttpServletResponse)resp, (Object)notebook.activeSessions);
    }

    @AuditedCall(value={"msgType", "jupyter-notebooks-unload", "projectKey", "${projectKey}", "notebookName", "${notebookName}"})
    @RequestMapping(value={"/{notebookName}/sessions/{sessionId:.+}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    public void unloadJupyterNotebook(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String notebookName, @PathVariable String sessionId) throws DKUSecurityException, IOException {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPermAndCanCreateWebContent(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
            JupyterService.JupyterNotebookListEntry notebook = this.jupyterService.getMandatoryUnsafe(projectKey, notebookName, false);
            this.jupyterService.addActiveSessions(authCtx, Collections.singletonList(notebook), !authCtx.isAdmin());
            if (notebook.activeSessions.stream().noneMatch(session -> sessionId.equals(session.sessionId))) {
                throw new NotFoundException("Session '" + sessionId + "' does not match any active session for notebook '" + notebookName + "' in project " + projectKey);
            }
        }
        PublicAPIJupyterNotebooksController.writeJSON((HttpServletResponse)resp, (Object)this.jupyterService.unloadSession(sessionId));
    }

    private String getLanguageForNotebook(JupyterService.NotebookSafeForWritingNew newNotebook) {
        JsonObject kernelSpec = JupyterService.safeGetMetadataJsonObject((JupyterService.NotebookSafeForWritingNew)newNotebook, (String)"kernelspec");
        if (kernelSpec != null && kernelSpec.has("language")) {
            return kernelSpec.get("language").getAsString();
        }
        return null;
    }

    private JupyterService.NotebookSafeForWritingNew getNotebookMandatory(String projectKey, String notebookName) throws IOException {
        try (Transaction t = this.transactionService.retrieveOrBeginRead();){
            JupyterService.NotebookSafeForWritingNew notebookSafeForWritingNew = this.jupyterService.loadNotebook(projectKey, notebookName, true);
            return notebookSafeForWritingNew;
        }
    }

    public static class PublicAPIJupyterNotebookListItem {
        public final String projectKey;
        public final String name;
        public final List<String> tags;
        public final long lastModifiedOn;
        public final String language;
        public final JupyterService.DisplayKernelSpec kernelSpec;

        public PublicAPIJupyterNotebookListItem(JupyterService.JupyterNotebookListEntry entry) {
            this.projectKey = entry.projectKey;
            this.name = entry.name;
            this.tags = entry.tags;
            this.lastModifiedOn = entry.lastModifiedOn;
            this.language = entry.language;
            this.kernelSpec = entry.displayKernelSpec;
        }
    }
}

