/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.connections.AbstractLLMConnection;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.llm.EnrichedLLMStructuredRef;
import com.dataiku.dip.llm.LLMAuditHelper;
import com.dataiku.dip.llm.LLMStructuredRef;
import com.dataiku.dip.llm.PretrainedModelsService;
import com.dataiku.dip.llm.audit.ImageAuditManagedFolderService;
import com.dataiku.dip.llm.governance.GuardrailRunner;
import com.dataiku.dip.llm.governance.GuardrailsBypassTokensService;
import com.dataiku.dip.llm.governance.GuardrailsPipelineRunner;
import com.dataiku.dip.llm.governance.GuardrailsPipelineSettings;
import com.dataiku.dip.llm.governance.GuardrailsPipelineUtils;
import com.dataiku.dip.llm.online.LLMClient;
import com.dataiku.dip.llm.online.LLMClientFactory;
import com.dataiku.dip.llm.online.LLMMeshClient;
import com.dataiku.dip.llm.online.LLMMeshClientFactory;
import com.dataiku.dip.llm.online.LLMTracingUtils;
import com.dataiku.dip.llm.online.NonParallelLLMClient;
import com.dataiku.dip.managedfolder.ManagedFolder;
import com.dataiku.dip.managedfolder.ManagedFolderDAO;
import com.dataiku.dip.managedfolder.ManagedFolderHandler;
import com.dataiku.dip.resourceusage.ComputeResourceUsage;
import com.dataiku.dip.resourceusage.ComputeResourceUsageReportingService;
import com.dataiku.dip.resourceusage.ComputeResourceUsageTicketUtils;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.AuthCtxUsage;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.api.openai.OpenAIAPIConverter;
import com.dataiku.dip.server.api.openai.OpenAIChatCompletionRequest;
import com.dataiku.dip.server.api.openai.OpenAIChatCompletionResponse;
import com.dataiku.dip.server.api.openai.OpenAIModels;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.streaming.endpoints.httpsse.MiniSSEEmitter;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.util.SecretKeyGenerator;
import com.dataiku.dip.utils.ExceptionUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dss.shadelib.com.google.common.base.Strings;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPILLMController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private GuardrailsBypassTokensService bypassTokensService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private ComputeResourceUsageReportingService cruReportingService;
    @Autowired
    private PretrainedModelsService pretrainedModelsService;
    @Autowired
    private ImageAuditManagedFolderService imageAuditService;
    @Autowired
    private ManagedFolderDAO managedFolderDAO;
    private static final String LLM_COMPLETION_AUDIT_CATEGORY = "llm-completion-query";

    private AuthCtx authAndCheckAccessAndSetCRUContext(HttpServletRequest req, String projectKey) throws DKUSecurityException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtxUsage authCtxUsage = this.authService.getTicketOrKeyAndContext(req);
            AuthCtx authCtx = authCtxUsage.getAuthCtx();
            this.permissionsService.checkAnyProjectAccess(authCtx, projectKey);
            ComputeResourceUsageTicketUtils.setCRUContextInThreadFromAuthCtxUsage((HttpServletRequest)req, (AuthCtxUsage)authCtxUsage);
            AuthCtx authCtx2 = authCtx;
            return authCtx2;
        }
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms/completions"}, method={RequestMethod.POST})
    public CompletionsResponse runCompletions(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        CompletionsRequest completionsRequest = (CompletionsRequest)this.getRequestBodyAs(req, CompletionsRequest.class);
        try {
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey);
            return this.getCompletionsResponse(req, projectKey, completionsRequest, authCtx);
        }
        catch (Exception e) {
            this.auditTrailService.failure(LLM_COMPLETION_AUDIT_CATEGORY, (Throwable)e).with("projectKey", projectKey).emit();
            throw e;
        }
    }

    private CompletionsResponse getCompletionsResponse(HttpServletRequest req, String projectKey, CompletionsRequest completionsRequest, AuthCtx authCtx) throws Exception {
        LLMStructuredRef llmRef = LLMStructuredRef.decodeId((String)completionsRequest.llmId);
        GuardrailsPipelineSettings connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings((AuthCtx)authCtx, (String)projectKey, (LLMStructuredRef)llmRef);
        GuardrailsPipelineSettings guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings((GuardrailsPipelineSettings)connectionGuardrailsPipelineSettings, (GuardrailsPipelineSettings)completionsRequest.guardrails);
        if (this.bypassTokensService.hasValidBypassToken(req)) {
            logger.debug((Object)"Request comes from a guardrail, bypassing guardrails for this request");
            guardrailsPipelineSettings = null;
        }
        try (LLMMeshClient llmMeshClient = LLMMeshClientFactory.get((AuthCtx)authCtx, (String)projectKey, (LLMStructuredRef)llmRef, (GuardrailsPipelineSettings)guardrailsPipelineSettings, null, (int)completionsRequest.queries.size());){
            EnrichedLLMStructuredRef enrichedLLMRef = llmMeshClient.getEnrichedRef();
            llmMeshClient.throwIfBadImageAuditFolder();
            List responses = llmMeshClient.completeQueries(completionsRequest.queries, completionsRequest.settings);
            ComputeResourceUsage cru = llmMeshClient.getTotalCRU(ComputeResourceUsage.LLMUsageType.COMPLETION);
            if (cru != null) {
                this.cruReportingService.reportComplete(cru);
            }
            AbstractLLMConnection llmConnection = llmMeshClient.getConnection();
            ManagedFolder mf = null;
            if (llmConnection != null && llmConnection.getLLMConnectionParams().storeImages) {
                logger.info((Object)String.format("Storing images in '%s'.", llmConnection.getLLMConnectionParams().imageAuditManagedFolderRef));
                try (Transaction t = this.transactionService.beginRead();){
                    mf = (ManagedFolder)this.managedFolderDAO.getMandatory(AnyLoc.resolveFull((String)llmConnection.getLLMConnectionParams().imageAuditManagedFolderRef));
                }
            }
            for (int recordIdx = 0; recordIdx < responses.size(); ++recordIdx) {
                ArrayList<String> savedImagePaths = new ArrayList<String>();
                if (mf != null) {
                    for (LLMClient.ChatMessagePart imagePart : completionsRequest.queries.get(recordIdx).getImageParts()) {
                        if (imagePart.containsImageData()) {
                            ManagedFolderHandler handler = (ManagedFolderHandler)mf.buildHandler((AuthCtx)DSSAuthCtx.newNone());
                            try {
                                String savedImagePath = this.imageAuditService.saveImage(imagePart.getImageData(), ImageAuditManagedFolderService.ImageAuditSource.TEXT_GENERATION_INPUT, handler);
                                savedImagePaths.add(savedImagePath);
                                continue;
                            }
                            finally {
                                if (handler != null) {
                                    handler.close();
                                }
                                continue;
                            }
                        }
                        savedImagePaths.add(imagePart.imageUrl);
                    }
                }
                LLMAuditHelper.emitLLMCompletionAuditFromBackendIfNeeded((AuditTrailService)this.auditTrailService, (LLMStructuredRef)enrichedLLMRef, (AbstractLLMConnection)llmMeshClient.getConnection(), (LLMClient.SingleCompletionQuery)completionsRequest.queries.get(recordIdx), (LLMClient.SimpleCompletionResponseOrError)((LLMClient.SimpleCompletionResponseOrError)responses.get(recordIdx)), savedImagePaths);
            }
            CompletionsResponse ret = new CompletionsResponse();
            ret.responses = responses;
            CompletionsResponse completionsResponse = ret;
            return completionsResponse;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms/streamed-completion"}, method={RequestMethod.POST})
    public void streamCompletion(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        FullCompletionRequest request = (FullCompletionRequest)this.getRequestBodyAs(req, FullCompletionRequest.class);
        try {
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey);
            this.streamCompletion(req, resp, projectKey, request, authCtx, new MiniSSEEmitter(resp, false), false, false);
        }
        catch (Exception e) {
            this.auditTrailService.failure(LLM_COMPLETION_AUDIT_CATEGORY, (Throwable)e).with("projectKey", projectKey).emit();
            logger.warn((Object)"Got error from LLM", (Throwable)e);
            throw new IOException("Failed to stream LLM completion", e);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void streamCompletion(HttpServletRequest httpReq, HttpServletResponse resp, String projectKey, final FullCompletionRequest request, AuthCtx authCtx, final MiniSSEEmitter emitter, final boolean isOpenAI, final boolean includeUsage) throws Exception {
        llmRef = LLMStructuredRef.decodeId((String)request.llmId);
        llmClient = LLMClientFactory.get((AuthCtx)authCtx, (String)projectKey, (LLMStructuredRef)llmRef);
        try {
            llmClient.throwIfBadImageAuditFolder();
            trace = LLMClient.LLMMeshTraceSpan.start((String)"DKU_LLM_MESH_COMPLETION_QUERY_STREAMED");
            LLMTracingUtils.addIdentifiersAndSetCompletionInput((LLMClient.LLMMeshTraceSpan)trace, (String)request.llmId, (LLMClient)llmClient, (LLMClient.SingleCompletionQuery)request.query, (LLMClient.CompletionSettings)request.settings);
            connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings((AuthCtx)authCtx, (String)projectKey, (LLMStructuredRef)llmRef);
            guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings((GuardrailsPipelineSettings)connectionGuardrailsPipelineSettings, (GuardrailsPipelineSettings)request.guardrails);
            if (this.bypassTokensService.hasValidBypassToken(httpReq)) {
                PublicAPILLMController.logger.debug((Object)"Request comes from a guardrail, bypassing guardrails for this request");
                guardrailsPipelineSettings = null;
            }
            if (!llmClient.supportsStream()) {
                PublicAPILLMController.logger.info((Object)("Streaming requested but LLM " + llmRef.id + " does not support it"));
                this.fallbackUnfulfillableStreamingRequestToEmulatedStreaming(resp, projectKey, request, authCtx, emitter, isOpenAI, includeUsage, llmClient, trace, guardrailsPipelineSettings);
                return;
            }
            if (GuardrailsPipelineUtils.needsNonStreamedNonParallelProcessing((GuardrailsPipelineSettings)guardrailsPipelineSettings)) {
                PublicAPILLMController.logger.info((Object)"Streaming requested but Guardrails don't support it");
                this.fallbackUnfulfillableStreamingRequestToEmulatedStreaming(resp, projectKey, request, authCtx, emitter, isOpenAI, includeUsage, llmClient, trace, guardrailsPipelineSettings);
                return;
            }
            openAIResponseId = isOpenAI != false ? "chatcmpl-" + SecretKeyGenerator.generateSmall() : null;
            enrichedLLMRef = llmClient.getEnrichedRef();
            PublicAPILLMController.logger.info((Object)("Sending single completion query to LLM:  " + JSON.json((Object)request.query)));
            guardrailAuditData = null;
            guardrailsRunner = new GuardrailsPipelineRunner(authCtx, projectKey, guardrailsPipelineSettings);
            try {
                guardrailContext = new GuardrailRunner.GuardrailContext();
                guardrailSpan = trace.withChildSpan("DKU_LLM_MESH_QUERY_ENFORCEMENT");
                try {
                    guardrailResponse = guardrailsRunner.processCompletionQuery(guardrailContext, request.query, request.settings, guardrailSpan);
                    switch (2.$SwitchMap$com$dataiku$dip$llm$governance$GuardrailRunner$QueryGuardrailAction[guardrailResponse.action.ordinal()]) {
                        case 1: {
                            throw guardrailResponse.toException();
                        }
                        case 2: {
                            GuardrailsPipelineUtils.updateCompletionQueryFromGuardrailsResponse((LLMClient.SingleCompletionQuery)request.query, (GuardrailRunner.CompletionQueryGuardrailResponse)guardrailResponse);
                            ** break;
lbl36:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            GuardrailsPipelineUtils.updateCompletionQueryFromGuardrailsResponse((LLMClient.SingleCompletionQuery)request.query, (GuardrailRunner.CompletionQueryGuardrailResponse)guardrailResponse);
                            guardrailAuditData = guardrailResponse.auditData;
                            break;
                        }
                        ** default:
lbl42:
                        // 1 sources

                        break;
                    }
                }
                finally {
                    if (guardrailSpan != null) {
                        guardrailSpan.close();
                    }
                }
                callSpan = trace.withChildSpan("DKU_LLM_MESH_LLM_CALL_STREAMED");
                try {
                    completeText = new StringBuilder();
                    finishReason = new AtomicReference<V>();
                    allLogProbs = new ArrayList<E>();
                    completeToolCalls = new ArrayList<E>();
                    firstChunkReceived = new MutableBoolean(false);
                    LLMTracingUtils.addIdentifiersAndSetCompletionInput((LLMClient.LLMMeshTraceSpan)callSpan, (String)request.llmId, (LLMClient)llmClient, (LLMClient.SingleCompletionQuery)request.query, (LLMClient.CompletionSettings)request.settings);
                    consumer = new LLMClient.StreamedCompletionResponseConsumer(){

                        public void onStreamStarted() throws Exception {
                            PublicAPIControllerBase.logger.debug((Object)"Stream started");
                            emitter.initSuccess();
                        }

                        public void onStreamChunk(LLMClient.StreamedCompletionResponseChunk chunk) throws Exception {
                            if (!firstChunkReceived.booleanValue()) {
                                PublicAPIControllerBase.logger.debug((Object)"First chunk received");
                                callSpan.withChildEvent("DKU_LLM_MESH_LLM_CALL_STREAMED_FIRST_CHUNK");
                                firstChunkReceived.setValue(true);
                            }
                            if (chunk.text != null) {
                                completeText.append(chunk.text);
                            }
                            if (chunk.toolCalls != null) {
                                completeToolCalls.addAll(chunk.toolCalls);
                            }
                            if (chunk.logProbs != null && !chunk.logProbs.isEmpty()) {
                                allLogProbs.addAll(chunk.logProbs);
                            }
                            if (isOpenAI) {
                                emitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIChunkResponse(request.llmId, openAIResponseId, chunk)), false);
                            } else {
                                boolean urgent = "event".equals(chunk.type);
                                emitter.sendEventWithData("completion-chunk", JSON.json((Object)chunk), urgent);
                            }
                        }

                        public void onStreamComplete(LLMClient.StreamedCompletionResponseFooter footer) throws Exception {
                            PublicAPIControllerBase.logger.info((Object)("onStreamComplete: " + JSON.json((Object)footer)));
                            callSpan.withChildEvent("DKU_LLM_MESH_LLM_CALL_STREAMED_STREAM_COMPLETE");
                            if (footer.finishReason != null) {
                                finishReason.set(footer.finishReason);
                            }
                            LLMClient.SimpleCompletionResponseOrError screForTrace = LLMClient.SimpleCompletionResponseOrError.blank();
                            screForTrace.text = completeText.toString();
                            screForTrace.toolCalls = completeToolCalls;
                            LLMTracingUtils.setCompletionOutput((LLMClient.LLMMeshTraceSpan)callSpan, (LLMClient.SimpleCompletionResponseOrError)screForTrace);
                            LLMTracingUtils.setCompletionOutput((LLMClient.LLMMeshTraceSpan)trace, (LLMClient.SimpleCompletionResponseOrError)screForTrace);
                            callSpan.usageMetadata = new LLMClient.UsageMetadata(footer);
                            callSpan.close();
                            trace.close();
                            if (footer.trace != null) {
                                callSpan.addObservation((LLMClient.LLMMeshTraceObservation)footer.trace);
                            }
                            footer.trace = trace;
                            if (isOpenAI) {
                                emitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIChunkResponse(request.llmId, openAIResponseId, footer)), false);
                                if (includeUsage) {
                                    emitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIChunkUsageResponse(request.llmId, openAIResponseId, footer)), false);
                                }
                            } else {
                                emitter.sendEventWithData("completion-end", JSON.json((Object)footer), false);
                            }
                        }
                    };
                    guardrailedConsumer = guardrailsRunner.newStreamedCompletionResponseHandler(consumer, guardrailContext, request.query, trace);
                    refusalException = null;
                    try {
                        llmClient.streamComplete(request.query, request.settings, guardrailedConsumer);
                    }
                    catch (LLMClient.RefusalException e) {
                        refusalException = e;
                    }
                    if (refusalException == null) {
                        scre = LLMClient.SimpleCompletionResponseOrError.blank();
                        scre.text = completeText.toString();
                        scre.logProbs = allLogProbs;
                        reason = (LLMClient.FinishReason)finishReason.get();
                        if (reason != null) {
                            scre.finishReason = reason;
                        } else {
                            PublicAPILLMController.logger.debug((Object)String.format("The streamed answer does not include a finish reason, defaulting to '%s'", new Object[]{scre.finishReason}));
                        }
                        PublicAPILLMController.logger.info((Object)("Done streaming answer from LLM: " + JSON.json((Object)scre)));
                    } else {
                        scre = LLMClient.SimpleCompletionResponseOrError.fromError((Throwable)refusalException);
                        PublicAPILLMController.logger.warn((Object)("Got refusal from LLM: " + JSON.json((Object)scre)));
                    }
                    scre.trace = trace;
                    scre.guardrailsAuditData = guardrailAuditData;
                    cru = llmClient.getTotalCRU(ComputeResourceUsage.LLMUsageType.COMPLETION, (LLMStructuredRef)enrichedLLMRef);
                    if (cru != null) {
                        cru.llmUsage.totalQueries = 1L;
                        cru.llmUsage.cacheHitQueries = 0L;
                        cru.llmUsage.cacheMissQueries = 1L;
                        this.cruReportingService.reportComplete(cru);
                    }
                    llmConnection = llmClient.getConnection();
                    mf = null;
                    if (llmConnection != null && llmConnection.getLLMConnectionParams().storeImages) {
                        PublicAPILLMController.logger.info((Object)String.format("Storing images in '%s'.", new Object[]{llmConnection.getLLMConnectionParams().imageAuditManagedFolderRef}));
                        t = this.transactionService.beginRead();
                        try {
                            mf = (ManagedFolder)this.managedFolderDAO.getMandatory(AnyLoc.resolveFull((String)llmConnection.getLLMConnectionParams().imageAuditManagedFolderRef));
                        }
                        finally {
                            if (t != null) {
                                t.close();
                            }
                        }
                    }
                    savedImagePaths = new ArrayList<String>();
                    if (mf != null) {
                        for (LLMClient.ChatMessagePart imagePart : request.query.getImageParts()) {
                            if (imagePart.containsImageData()) {
                                handler = (ManagedFolderHandler)mf.buildHandler((AuthCtx)DSSAuthCtx.newNone());
                                try {
                                    savedImagePath = this.imageAuditService.saveImage(imagePart.getImageData(), ImageAuditManagedFolderService.ImageAuditSource.TEXT_GENERATION_INPUT, handler);
                                    savedImagePaths.add(savedImagePath);
                                    continue;
                                }
                                finally {
                                    if (handler != null) {
                                        handler.close();
                                    }
                                    continue;
                                }
                            }
                            savedImagePaths.add(imagePart.imageUrl);
                        }
                    }
                    LLMAuditHelper.emitLLMCompletionAuditFromBackendIfNeeded((AuditTrailService)this.auditTrailService, (LLMStructuredRef)enrichedLLMRef, (AbstractLLMConnection)llmClient.getConnection(), (LLMClient.SingleCompletionQuery)request.query, (LLMClient.SimpleCompletionResponseOrError)scre, savedImagePaths);
                    if (refusalException != null) {
                        if (!isOpenAI) {
                            throw refusalException;
                        }
                        emitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIRefusalChunk(request.llmId, openAIResponseId, refusalException)), false);
                        emitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIRefusalLastChunk(request.llmId, openAIResponseId)), false);
                        if (includeUsage) {
                            emitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIRefusalUsage(request.llmId, openAIResponseId, refusalException)), false);
                        }
                    }
                }
                finally {
                    if (callSpan != null) {
                        callSpan.close();
                    }
                }
            }
            finally {
                guardrailsRunner.close();
            }
        }
        finally {
            if (llmClient != null) {
                llmClient.close();
            }
        }
    }

    private void fallbackUnfulfillableStreamingRequestToEmulatedStreaming(HttpServletResponse httpResp, String projectKey, FullCompletionRequest request, AuthCtx authCtx, MiniSSEEmitter emitter, boolean isOpenAI, boolean includeUsage, LLMClient llmClient, LLMClient.LLMMeshTraceSpan trace, GuardrailsPipelineSettings guardrailsPipelineSettings) throws Exception {
        NonParallelLLMClient np = new NonParallelLLMClient(authCtx, llmClient, guardrailsPipelineSettings, projectKey, null);
        String openAIResponseId = isOpenAI ? "chatcmpl-" + SecretKeyGenerator.generateSmall() : null;
        EnrichedLLMStructuredRef enrichedLLMRef = llmClient.getEnrichedRef();
        List resps = np.completeQueries((List)Lists.newArrayList((Object[])new LLMClient.SingleCompletionQuery[]{request.query}), request.settings);
        LLMClient.SimpleCompletionResponseOrError resp = (LLMClient.SimpleCompletionResponseOrError)resps.get(0);
        if (resp.ok) {
            emitter.initSuccess();
            LLMClient.StreamedCompletionResponseChunk completeChunk = new LLMClient.StreamedCompletionResponseChunk();
            completeChunk.type = "content";
            completeChunk.text = resp.text;
            completeChunk.toolCalls = resp.toolCalls;
            completeChunk.logProbs = resp.logProbs;
            if (isOpenAI) {
                emitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIChunkResponse(request.llmId, openAIResponseId, completeChunk)), false);
            } else {
                emitter.sendEventWithData("completion-chunk", JSON.json((Object)completeChunk), false);
            }
            LLMClient.StreamedCompletionResponseFooter footer = new LLMClient.StreamedCompletionResponseFooter();
            footer.finishReason = resp.finishReason;
            footer.trace = resp.trace;
            footer.additionalInformation = resp.additionalInformation;
            footer.promptTokens = resp.promptTokens;
            footer.completionTokens = resp.completionTokens;
            footer.totalTokens = resp.totalTokens;
            footer.tokenCountsAreEstimated = resp.tokenCountsAreEstimated;
            footer.estimatedCost = resp.estimatedCost;
            if (isOpenAI) {
                emitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIChunkResponse(request.llmId, openAIResponseId, footer)), false);
                if (includeUsage) {
                    emitter.sendEventWithData(null, JSON.json((Object)OpenAIAPIConverter.convertToOpenAIChunkUsageResponse(request.llmId, openAIResponseId, footer)), false);
                }
            } else {
                emitter.sendEventWithData("completion-end", JSON.json((Object)footer), false);
            }
        } else {
            throw new IOException("Request failed: " + resp.errorMessage);
        }
        ComputeResourceUsage cru = llmClient.getTotalCRU(ComputeResourceUsage.LLMUsageType.COMPLETION, (LLMStructuredRef)enrichedLLMRef);
        if (cru != null) {
            cru.llmUsage.totalQueries = 1L;
            cru.llmUsage.cacheHitQueries = resp.fromCache ? 1L : 0L;
            cru.llmUsage.cacheMissQueries = resp.fromCache ? 0L : 1L;
            this.cruReportingService.reportComplete(cru);
        }
        LLMAuditHelper.emitLLMCompletionAuditFromBackendIfNeeded((AuditTrailService)this.auditTrailService, (LLMStructuredRef)enrichedLLMRef, (AbstractLLMConnection)llmClient.getConnection(), (LLMClient.SingleCompletionQuery)request.query, (LLMClient.SimpleCompletionResponseOrError)resp);
    }

    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms/embeddings"}, method={RequestMethod.POST})
    public EmbeddingsResponse runEmbeddings(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        EmbeddingsResponse embeddingsResponse;
        block11: {
            EmbeddingsRequest request = (EmbeddingsRequest)this.getRequestBodyAs(req, EmbeddingsRequest.class);
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey);
            LLMStructuredRef llmRef = LLMStructuredRef.decodeId((String)request.llmId);
            GuardrailsPipelineSettings connectionGuardrailsPipelineSettings = GuardrailsPipelineUtils.getConnectionAndLLMLevelSettings((AuthCtx)authCtx, (String)projectKey, (LLMStructuredRef)llmRef);
            GuardrailsPipelineSettings guardrailsPipelineSettings = GuardrailsPipelineUtils.mergeEnforcementSettings((GuardrailsPipelineSettings)connectionGuardrailsPipelineSettings, (GuardrailsPipelineSettings)request.guardrails);
            if (this.bypassTokensService.hasValidBypassToken(req)) {
                logger.debug((Object)"Request comes from a guardrail, bypassing guardrails for this request");
                guardrailsPipelineSettings = null;
            }
            LLMMeshClient llmMeshClient = LLMMeshClientFactory.get((AuthCtx)authCtx, (String)projectKey, (LLMStructuredRef)llmRef, (GuardrailsPipelineSettings)guardrailsPipelineSettings, null, (int)request.queries.size());
            try {
                EnrichedLLMStructuredRef enrichedLLMRef = llmMeshClient.getEnrichedRef();
                List responses = llmMeshClient.embedQueries(request.queries, request.settings);
                HashSet<ComputeResourceUsage.LLMUsageType> requestUsagesTypes = new HashSet<ComputeResourceUsage.LLMUsageType>();
                int i = 0;
                for (LLMClient.EmbeddingQuery query : request.queries) {
                    ComputeResourceUsage.LLMUsageType queryUsageType = PublicAPILLMController.getEmbeddingLLMUsageType(query);
                    requestUsagesTypes.add(queryUsageType);
                    LLMAuditHelper.emitLLMEmbeddingAudit((AuditTrailService)this.auditTrailService, (EnrichedLLMStructuredRef)enrichedLLMRef, (AbstractLLMConnection)llmMeshClient.getConnection(), (ComputeResourceUsage.LLMUsageType)queryUsageType, (String)query.text, (LLMClient.SimpleEmbeddingResponseOrError)((LLMClient.SimpleEmbeddingResponseOrError)responses.get(i)));
                    ++i;
                }
                ComputeResourceUsage.LLMUsageType requestAggUsageType = requestUsagesTypes.size() == 1 ? (ComputeResourceUsage.LLMUsageType)requestUsagesTypes.iterator().next() : ComputeResourceUsage.LLMUsageType.MULTIMODAL_EMBEDDING_EXTRACTION;
                ComputeResourceUsage cru = llmMeshClient.getTotalCRU(requestAggUsageType);
                if (cru != null) {
                    this.cruReportingService.reportComplete(cru);
                }
                EmbeddingsResponse ret = new EmbeddingsResponse();
                ret.responses = responses;
                embeddingsResponse = ret;
                if (llmMeshClient == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (llmMeshClient != null) {
                        try {
                            llmMeshClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.auditTrailService.failure("llm-embeddings", (Throwable)e).with("projectKey", projectKey).emit();
                    throw e;
                }
            }
            llmMeshClient.close();
        }
        return embeddingsResponse;
    }

    /*
     * Exception decompiling
     */
    @AuditInline
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms/images"}, method={RequestMethod.POST})
    public LLMClient.ImageGenerationResponseOrError generateImage(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static ComputeResourceUsage.LLMUsageType getEmbeddingLLMUsageType(LLMClient.EmbeddingQuery query) {
        if (query.hasImage() && query.hasText()) {
            return ComputeResourceUsage.LLMUsageType.MULTIMODAL_EMBEDDING_EXTRACTION;
        }
        if (query.hasImage()) {
            return ComputeResourceUsage.LLMUsageType.IMAGE_EMBEDDING_EXTRACTION;
        }
        return ComputeResourceUsage.LLMUsageType.TEXT_EMBEDDING_EXTRACTION;
    }

    @AuditedCall(value={"msgType", "llm-mesh-llms-list", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms"}, method={RequestMethod.GET})
    public List<EnrichedLLMStructuredRef> listLLMs(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(defaultValue="GENERIC_COMPLETION") String purpose) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List list = this.pretrainedModelsService.listAvailableLLMs((AuthCtx)authCtx, (String)projectKey, (AbstractLLMConnection.LLMUsagePurpose)AbstractLLMConnection.LLMUsagePurpose.valueOf((String)purpose)).identifiers;
            return list;
        }
    }

    @AuditedCall(value={"msgType", "llm-mesh-llms-list", "projectKey", "${projectKey}"})
    @ResponseBody
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms/openai/v1/models"}, method={RequestMethod.GET})
    public OpenAIModels listOpenAIModels(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            List openAIModelList = this.pretrainedModelsService.listAvailableLLMs((AuthCtx)authCtx, (String)projectKey, (AbstractLLMConnection.LLMUsagePurpose)AbstractLLMConnection.LLMUsagePurpose.GENERIC_COMPLETION).identifiers.stream().map(enrichedLLMStructuredRef -> {
                OpenAIModels.OpenAIModel openAIModel = new OpenAIModels.OpenAIModel();
                openAIModel.id = enrichedLLMStructuredRef.id;
                return openAIModel;
            }).collect(Collectors.toList());
            OpenAIModels openAIModels = new OpenAIModels();
            openAIModels.data = openAIModelList;
            OpenAIModels openAIModels2 = openAIModels;
            return openAIModels2;
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/projects/{projectKey}/llms/openai/v1/chat/completions"}, method={RequestMethod.POST})
    public void runOpenAICompletion(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        String requestURI = req.getRequestURI();
        try {
            AuthCtx authCtx = this.authAndCheckAccessAndSetCRUContext(req, projectKey);
            OpenAIChatCompletionRequest openAIChatCompletionRequest = (OpenAIChatCompletionRequest)this.getRequestBodyAs(req, OpenAIChatCompletionRequest.class);
            if (Boolean.TRUE.equals(openAIChatCompletionRequest.stream)) {
                this.openaiStreamCompletion(resp, projectKey, openAIChatCompletionRequest, authCtx, req);
            } else {
                CompletionsRequest completionsRequest = OpenAIAPIConverter.convertToCompletionRequest(openAIChatCompletionRequest);
                OpenAIChatCompletionResponse response = OpenAIAPIConverter.convertToOpenAIResponse(openAIChatCompletionRequest, this.getCompletionsResponse(req, projectKey, completionsRequest, authCtx));
                if (response.error != null && !Strings.isNullOrEmpty((String)response.error.message)) {
                    resp.setStatus(400);
                }
                PublicAPILLMController.writeJSON((HttpServletResponse)resp, (Object)response);
            }
        }
        catch (DKUSecurityException e) {
            this.writeOpenAIChatCompletionErrorResponse((Exception)((Object)e), projectKey, resp, 403, requestURI);
        }
        catch (DKUControllerBase.MalformedRequestException | IllegalArgumentException | UnsupportedOperationException e) {
            this.writeOpenAIChatCompletionErrorResponse((Exception)e, projectKey, resp, 400, requestURI);
        }
        catch (Exception e) {
            this.writeOpenAIChatCompletionErrorResponse(e, projectKey, resp, 500, requestURI);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void openaiStreamCompletion(HttpServletResponse resp, String projectKey, OpenAIChatCompletionRequest openAIChatCompletionRequest, AuthCtx authCtx, HttpServletRequest req) throws Exception {
        block14: {
            String requestURI = req.getRequestURI();
            try (MiniSSEEmitter emitter = new MiniSSEEmitter(resp, false);){
                try {
                    FullCompletionRequest request = OpenAIAPIConverter.convertToFullCompletionRequest(openAIChatCompletionRequest);
                    boolean includeUsage = Boolean.TRUE.equals(openAIChatCompletionRequest.stream) && openAIChatCompletionRequest.stream_options != null && Boolean.TRUE.equals(openAIChatCompletionRequest.stream_options.include_usage);
                    this.streamCompletion(req, resp, projectKey, request, authCtx, new MiniSSEEmitter(resp, false), true, includeUsage);
                }
                catch (DKUSecurityException e) {
                    this.writeOpenAIChatStreamCompletionErrorResponse((Exception)((Object)e), projectKey, resp, 403, emitter, requestURI);
                }
                catch (DKUControllerBase.MalformedRequestException | IllegalArgumentException | UnsupportedOperationException e) {
                    this.writeOpenAIChatStreamCompletionErrorResponse((Exception)e, projectKey, resp, 400, emitter, requestURI);
                }
                catch (Exception e2) {
                    this.writeOpenAIChatStreamCompletionErrorResponse(e2, projectKey, resp, 500, emitter, requestURI);
                    break block14;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    emitter.sendEventWithData(null, "[DONE]", false);
                }
            }
        }
    }

    private void writeOpenAIChatStreamCompletionErrorResponse(Exception e, String projectKey, HttpServletResponse resp, int errorCode, MiniSSEEmitter emitter, String requestURI) throws Exception {
        this.auditTrailService.failure(LLM_COMPLETION_AUDIT_CATEGORY, (Throwable)e).with("projectKey", projectKey).emit();
        this.logOpenAIAPIException(requestURI, e);
        OpenAIChatCompletionResponse errorResponse = new OpenAIChatCompletionResponse();
        errorResponse.error = new OpenAIChatCompletionResponse.OpenAIChatCompletionError();
        errorResponse.error.message = ExceptionUtils.getMessageWithCauses((Throwable)e);
        resp.setStatus(errorCode);
        emitter.sendEventWithData(null, JSON.json((Object)errorResponse), false);
    }

    private void writeOpenAIChatCompletionErrorResponse(Exception e, String projectKey, HttpServletResponse resp, int errorCode, String requestURI) throws IOException {
        this.auditTrailService.failure(LLM_COMPLETION_AUDIT_CATEGORY, (Throwable)e).with("projectKey", projectKey).emit();
        this.logOpenAIAPIException(requestURI, e);
        OpenAIChatCompletionResponse errorResponse = new OpenAIChatCompletionResponse();
        errorResponse.error = new OpenAIChatCompletionResponse.OpenAIChatCompletionError();
        errorResponse.error.message = ExceptionUtils.getMessageWithCauses((Throwable)e);
        resp.setStatus(errorCode);
        PublicAPILLMController.writeJSON((HttpServletResponse)resp, (Object)errorResponse);
    }

    private void logOpenAIAPIException(String requestURI, Exception e) {
        if (PublicAPILLMController.exceptionStackIsWorthPrintingInLogs((Throwable)e)) {
            logger.error((Object)("API call '" + requestURI + "' failed"), (Throwable)e);
        } else {
            logger.error((Object)("API call '" + requestURI + "' failed: " + ExceptionUtils.getMessageWithCauses((Throwable)e)));
        }
    }

    public static class CompletionsRequest {
        public String llmId;
        public List<LLMClient.SingleCompletionQuery> queries = new ArrayList<LLMClient.SingleCompletionQuery>();
        public LLMClient.CompletionSettings settings = new LLMClient.CompletionSettings();
        public GuardrailsPipelineSettings guardrails;
    }

    public static class CompletionsResponse {
        public List<LLMClient.SimpleCompletionResponseOrError> responses = new ArrayList<LLMClient.SimpleCompletionResponseOrError>();
    }

    public static class FullCompletionRequest {
        public String llmId;
        public LLMClient.SingleCompletionQuery query;
        public LLMClient.CompletionSettings settings = new LLMClient.CompletionSettings();
        public GuardrailsPipelineSettings guardrails;
    }

    static class EmbeddingsRequest {
        public String llmId;
        public List<LLMClient.EmbeddingQuery> queries = new ArrayList<LLMClient.EmbeddingQuery>();
        public LLMClient.EmbeddingSettings settings = new LLMClient.EmbeddingSettings();
        public GuardrailsPipelineSettings guardrails;

        EmbeddingsRequest() {
        }
    }

    static class EmbeddingsResponse {
        public List<LLMClient.SimpleEmbeddingResponseOrError> responses = new ArrayList<LLMClient.SimpleEmbeddingResponseOrError>();

        EmbeddingsResponse() {
        }
    }
}

