/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.common.collect.Lists;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/notebooks"})
public class PublicAPINotebooksController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private IJupyterService jupyterService;

    @Deprecated
    @AuditedCall(value={"msgType", "notebooks-list", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/active"}, method={RequestMethod.GET})
    public void listNotebooks(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws DKUSecurityException, IOException {
        List notebookEntries;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            notebookEntries = this.jupyterService.list(authCtx, projectKey);
        }
        this.jupyterService.addActiveSessions(authCtx, notebookEntries);
        this.jupyterService.addKernelSpecInfo(authCtx, notebookEntries);
        ArrayList notebooks = Lists.newArrayList();
        for (JupyterService.JupyterNotebookListEntry notebook : notebookEntries) {
            if (notebook.activeSessions.isEmpty()) continue;
            notebooks.add(new ActiveNotebook(notebook));
        }
        PublicAPINotebooksController.writeJSON((HttpServletResponse)resp, (Object)notebooks);
    }

    @Deprecated
    @AuditedCall(value={"msgType", "notebooks-get", "projectKey", "${projectKey}", "notebookName", "${notebookName}"})
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public void get(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String notebookName) throws DKUSecurityException, IOException {
        JupyterService.JupyterNotebookListEntry notebook;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            notebook = this.jupyterService.getOrNullUnsafe(projectKey, notebookName);
            if (notebook == null) {
                throw new NotFoundException("Notebook '" + projectKey + "' in '" + notebookName + "' doesn't exist");
            }
        }
        this.jupyterService.addKernelSpecInfo(authCtx, (List)Lists.newArrayList((Object[])new JupyterService.JupyterNotebookListEntry[]{notebook}));
        PublicAPINotebooksController.writeJSON((HttpServletResponse)resp, (Object)new ActiveNotebook(notebook));
    }

    @Deprecated
    @AuditedCall(value={"msgType", "notebooks-unload", "projectKey", "${projectKey}", "notebookName", "${notebookName}"})
    @RequestMapping(value={"/"}, method={RequestMethod.DELETE})
    public void unload(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String notebookName, @RequestParam String sessionId) throws DKUSecurityException, IOException {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.ADMIN});
        }
        PublicAPINotebooksController.writeJSON((HttpServletResponse)resp, (Object)this.jupyterService.unloadSession(sessionId));
    }

    public static class ActiveNotebook {
        public final String name;
        public final String projectKey;
        public final List<String> tags;
        public final String creator;
        public final String language;
        public final String associatedRecipe;
        public final String analyzedDataset;
        public final long lastModifiedOn;
        public final List<JupyterService.ActiveSession> activeSessions;

        ActiveNotebook(JupyterService.JupyterNotebookListEntry notebook) {
            this.name = notebook.getId();
            this.projectKey = notebook.getProjectKey();
            this.tags = Lists.newArrayList((Iterable)notebook.tags);
            this.creator = notebook.creator;
            this.language = notebook.language;
            this.associatedRecipe = notebook.associatedRecipe;
            this.analyzedDataset = notebook.analyzedDataset;
            this.lastModifiedOn = notebook.lastModifiedOn;
            this.activeSessions = notebook.activeSessions;
        }
    }
}

