/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.projectstandards.ProjectStandardsCheck;
import com.dataiku.dip.projectstandards.ProjectStandardsCheckSpecInfo;
import com.dataiku.dip.projectstandards.ProjectStandardsRunReport;
import com.dataiku.dip.projectstandards.ProjectStandardsScope;
import com.dataiku.dip.projectstandards.ProjectStandardsService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIProjectStandardsController
extends PublicAPIControllerBase {
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private ProjectStandardsService projectStandardsService;

    @AuditedCall(value={"msgType", "project-standards-list-check-specs"})
    @RequestMapping(value={"/publicapi/project-standards/check-specs"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProjectStandardsCheckSpecInfo> listCheckSpecs(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            List list = this.projectStandardsService.listSpecsInfo();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-checks-import"})
    @RequestMapping(value={"/publicapi/project-standards/checks/actions/import"}, method={RequestMethod.POST})
    @ResponseBody
    public List<ProjectStandardsCheck> importChecksByElementTypes(HttpServletRequest req, HttpServletResponse resp, @RequestParam List<String> checkSpecElementTypes) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            List newChecks = this.projectStandardsService.importChecksFromCheckSpecs(checkSpecElementTypes, false);
            t.commitV("%d project standards checks have been created from element types %s", new Object[]{newChecks.size(), checkSpecElementTypes});
            List list = newChecks;
            return list;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-check-get"})
    @RequestMapping(value={"/publicapi/project-standards/checks/{checkId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectStandardsCheck getCheck(HttpServletRequest req, HttpServletResponse resp, @PathVariable String checkId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            ProjectStandardsCheck projectStandardsCheck = this.projectStandardsService.getCheckUnsafe(checkId);
            return projectStandardsCheck;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-check-save"})
    @RequestMapping(value={"/publicapi/project-standards/checks/{checkId}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ProjectStandardsCheck saveCheck(HttpServletRequest req, HttpServletResponse resp, @PathVariable String checkId, @RequestBody ProjectStandardsCheck check) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)check.id) && !check.id.equals(checkId)) {
            throw new IllegalArgumentException(String.format("Id of the check '%s' should be null or equal to the id in the URL path '%s'", check.id, checkId));
        }
        check.id = checkId;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            this.projectStandardsService.saveCheck(check, false);
            t.commitV("Project standards check with id '%s' has been saved", new Object[]{check.id});
            ProjectStandardsCheck projectStandardsCheck = check;
            return projectStandardsCheck;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-check-delete"})
    @RequestMapping(value={"/publicapi/project-standards/checks/{checkId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteCheck(HttpServletRequest req, HttpServletResponse resp, @PathVariable String checkId) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            this.projectStandardsService.deleteCheck(checkId, false);
            t.commitV("Project standards check with id '%s' has been deleted", new Object[]{checkId});
        }
    }

    @AuditedCall(value={"msgType", "project-standards-checks-get"})
    @RequestMapping(value={"/publicapi/project-standards/checks"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProjectStandardsCheck> getChecks(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            List list = this.projectStandardsService.getChecksUnsafe();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-scope-get"})
    @RequestMapping(value={"/publicapi/project-standards/scopes/{scopeName}"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectStandardsScope getScope(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scopeName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            ProjectStandardsScope projectStandardsScope = this.projectStandardsService.getScopeUnsafe(scopeName);
            return projectStandardsScope;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-scope-create"})
    @RequestMapping(value={"/publicapi/project-standards/scopes/{scopeName}"}, method={RequestMethod.POST})
    @ResponseBody
    public ProjectStandardsScope createScope(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scopeName, @RequestBody ProjectStandardsScope newScope) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)newScope.name) && !newScope.name.equals(scopeName)) {
            throw new IllegalArgumentException(String.format("Name of the scope '%s' should be null or equal to the name in the URL path '%s'", newScope.name, scopeName));
        }
        newScope.name = scopeName;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            this.projectStandardsService.createScope(newScope, false);
            t.commitV("Project standards scope with name '%s' has been created", new Object[]{newScope.name});
            ProjectStandardsScope projectStandardsScope = newScope;
            return projectStandardsScope;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-scope-save"})
    @RequestMapping(value={"/publicapi/project-standards/scopes/{scopeName}"}, method={RequestMethod.PUT})
    @ResponseBody
    public ProjectStandardsScope saveScope(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scopeName, @RequestBody ProjectStandardsScope newScope) throws Exception {
        if (StringUtils.isNotEmpty((CharSequence)newScope.name) && !newScope.name.equals(scopeName)) {
            throw new IllegalArgumentException(String.format("Name of the scope '%s' should be null or equal to the name in the URL path '%s'", newScope.name, scopeName));
        }
        newScope.name = scopeName;
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            ProjectStandardsScope savedScope = this.projectStandardsService.saveScope(newScope, false);
            t.commitV("Project standards scope with name '%s' has been saved", new Object[]{newScope.name});
            ProjectStandardsScope projectStandardsScope = savedScope;
            return projectStandardsScope;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-scope-delete"})
    @RequestMapping(value={"/publicapi/project-standards/scopes/{scopeName}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteScope(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scopeName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            this.projectStandardsService.deleteScope(scopeName, false);
            t.commitV("Project standards scope with name '%s' has been deleted", new Object[]{scopeName});
        }
    }

    @AuditedCall(value={"msgType", "project-standards-scope-reorder"})
    @RequestMapping(value={"/publicapi/project-standards/scopes/{scopeName}/actions/reorder"}, method={RequestMethod.POST})
    @ResponseBody
    public void reorderScope(HttpServletRequest req, HttpServletResponse resp, @PathVariable String scopeName, @RequestParam int index) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            this.projectStandardsService.reorderScope(scopeName, index, false);
            t.commitV("Project standards scope with name '%s' has been moved at index %s", new Object[]{scopeName, index});
        }
    }

    @AuditedCall(value={"msgType", "project-standards-scopes-get"})
    @RequestMapping(value={"/publicapi/project-standards/scopes"}, method={RequestMethod.GET})
    @ResponseBody
    public List<ProjectStandardsScope> getScopes(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            List list = this.projectStandardsService.getScopesUnsafe();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-default-scope-get"})
    @RequestMapping(value={"/publicapi/project-standards/default-scope"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectStandardsScope getDefaultScope(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            ProjectStandardsScope projectStandardsScope = this.projectStandardsService.getDefaultScopeUnsafe();
            return projectStandardsScope;
        }
    }

    @AuditedCall(value={"msgType", "project-standards-run", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/project-standards/actions/run"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<ProjectStandardsRunReport> run(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(required=false) List<String> checkIds, @RequestParam(required=false) String bundleId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        return this.projectStandardsService.run_NT(authCtx, projectKey, checkIds, bundleId, false);
    }

    @AuditedCall(value={"msgType", "project-standards-last-report", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/project-standards/last-report"}, method={RequestMethod.GET})
    @ResponseBody
    public ProjectStandardsRunReport getLastReport(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.projectStandardsService.getLastReport(projectKey);
    }

    @AuditedCall(value={"msgType", "project-standards-get-scope-for-project", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/publicapi/projects/{projectKey}/project-standards/scope"}, method={RequestMethod.GET})
    @ResponseBody
    public String getScopeForProject(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkProjectPrivileges(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        return this.projectStandardsService.getScopeForProject((String)projectKey).name;
    }
}

