/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api;

import com.dataiku.dip.ApplicationConfigurator;
import com.dataiku.dip.DKUApp;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.GeneralSettingsDAO;
import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.directory.NodesDirectoryService;
import com.dataiku.dip.llm.online.LLMCostLimitingCountersRepository;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.security.model.GlobalScopePublicAPIKey;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.api.PublicAPINotebooksController;
import com.dataiku.dip.server.api.auth.PublicAPIKeysService;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.notifications.backend.GeneralSettingsChangedEvent;
import com.dataiku.dip.server.services.BackendTransactionService;
import com.dataiku.dip.server.services.GeneralSettingsService;
import com.dataiku.dip.server.services.GraphiteReportingService;
import com.dataiku.dip.server.services.IJupyterService;
import com.dataiku.dip.server.services.JupyterService;
import com.dataiku.dip.server.services.LogsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.fs.RelFile;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.ApiKeyUtils;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.webapps.WebAppsService;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/publicapi/admin"})
public class PublicApiAdminController
extends PublicAPIControllerBase {
    @Autowired
    private LogsService logsService;
    @Autowired
    private PublicAPIKeysService publicApiKeyService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private GeneralSettingsService generalSettingsService;
    @Autowired
    private IJupyterService jupyterService;
    @Autowired
    private GraphiteReportingService graphiteReportingService;
    @Autowired
    private NodesDirectoryService nodesDirectoryService;
    @Autowired
    private WebAppsService webAppsService;
    @Autowired
    private LLMCostLimitingCountersRepository llmCountersRepository;

    @AuditedCall(value={"msgType", "publicapi-keys-list"})
    @RequestMapping(value={"/global-api-keys", "/globalAPIKeys"}, method={RequestMethod.GET})
    @ResponseBody
    public List<GlobalScopePublicAPIKey> listGlobalKeys(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            List globalScopePublicAPIKeys = this.publicApiKeyService.listGlobalAPIKeys();
            globalScopePublicAPIKeys.forEach(GlobalScopePublicAPIKey::clearManagedKeyField);
            List list = globalScopePublicAPIKeys;
            return list;
        }
    }

    @AuditedCall(value={"msgType", "publicapi-key-get", "key", "${key}"})
    @RequestMapping(value={"/globalAPIKeys/{key:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    @Deprecated
    public GlobalScopePublicAPIKey getGlobalKeyByKey(HttpServletRequest req, @PathVariable String key) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            GlobalScopePublicAPIKey globalAPIKey = this.publicApiKeyService.getGlobalAPIKeyFromKey(key);
            globalAPIKey.clearManagedKeyField();
            GlobalScopePublicAPIKey globalScopePublicAPIKey = globalAPIKey;
            return globalScopePublicAPIKey;
        }
    }

    @AuditedCall(value={"msgType", "publicapi-key-get", "keyId", "${id}"})
    @RequestMapping(value={"/global-api-keys/{id:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public GlobalScopePublicAPIKey getGlobalKeyById(HttpServletRequest req, @PathVariable String id) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            GlobalScopePublicAPIKey globalAPIKey = this.publicApiKeyService.getGlobalAPIKeyById(id);
            globalAPIKey.clearManagedKeyField();
            GlobalScopePublicAPIKey globalScopePublicAPIKey = globalAPIKey;
            return globalScopePublicAPIKey;
        }
    }

    @AuditInline
    @RequestMapping(value={"/global-api-keys", "/globalAPIKeys"}, method={RequestMethod.POST})
    public void createGlobalKey(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="false") boolean forceKey) throws Exception {
        GlobalScopePublicAPIKey gsKey = (GlobalScopePublicAPIKey)this.getRequestBodyAs(req, GlobalScopePublicAPIKey.class);
        if (!forceKey) {
            this.require(gsKey.key == null, "You must not fill the 'key'");
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            gsKey = this.publicApiKeyService.createGlobalAPIKey(gsKey);
            t.commit("Created new global public API key");
            gsKey.clearManagedKeyField();
            PublicApiAdminController.writeJSON((HttpServletResponse)resp, (Object)gsKey);
            this.auditTrailService.generic("publicapi-key-create").with("keyId", gsKey.id).with("isAdmin", gsKey.globalPermissions.isAdmin()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("publicapi-key-create", (Throwable)e).emit();
            throw e;
        }
    }

    private void checkKeyInBody(GlobalScopePublicAPIKey newKey, GlobalScopePublicAPIKey oldKey) {
        if (!ApiKeyUtils.useHashedApiKeys()) {
            this.require(oldKey.key.equals(newKey.key), "Existing 'key' mismatch vs Body");
        }
    }

    @AuditInline
    @RequestMapping(value={"/globalAPIKeys/{key:.+}"}, method={RequestMethod.PUT})
    @Deprecated
    public void updateGlobalKeyByKey(HttpServletRequest req, @PathVariable String key) throws Exception {
        GlobalScopePublicAPIKey gsKey = (GlobalScopePublicAPIKey)this.getRequestBodyAs(req, GlobalScopePublicAPIKey.class);
        this.require(gsKey.key != null, "No 'key' in body");
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            GlobalScopePublicAPIKey globalAPIKey = this.publicApiKeyService.getGlobalAPIKeyByIdWithSecret(gsKey.id);
            this.require(ApiKeyUtils.compareKeySecret((String)key, (String)globalAPIKey.getKey()), "'key' mismatch URI vs Body");
            this.checkKeyInBody(gsKey, globalAPIKey);
            this.publicApiKeyService.updateGlobalAPIKeyByKey(globalAPIKey.getKey(), gsKey);
            t.commit("Updated global public API key");
            this.auditTrailService.generic("publicapi-key-edit").with("keyId", gsKey.id).with("isAdmin", gsKey.globalPermissions.isAdmin()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("publicapi-key-edit", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/global-api-keys/{id:.+}"}, method={RequestMethod.PUT})
    public void updateGlobalKeyById(HttpServletRequest req, @PathVariable String id) throws Exception {
        GlobalScopePublicAPIKey gsKey = (GlobalScopePublicAPIKey)this.getRequestBodyAs(req, GlobalScopePublicAPIKey.class);
        this.require(gsKey.id.equals(id), "'id' mismatch URI vs Body");
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            GlobalScopePublicAPIKey globalAPIKey = this.publicApiKeyService.getGlobalAPIKeyByIdWithSecret(id);
            this.checkKeyInBody(gsKey, globalAPIKey);
            this.publicApiKeyService.updateGlobalAPIKeyById(gsKey);
            t.commit("Updated global public API key");
            this.auditTrailService.generic("publicapi-key-edit").with("keyId", gsKey.id).with("isAdmin", gsKey.globalPermissions.isAdmin()).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("publicapi-key-edit", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/globalAPIKeys/{key:.+}"}, method={RequestMethod.DELETE})
    @Deprecated
    public void deleteGlobalKeyByKey(HttpServletRequest req, @PathVariable String key) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            this.publicApiKeyService.deleteGlobalAPIKeyByKey(key);
            t.commit("Deleted global public API key");
            this.auditTrailService.generic("publicapi-key-delete").with("key", key).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("publicapi-key-delete", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditInline
    @RequestMapping(value={"/global-api-keys/{id:.+}"}, method={RequestMethod.DELETE})
    public void deleteGlobalKeyById(HttpServletRequest req, @PathVariable String id) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            this.publicApiKeyService.deleteGlobalAPIKeyById(id);
            t.commit("Deleted global public API key");
            this.auditTrailService.generic("publicapi-key-delete").with("keyId", id).emit();
        }
        catch (Exception e) {
            this.auditTrailService.failure("publicapi-key-delete", (Throwable)e).emit();
            throw e;
        }
    }

    @AuditedCall(value={"msgType", "publicapi-variables-get"})
    @RequestMapping(value={"/variables"}, method={RequestMethod.GET})
    @ResponseBody
    public JsonObject getGlobalVariables(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            if (t.exists("variables.json")) {
                JsonObject jsonObject = (JsonObject)t.readObjectUnsafe("variables.json", JsonObject.class);
                return jsonObject;
            }
            JsonObject jsonObject = new JsonObject();
            return jsonObject;
        }
    }

    @AuditedCall(value={"msgType", "publicapi-variables-edit"})
    @RequestMapping(value={"/variables"}, method={RequestMethod.PUT})
    public void setGlobalVariables(HttpServletRequest req) throws Exception {
        JsonObject variables = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            t.writeObject("variables.json", (Object)variables);
            t.commit("Saved global variables");
        }
    }

    @AuditedCall(value={"msgType", "publicapi-logs-get"})
    @RequestMapping(value={"/logs"}, method={RequestMethod.GET})
    @ResponseBody
    public List<LogsService.LogDesc> listLogs(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        return this.logsService.listLogs();
    }

    @AuditedCall(value={"msgType", "publicapi-logs-get"})
    @RequestMapping(value={"/logs/**"}, method={RequestMethod.GET})
    @ResponseBody
    public LogsService.LogDesc getLog(HttpServletRequest req) throws Exception {
        String urlPrefix = "/logs/";
        String logName = req.getServletPath();
        logName = logName.substring(logName.indexOf(urlPrefix) + urlPrefix.length());
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        try {
            return this.logsService.getLogContent(logName);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)("Failed to load log file: " + logName), (Throwable)e);
            throw new NotFoundException("Failed to load log file: " + logName);
        }
    }

    @AuditedCall(value={"msgType", "publicapi-general-settings-get"})
    @RequestMapping(value={"/general-settings"}, method={RequestMethod.GET})
    @ResponseBody
    public GeneralSettingsDAO.GeneralSettings getGeneralSettings(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            GeneralSettingsDAO.GeneralSettings generalSettings = this.generalSettingsDAO.getUnsafe();
            return generalSettings;
        }
    }

    @AuditedCall(value={"msgType", "publicapi-general-settings-edit"})
    @RequestMapping(value={"/general-settings"}, method={RequestMethod.PUT})
    public void setGeneralSettings(HttpServletRequest req) throws Exception {
        GeneralSettingsChangedEvent changeEvent;
        AuthCtx authCtx;
        GeneralSettingsDAO.GeneralSettings settings = (GeneralSettingsDAO.GeneralSettings)this.getRequestBodyAs(req, GeneralSettingsDAO.GeneralSettings.class);
        InfoMessage.InfoMessages messages = new InfoMessage.InfoMessages();
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            authCtx = this.authService.getTicketOrKey(req);
            changeEvent = this.generalSettingsService.save(t.getUser(), settings);
            t.commit("Saved general settings");
        }
        t = this.transactionService.beginRead();
        try {
            this.graphiteReportingService.restartReporterIfNeeded();
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
        this.webAppsService.reloadWebAppsIfNecessary(authCtx, changeEvent, messages);
    }

    @AuditedCall(value={"msgType", "publicapi-nodes-directory-edit"})
    @RequestMapping(value={"/nodes-directory"}, method={RequestMethod.PUT})
    public void updateNodesDirectory(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        NodesDirectory directory = (NodesDirectory)this.getRequestBodyAs(req, NodesDirectory.class);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            this.nodesDirectoryService.saveNodesDirectory(directory);
            t.commit("Updated nodes directory");
        }
    }

    @AuditedCall(value={"msgType", "notebooks-list"})
    @RequestMapping(value={"/notebooks"}, method={RequestMethod.GET})
    @ResponseBody
    public List<PublicAPINotebooksController.ActiveNotebook> listNotebooks(HttpServletRequest req) throws Exception {
        List sessions = this.jupyterService.listActiveSessions();
        List kernelSpecs = this.jupyterService.listKernelSpecs();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            ArrayList notebooks = Lists.newArrayList();
            for (JupyterService.JupyterNotebookListEntry notebook : this.jupyterService.listActiveNotebooksUnsafe(sessions, kernelSpecs)) {
                if (notebook.activeSessions.size() <= 0) continue;
                notebooks.add(new PublicAPINotebooksController.ActiveNotebook(notebook));
            }
            ArrayList arrayList = notebooks;
            return arrayList;
        }
    }

    @AuditInline
    @RequestMapping(value={"/audit/custom/{customMsgType:.+}"}, method={RequestMethod.POST, RequestMethod.PUT})
    public void logCustomAudit(HttpServletRequest req, @PathVariable String customMsgType) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            authCtx.failIfNoSafeCode("Append a custom audit trail item");
        }
        JsonObject params = (JsonObject)JSON.parse((InputStream)req.getInputStream(), JsonObject.class);
        this.auditTrailService.generic("custom").with("customMsgType", customMsgType).with("customMsgParams", params).emit();
    }

    @AuditedCall(value={"msgType", "publicapi-invalidate-config-common-files-cache"})
    @RequestMapping(value={"/invalidate-config-common-files-cache"}, method={RequestMethod.POST})
    public void invalidateConfigCommonFilesCache() throws IOException {
        List<RelFile> projectsFiles;
        for (String commonFile : BackendTransactionService.DKU_CONFIG_COMMON_FILES) {
            this.transactionService.invalidateCache(RelFile.fromPath((String)commonFile));
        }
        try (Transaction tr = this.transactionService.beginRead();){
            projectsFiles = ((Stream)tr.listFilesUnordered(RelFile.global((String)"projects")).stream().parallel()).map(rf -> rf.appendChildPath("apikeys.json")).filter(rf -> {
                try {
                    return tr.isFile(rf);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList());
        }
        projectsFiles.forEach(rf -> this.transactionService.invalidateCache(rf));
    }

    @AuditedCall(value={"msgType", "publicapi-invalidate-config-cache", "path", "${path}"})
    @RequestMapping(value={"/invalidate-config-cache"}, method={RequestMethod.POST})
    public void invalidateConfigCache(HttpServletRequest req, @RequestParam String path) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        this.transactionService.invalidateCache(RelFile.fromPath((String)path));
    }

    @AuditedCall(value={"msgType", "publicapi-get-node-type", "path", "${path}"})
    @RequestMapping(value={"/get-node-type"}, method={RequestMethod.GET})
    @ResponseBody
    public String getNodeType(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        ApplicationConfigurator.DSSNodeType nodeType = ApplicationConfigurator.getNodeType();
        if (ApplicationConfigurator.DSSNodeType.AUTOMATION == nodeType && "false".equals(ApplicationConfigurator.getIniValue((String)"modules", (String)"projects"))) {
            return "DEPLOYER";
        }
        return nodeType.name();
    }

    @AuditedCall(value={"msgType", "publicapi-get-node-id"})
    @RequestMapping(value={"/get-node-id"}, method={RequestMethod.GET})
    @ResponseBody
    public String getNodeId(HttpServletRequest req) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        return DKUApp.getNodeId();
    }

    @AuditedCall(value={"msgType", "publicapi-get-govern-node-ref"})
    @RequestMapping(value={"/get-govern-node-ref"}, method={RequestMethod.GET})
    @ResponseBody
    public GeneralSettingsDAO.NodeRef getGovernNodeRef(HttpServletRequest req) throws Exception {
        GeneralSettingsDAO.NodeRef nodeRef;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            nodeRef = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN().governIntegrationSettings.getRef();
        }
        return nodeRef;
    }

    @AuditedCall(value={"msgType", "publicapi-get-llm-cost-limiting-counters"})
    @RequestMapping(value={"/llm-cost-limiting/counters"}, method={RequestMethod.GET})
    @ResponseBody
    public LLMCostLimitingCountersResponse getLLMCostLimitingCounters(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        LLMCostLimitingCountersResponse response = new LLMCostLimitingCountersResponse();
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        response.counters = this.llmCountersRepository.getAggregatedDataFromAvailableQuotas().stream().map(LLMCostLimitingCounter::fromAggregatedData).collect(Collectors.toList());
        return response;
    }

    public static class LLMCostLimitingCountersResponse {
        public List<LLMCostLimitingCounter> counters;
    }

    public static class LLMCostLimitingCounter {
        public String id;
        public String name;
        public double accruedCost = 0.0;
        public int allowedQueries = 0;
        public int blockedQueries = 0;

        public static LLMCostLimitingCounter fromAggregatedData(LLMCostLimitingCountersRepository.AggregatedDataWithDetails data) {
            LLMCostLimitingCounter counter = new LLMCostLimitingCounter();
            counter.id = data.id;
            counter.name = data.name;
            counter.accruedCost = data.accruedCost;
            counter.allowedQueries = data.allowedQueries;
            counter.blockedQueries = data.blockedQueries;
            return counter;
        }
    }
}

