/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.admin;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.exec.CodeBasedRecipeDatasetInfoHelper;
import com.dataiku.dip.datasets.fs.hdfs.HDFSPermissionsSynchronizer;
import com.dataiku.dip.exceptions.ConfValidators;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.connections.ConnectionCodes;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.services.ConnectionsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.utils.JSON;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIConnectionsController
extends PublicAPIControllerBase {
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private ConnectionsService connectionsService;
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private AuditTrailService auditTrailService;

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/publicapi/admin/connections"}, method={RequestMethod.GET})
    public void listConnections(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            Map ret = this.connectionsDAO.listUnsafe();
            PublicAPIConnectionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "connection-get", "connectionName", "${connectionName}"})
    @RequestMapping(value={"/publicapi/admin/connections/{connectionName:.+}"}, method={RequestMethod.GET})
    public void getConnection(HttpServletRequest req, HttpServletResponse resp, @PathVariable String connectionName) throws Exception {
        DSSConnection ret;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            ret = this.connectionsDAO.getMandatoryConnection(authCtx, connectionName);
        }
        PublicAPIConnectionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/connections"}, method={RequestMethod.POST})
    public void addConnection(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        JsonObject connectionObj = (JsonObject)this.getRequestBodyAs(req, JsonObject.class);
        ConfValidators.checkNotJsonNull((JsonElement)connectionObj.get("name"), (InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_API_BAD_CONFIG, (String)"'name'");
        ConfValidators.checkNotJsonNull((JsonElement)connectionObj.get("type"), (InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_API_BAD_CONFIG, (String)"'type'");
        ConfValidators.checkNotJsonNull((JsonElement)connectionObj.get("params"), (InfoMessage.MessageCode)ConnectionCodes.ERR_CONNECTION_API_BAD_CONFIG, (String)"'params'");
        PublicAPIConnectionsController.enforceBigQueryPartitionConsistencyIfNull(connectionObj);
        DSSConnection connection = (DSSConnection)JSON.parse((String)JSON.json((Object)connectionObj), DSSConnection.class);
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            if (this.connectionsDAO.getConnection(t.getUser(), connection.name) != null) {
                throw new DKUControllerBase.MalformedRequestException("Connection " + connection.name + " already exists.");
            }
            this.connectionsService.save(t.getUser(), connection, true);
            t.commit("Created connection " + connection.name);
        }
        this.auditTrailService.generic("connection-create").with("connectionName", connection.name).with("type", connection.getType()).emit();
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Created connection " + connection.name);
        PublicAPIConnectionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    private static void enforceBigQueryPartitionConsistencyIfNull(JsonObject connectionObj) {
        try {
            JsonObject params = connectionObj.get("params").getAsJsonObject();
            if (Objects.equals(connectionObj.get("type").getAsString(), "BigQuery") && !params.has("forbidPartitionsWriteToNonPartitionedTable")) {
                params.addProperty("forbidPartitionsWriteToNonPartitionedTable", Boolean.valueOf(true));
            }
        }
        catch (Exception e) {
            logger.info((Object)"Failed to enforce BigQuery Partition Consistency");
        }
    }

    @AuditedCall(value={"msgType", "connection-save", "connectionName", "${connectionName}"})
    @RequestMapping(value={"/publicapi/admin/connections/{connectionName:.+}"}, method={RequestMethod.PUT})
    public void updateConnection(HttpServletRequest req, HttpServletResponse resp, @PathVariable String connectionName) throws Exception {
        DSSConnection connection = (DSSConnection)this.getRequestBodyAs(req, DSSConnection.class);
        if (!StringUtils.equals((String)connectionName, (String)connection.name)) {
            throw new DKUControllerBase.MalformedRequestException("Connection name does not match requested URL");
        }
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            this.connectionsDAO.getMandatoryConnection(t.getUser(), connection.name);
            this.connectionsService.save(t.getUser(), connection, false);
            t.commit("Updated connection " + connection.name);
        }
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Updated connection " + connection.name);
        PublicAPIConnectionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "connection-delete", "connectionName", "${connectionName}"})
    @RequestMapping(value={"/publicapi/admin/connections/{connectionName:.+}"}, method={RequestMethod.DELETE})
    public void deleteConnection(HttpServletRequest req, HttpServletResponse resp, @PathVariable String connectionName) throws Exception {
        try (RWTransaction t = this.transactionService.beginWriteForAPI(req);){
            this.permissionsService.checkAdmin(t.getUser());
            if (this.connectionsDAO.getConnection(t.getUser(), connectionName) == null) {
                throw new DKUControllerBase.MalformedRequestException("Connection " + connectionName + " does not exist");
            }
            this.connectionsService.delete(connectionName, t.getUser());
            t.commit("Deleted connection " + connectionName);
        }
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Deleted connection " + connectionName);
        PublicAPIConnectionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "connection-sync-acls", "connectionName", "${connectionName}", "root", "${root}"})
    @RequestMapping(value={"/publicapi/admin/connections/{connectionName}/sync"}, method={RequestMethod.POST})
    public void syncAcls(HttpServletRequest req, HttpServletResponse resp, @PathVariable String connectionName, @RequestParam(required=false, defaultValue="false") boolean root) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            if (this.connectionsDAO.getConnection(authCtx, connectionName) == null) {
                throw new DKUControllerBase.MalformedRequestException("Connection " + connectionName + " does not exist");
            }
            HDFSPermissionsSynchronizer sync = new HDFSPermissionsSynchronizer();
            if (root) {
                PublicAPIConnectionsController.writeJSON((HttpServletResponse)resp, (Object)sync.startSetPermissionsOnConnectionRoot(authCtx, connectionName));
            } else {
                PublicAPIConnectionsController.writeJSON((HttpServletResponse)resp, (Object)sync.startSetPermissionsOnConnectionDatasets(authCtx, connectionName));
            }
        }
    }

    @AuditedCall(value={"msgType", "connection-get-info", "connectionName", "${connectionName}"})
    @RequestMapping(value={"/publicapi/connections/{connectionName:.+}/info"}, method={RequestMethod.GET})
    @ResponseBody
    public CodeBasedRecipeDatasetInfoHelper.ConnectionLocationInfo getConnectionInfo(HttpServletRequest req, @PathVariable String connectionName, @RequestParam(required=false) String contextualProjectKey) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
        }
        return new CodeBasedRecipeDatasetInfoHelper().getConnectionInfo_NT(authCtx, connectionName, contextualProjectKey);
    }

    @AuditedCall(value={"msgType", "connections-list"})
    @RequestMapping(value={"/publicapi/connections/get-names"}, method={RequestMethod.GET})
    public void listNames(HttpServletRequest req, HttpServletResponse resp, String type, @RequestParam(defaultValue="false", required=false) boolean checkAllowManagedFolders) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            List ret = this.connectionsDAO.getConnectionNames(type, authCtx, checkAllowManagedFolders);
            PublicAPIConnectionsController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }
}

