/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.admin;

import com.dataiku.common.server.DKUControllerBase;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dao.UserLastActivity;
import com.dataiku.dip.dao.UsersDAO;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.futures.FuturePayload;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.futures.FutureThreadBase;
import com.dataiku.dip.futures.SimpleFutureThread;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.SecurityAuditService;
import com.dataiku.dip.security.audit.AuditTrailService;
import com.dataiku.dip.security.auth.ExternalUser;
import com.dataiku.dip.security.auth.GroupDiff;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.security.auth.ServerAuthenticationFailure;
import com.dataiku.dip.security.auth.UserAttributes;
import com.dataiku.dip.security.auth.UserAuthenticationService;
import com.dataiku.dip.security.auth.UserDiff;
import com.dataiku.dip.security.auth.UserQueryFilter;
import com.dataiku.dip.security.auth.UserSourceType;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditInline;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.WebSocketController;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.server.services.UsersService;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class PublicAPIUsersController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private AuditTrailService auditTrailService;
    @Autowired
    private SecurityAuditService auditService;
    @Autowired
    private UserAuthenticationService userAuthenticationService;
    @Autowired
    private FutureService futureService;

    @AuditedCall(value={"msgType", "security-admin-users-list"})
    @RequestMapping(value={"/publicapi/admin/users"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UsersService.APIUser> listUsers(HttpServletRequest req, @RequestParam(defaultValue="false") boolean connected) throws Exception {
        List allUsers;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            allUsers = this.usersService.listUsers_RestrictionCheck_NoLeak(authCtx, null, true, true);
        }
        Collection lius = WebSocketController.getInstance().getCurrentlyLoggedInUsers(false);
        ArrayList<UsersService.APIUser> users = new ArrayList<UsersService.APIUser>();
        for (UsersService.UIUser user : allUsers) {
            UsersService.APIUser eud = new UsersService.APIUser(user);
            for (AuthCtx liu : lius) {
                if (!liu.getIdentifier().equals(user.login)) continue;
                ++eud.activeWebSocketSesssions;
            }
            if (connected && eud.activeWebSocketSesssions <= 0) continue;
            users.add(eud);
        }
        return users;
    }

    @AuditedCall(value={"msgType", "security-admin-users-list-activity"})
    @RequestMapping(value={"/publicapi/admin/users-activity"}, method={RequestMethod.GET})
    public void listUsersActivity(HttpServletRequest req, HttpServletResponse resp, @RequestParam(defaultValue="false") boolean enabledUsersOnly) throws Exception {
        List uiUsers;
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            uiUsers = enabledUsersOnly ? this.usersService.listUsersEnabledOnly_RestrictionCheck_NoLeak(authCtx) : this.usersService.listUsersWithDisabled_RestrictionCheck_NoLeak(authCtx);
        }
        Set<String> logins = uiUsers.stream().map(uiUser -> uiUser.login).collect(Collectors.toSet());
        Map usersActivity = this.usersService.getAllUsersActivity(false);
        logins.forEach(login -> {
            if (!usersActivity.containsKey(login)) {
                usersActivity.put(login, new UserLastActivity(login));
            }
        });
        List filteredActivity = usersActivity.entrySet().stream().filter(entry -> logins.contains(entry.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, filteredActivity);
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/users"}, method={RequestMethod.POST})
    public void addUser(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        UsersService.UIUser user = (UsersService.UIUser)this.getRequestBodyAs(req, UsersService.UIUser.class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (Transaction t = this.transactionService.beginRead();){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
        }
        this.usersService.addUserAdmin_NT(user, authCtx);
        this.auditTrailService.generic("security-admin-user-create").with("login", user.login).emit();
        resp.setStatus(201);
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Created user " + user.login);
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "security-admin-user-get", "login", "${login}"})
    @RequestMapping(value={"/publicapi/admin/users/{login:.+}"}, method={RequestMethod.GET})
    public void getUser(HttpServletRequest req, HttpServletResponse resp, @PathVariable String login) throws Exception {
        UsersService.APIUser user;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            user = this.usersService.getUserForAPI_NoCheck_WithSensitive(authCtx, login, true);
        }
        for (AuthCtx liu : WebSocketController.getInstance().getCurrentlyLoggedInUsers(false)) {
            String log = liu.getIdentifier();
            if (!log.equals(login)) continue;
            ++user.activeWebSocketSesssions;
        }
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)user);
    }

    @AuditedCall(value={"msgType", "security-admin-user-exists", "login", "${login}"})
    @RequestMapping(value={"/publicapi/admin/user-exists/{login:.+}"}, method={RequestMethod.GET})
    public void userExists(HttpServletRequest req, HttpServletResponse resp, @PathVariable String login) throws Exception {
        UsersDAO.User user;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            user = this.usersService.getInternalUserOrNullUnsafe(login);
        }
        UserAuthenticationService.UserAuthInfo userAuthInfo = new UserAuthenticationService.UserAuthInfo();
        if (user != null) {
            userAuthInfo.exists = true;
            if (user.enabled) {
                userAuthInfo.enabled = true;
            }
        }
        userAuthInfo.provisioningAtLogin = !this.userAuthenticationService.getSuppliersForProvisioningAtLoginTime().isEmpty();
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)userAuthInfo);
    }

    @AuditedCall(value={"msgType", "security-admin-user-edit", "login", "${login}"})
    @RequestMapping(value={"/publicapi/admin/users/{login:.+}"}, method={RequestMethod.PUT})
    public void adminEditUser(HttpServletRequest req, HttpServletResponse resp, @PathVariable String login) throws Exception {
        UsersService.APIUser user = (UsersService.APIUser)this.getRequestBodyAs(req, UsersService.APIUser.class);
        if (!StringUtils.equals((String)login, (String)user.login)) {
            throw new DKUControllerBase.MalformedRequestException("User login does not match requested URL");
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            this.usersService.getUser_NoLeak(login);
            UserDiff userDiff = this.usersService.editUserFromAPI_NoCheck(user, authCtx);
            this.auditTrailService.generic("security-admin-user-start-trial").with("login", user.login).withAll(userDiff.getDiff()).emit();
            t.commit("Edited user " + user.login);
        }
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Edited user " + login);
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "security-admin-user-delete", "login", "${login}"})
    @RequestMapping(value={"/publicapi/admin/users/{login:.+}"}, method={RequestMethod.DELETE})
    public void adminDeleteUser(HttpServletRequest req, HttpServletResponse resp, @PathVariable String login) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            this.usersService.getUser_NoLeak(login);
            this.usersService.deleteUserAdmin(login);
            t.commit("Deleted user " + login);
        }
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Deleted user " + login);
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "security-admin-user-activity", "login", "${login}"})
    @RequestMapping(value={"/publicapi/admin/users/{login}/activity"}, method={RequestMethod.GET})
    public void getUserActivity(HttpServletRequest req, HttpServletResponse resp, @PathVariable String login) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)this.usersService.getUserLastActivity(login));
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/users/{login:.+}/actions/resync"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> resyncUser(HttpServletRequest req, final @PathVariable String login) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
        }
        return this.futureService.runFuture((FutureThreadBase)new SimpleFutureThread<InfoMessage.InfoMessages>(authCtx){

            protected InfoMessage.InfoMessages compute() throws Exception {
                return PublicAPIUsersController.this.userAuthenticationService.explicitOnDemandSync(Collections.singletonList(login));
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"syncUsers", (String)"Sync users from external sources");
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/users/actions/resync-multi"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> resyncUsers(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
        }
        final List logins = (List)this.getRequestBodyAsOrNull(req, (TypeToken)new TypeToken<List<String>>(){});
        return this.futureService.runFuture((FutureThreadBase)new SimpleFutureThread<InfoMessage.InfoMessages>(authCtx){

            protected InfoMessage.InfoMessages compute() throws Exception {
                return PublicAPIUsersController.this.userAuthenticationService.explicitOnDemandSync(logins);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"syncUsers", (String)"Sync users from external sources");
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    @AuditedCall(value={"msgType", "security-admin-external-users-get", "userSourceType", "${userSourceType}"})
    @RequestMapping(method={RequestMethod.GET}, value={"/publicapi/admin/external-users"})
    @ResponseBody
    public FutureResponse<Set<ExternalUser>> fetchUsers(HttpServletRequest req, final @RequestParam UserSourceType userSourceType, final @RequestParam(required=false) String login, final @RequestParam(required=false) String email, final @RequestParam(required=false) String groupName) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        return this.futureService.runFuture((FutureThreadBase)new SimpleFutureThread<Set<ExternalUser>>(authCtx){

            protected Set<ExternalUser> compute() throws ServerAuthenticationFailure {
                return PublicAPIUsersController.this.userAuthenticationService.fetchUsers((UserSourceType)userSourceType, (UserQueryFilter)new UserQueryFilter((String)groupName, (String)login, (String)email)).users;
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"fetchUsers", (String)"Fetch users from external sources");
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<Set<ExternalUser>>>(){});
    }

    @AuditedCall(value={"msgType", "security-admin-external-groups-get", "userSourceType", "${userSourceType}"})
    @RequestMapping(method={RequestMethod.GET}, value={"/publicapi/admin/external-groups"})
    @ResponseBody
    public FutureResponse<List<String>> fetchGroups(HttpServletRequest req, final @RequestParam UserSourceType userSourceType) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
        }
        return this.futureService.runFuture((FutureThreadBase)new SimpleFutureThread<List<String>>(authCtx){

            protected List<String> compute() throws ServerAuthenticationFailure {
                return PublicAPIUsersController.this.userAuthenticationService.fetchGroups(userSourceType);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"fetchGroups", (String)"Fetch groups from external sources");
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<List<String>>>(){});
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/users/actions/provision"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> provisionUsers(HttpServletRequest req) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
        }
        final ProvisionUsersRequest request = (ProvisionUsersRequest)this.getRequestBodyAs(req, ProvisionUsersRequest.class);
        return this.futureService.runFuture((FutureThreadBase)new SimpleFutureThread<InfoMessage.InfoMessages>(authCtx){

            protected InfoMessage.InfoMessages compute() throws InterruptedException {
                return PublicAPIUsersController.this.userAuthenticationService.provisionUsers(request.userSourceType, request.users);
            }

            public FuturePayload getPayload() {
                return FuturePayload.newSimple((String)"provisionUsers", (String)"Provision users");
            }
        }, 0L, (TypeToken)new TypeToken<FutureResponse<InfoMessage.InfoMessages>>(){});
    }

    @AuditedCall(value={"msgType", "security-admin-groups-list"})
    @RequestMapping(value={"/publicapi/admin/groups"}, method={RequestMethod.GET})
    public void listGroups(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            List ret = this.usersService.listGroupsFull();
            PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditedCall(value={"msgType", "security-admin-group-get", "groupName", "${groupName}"})
    @RequestMapping(value={"/publicapi/admin/groups/{groupName:.+}"}, method={RequestMethod.GET})
    public void getGroup(HttpServletRequest req, HttpServletResponse resp, @PathVariable String groupName) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            UsersDAO.Group ret = this.usersService.getGroupMandatory(groupName);
            PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
        }
    }

    @AuditInline
    @RequestMapping(value={"/publicapi/admin/groups"}, method={RequestMethod.POST})
    public void addGroup(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        UsersDAO.Group group = (UsersDAO.Group)this.getRequestBodyAs(req, UsersDAO.Group.class);
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            if (this.usersService.getGroup(group.name) != null) {
                throw new DKUControllerBase.MalformedRequestException("Group " + group.name + " already exists. To edit a group, use PUT /groups/{groupName}");
            }
            this.usersService.addGroup(group);
            t.commit("Created group " + group.name);
            this.auditTrailService.generic("group-created").with("groupName", group.name).with("isAdmin", "" + group.isAdmin()).emit();
        }
        resp.setStatus(201);
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Created group " + group.name);
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "security-admin-group-edit", "groupName", "${groupName}"})
    @RequestMapping(value={"/publicapi/admin/groups/{groupName:.+}"}, method={RequestMethod.PUT})
    public void editGroup(HttpServletRequest req, HttpServletResponse resp, @PathVariable String groupName) throws Exception {
        GroupDiff groupDiff;
        UsersDAO.Group group = (UsersDAO.Group)this.getRequestBodyAs(req, UsersDAO.Group.class);
        if (!StringUtils.equals((String)groupName, (String)group.name)) {
            throw new DKUControllerBase.MalformedRequestException("Group name does not match requested URL");
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            this.usersService.getGroupMandatory(group.name);
            groupDiff = this.usersService.updateGroup(group);
            t.commit("Modified group " + group.name);
        }
        this.auditTrailService.generic("security-admin-group-edit").with("group", group.name).withAll(groupDiff.getDiff()).emit();
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Modified group " + group.name);
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "security-admin-group-delete", "groupName", "${groupName}"})
    @RequestMapping(value={"/publicapi/admin/groups/{groupName:.+}"}, method={RequestMethod.DELETE})
    public void deleteGroup(HttpServletRequest req, HttpServletResponse resp, @PathVariable String groupName) throws Exception {
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            this.permissionsService.checkAdmin(authCtx);
            this.permissionsService.checkAdditionalCloudDataikerAdminPermission(authCtx);
            this.usersService.getGroupMandatory(groupName);
            this.usersService.deleteGroup(null, groupName);
            t.commit("Deleted group " + groupName);
        }
        PublicAPIControllerBase.ResponseMessage ret = new PublicAPIControllerBase.ResponseMessage("Deleted group " + groupName);
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)ret);
    }

    @AuditedCall(value={"msgType", "security-own-user-get"})
    @RequestMapping(value={"/publicapi/current-user"}, method={RequestMethod.GET})
    public void getOwnUser(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        UsersService.APIUser user;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            if (authCtx.getAssociatedDSSUser() == null) {
                throw new UnauthorizedException("This authentication does not have an associated user", "no-associated-user");
            }
            user = this.usersService.getUserForAPI_NoCheck_WithUserSensitive(authCtx.getAssociatedDSSUserMand());
        }
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)user);
    }

    @AuditedCall(value={"msgType", "security-own-user-edit"})
    @RequestMapping(value={"/publicapi/current-user"}, method={RequestMethod.PUT})
    public void saveOwnUser(HttpServletRequest req, HttpServletResponse res) throws Exception {
        AuthCtx authCtx;
        UsersService.APIUser user = (UsersService.APIUser)this.getRequestBodyAs(req, UsersService.APIUser.class);
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            if (authCtx.getAssociatedDSSUser() == null) {
                throw new UnauthorizedException("This authentication does not have an associated user", "no-associated-user");
            }
        }
        if (!authCtx.getAssociatedDSSUserMand().equals(user.login)) {
            throw new UnauthorizedException("Illegal user modification, cannot modify own login", "access-denied");
        }
        t = this.transactionService.beginWriteAsLoggedInUser(authCtx);
        try {
            this.usersService.getUser_NoLeak(user.login);
            UserDiff userDiff = this.usersService.editUserFromAPI_AllowedFieldsOnly(user, authCtx);
            this.auditTrailService.generic("security-admin-user-start-trial").with("login", user.login).withAll(userDiff.getDiff()).emit();
            t.commit("Edited user " + user.login + " (self-edit)");
        }
        finally {
            if (t != null) {
                t.close();
            }
        }
    }

    @AuditedCall(value={"msgType", "security-get-authorization-matrix"})
    @RequestMapping(value={"/publicapi/admin/authorization-matrix"}, method={RequestMethod.GET})
    public void getAuthorizationMatrix(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction ignored = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            PublicAPIUsersController.writeJSON((HttpServletResponse)resp, (Object)this.auditService.getAuthorizationMatrix());
        }
    }

    @AuditedCall(value={"msgType", "security-users-list"})
    @RequestMapping(value={"/publicapi/users"}, method={RequestMethod.GET})
    @ResponseBody
    public List<MinimalUserDTO> listUsersNonAdmin(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            List uiUsers = this.usersService.listUsersEnabledOnly_RestrictionCheck_NoLeak(authCtx);
            List<MinimalUserDTO> list = uiUsers.stream().map(MinimalUserDTO::new).toList();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "security-user-get-info", "login", "${login}"})
    @RequestMapping(value={"/publicapi/users/{login:.+}"}, method={RequestMethod.GET})
    @ResponseBody
    public MinimalUserDTO getUserInfoNonAdmin(HttpServletRequest req, HttpServletResponse resp, @PathVariable String login) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            UsersService.UIUser uiUser = this.usersService.getUserForUI_RestrictionCheck_UserSensitive(authCtx, login, false);
            MinimalUserDTO minimalUserDTO = new MinimalUserDTO(uiUser);
            return minimalUserDTO;
        }
    }

    @AuditedCall(value={"msgType", "security-groups-list"})
    @RequestMapping(value={"/publicapi/groups"}, method={RequestMethod.GET})
    @ResponseBody
    public List<MinimalGroupDTO> listGroupsNonAdmin(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            List groupNames = this.usersService.listGroupNames(authCtx, false);
            List<MinimalGroupDTO> list = groupNames.stream().map(MinimalGroupDTO::new).toList();
            return list;
        }
    }

    @AuditedCall(value={"msgType", "security-admin-list-trial-expired-users"})
    @RequestMapping(value={"/publicapi/admin/list-trial-expired-users"}, method={RequestMethod.GET})
    public void listTrialExpiredUsers(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        List expiredTrialUsers;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.permissionsService.checkAdmin(authCtx);
            expiredTrialUsers = this.usersService.listExpiredTrialUsers(authCtx);
        }
        ArrayList<UsersService.APIUser> users = new ArrayList<UsersService.APIUser>();
        for (UsersService.UIUser user : expiredTrialUsers) {
            UsersService.APIUser eud = new UsersService.APIUser(user);
            users.add(eud);
        }
        PublicAPIUsersController.writeJSON((HttpServletResponse)resp, users);
    }

    private static class ProvisionUsersRequest {
        UserSourceType userSourceType;
        Set<UserAttributes> users;

        private ProvisionUsersRequest() {
        }
    }

    public static class MinimalUserDTO {
        public String login;
        public String displayName;
        public List<String> groups;
        public String email;
        public Boolean enabled;

        public MinimalUserDTO(UsersService.UIUser uiUser) {
            this.login = uiUser.login;
            this.displayName = uiUser.displayName;
            this.groups = uiUser.groups;
            this.email = uiUser.email;
            this.enabled = uiUser.enabled;
        }
    }

    public static class MinimalGroupDTO {
        public String name;

        public MinimalGroupDTO(String groupName) {
            this.name = groupName;
        }
    }
}

