/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.datasets;

import com.dataiku.dip.ApplicativeException;
import com.dataiku.dip.aiexplanations.dataset.AIDatasetExplanationService;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.ObjectCompleteMetadata;
import com.dataiku.dip.coremodel.Schema;
import com.dataiku.dip.coremodel.SchemaColumn;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.futures.FutureService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.IPermissionsService;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.datasets.DatasetAccessService;
import com.dataiku.dip.server.datasets.DatasetDescriptionsService;
import com.dataiku.dip.server.datasets.DatasetSaveService;
import com.dataiku.dip.server.datasets.SQLCommentService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.TransactionContext;
import com.dataiku.dip.transactions.ifaces.RWTransaction;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.DatasetLocUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/datasets"})
public class PublicAPIDatasetsMetadataController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private IPermissionsService permissionsService;
    @Autowired
    private DatasetAccessService datasetAccessService;
    @Autowired
    private DatasetSaveService saveService;
    @Autowired
    protected TransactionService transactionService;
    @Autowired
    private SQLCommentService sqlCommentService;
    @Autowired
    private AIDatasetExplanationService aiDatasetExplanationService;
    @Autowired
    private FutureService futureService;
    @Autowired
    private DatasetDescriptionsService datasetDescriptionsService;
    static DKULogger logger = DKULogger.getLogger((String)"dip.api.datasets");

    @AuditedCall(value={"msgType", "dataset-read-meta", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/metadata"}, method={RequestMethod.GET})
    public void getMetadata(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart((String)projectKey, (String)datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_METADATA});
            dataset = this.datasetAccessService.getMandatoryUnsafe(projectKey, datasetName);
        }
        ObjectCompleteMetadata ocm = new ObjectCompleteMetadata();
        ocm.checklists = dataset.getModel().checklists;
        ocm.description = dataset.getDescription();
        ocm.tags = Sets.newHashSet((Iterable)dataset.getModel().tags);
        ocm.custom = dataset.getModel().customMeta;
        PublicAPIDatasetsMetadataController.writeJSON((HttpServletResponse)resp, (Object)ocm);
    }

    @AuditedCall(value={"msgType", "dataset-save-meta", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/metadata"}, method={RequestMethod.PUT})
    public void putMetadata(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        Dataset dataset;
        ObjectCompleteMetadata ocm = (ObjectCompleteMetadata)this.getRequestBodyAs(req, ObjectCompleteMetadata.class);
        this.require(ocm.checklists != null, "checklists are missing");
        this.require(ocm.tags != null, "tags are missing");
        this.require(ocm.custom != null, "custom metadata are missing");
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        String oldDescription = null;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart((String)projectKey, (String)datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_METADATA});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            dataset.getModel().checklists = ocm.checklists;
            oldDescription = dataset.getModel().description;
            dataset.getModel().description = ocm.description;
            dataset.getModel().tags = Lists.newArrayList((Iterable)ocm.tags);
            dataset.getModel().customMeta = ocm.custom;
            this.saveService.save(projectKey, datasetName, dataset.serialize(), t.getUser());
            t.commit("Updated metadata for " + dataset.getFullName());
        }
        if (!Objects.equals(ocm.description, oldDescription)) {
            this.sqlCommentService.addCommentToTable(dataset.serialize(), ocm.description, authCtx);
        }
        this.writeMessage(resp, "updated metadata for " + dataset.getFullName(), new Object[0]);
    }

    @AuditedCall(value={"msgType", "dataset-read-schema", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/schema"}, method={RequestMethod.GET})
    public void getSchema(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        Dataset dataset;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart((String)projectKey, (String)datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_SCHEMA});
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        PublicAPIDatasetsMetadataController.writeJSON((HttpServletResponse)resp, (Object)dataset.getSchema());
    }

    @AuditedCall(value={"msgType", "dataset-save-schema", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/schema"}, method={RequestMethod.PUT})
    public void setSchema(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName) throws Exception {
        Schema schema = (Schema)this.getRequestBodyAs(req, Schema.class);
        this.require(schema.getColumns() != null, "The columns[] array is mandatory");
        for (SchemaColumn col : schema.getColumns()) {
            this.require(col.getName() != null, "column name is missing");
            this.require(col.getType() != null, "column type is missing or invalid");
        }
        AuthCtx authCtx = this.authService.getTicketOrKey_NT(req);
        InfoMessage.InfoMessages messages = null;
        try (RWTransaction t = this.transactionService.beginWriteAsLoggedInUser(authCtx);){
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart((String)projectKey, (String)datasetName);
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.WRITE_SCHEMA});
            Dataset dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
            messages = dataset.fixupSchemaPerDatasetConstraint(authCtx, schema);
            schema.userModified = true;
            dataset.setSchema(schema);
            AuthCtx u = TransactionContext.retrieveWrite().getUser();
            this.saveService.save(projectKey, datasetName, dataset.serialize(), u);
            t.commit("Saved dataset schema for '" + dataset.getFullName());
        }
        PublicAPIDatasetsMetadataController.writeJSON((HttpServletResponse)resp, (Object)messages);
    }

    @AuditedCall(value={"msgType", "generate-ai-description", "projectKey", "${projectKey}", "datasetName", "${datasetName}"})
    @RequestMapping(value={"/{datasetName}/generate-ai-description"}, method={RequestMethod.POST})
    public void generateAiDescription(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String datasetName, @RequestParam(defaultValue="english") String language, @RequestParam(defaultValue="false") boolean saveDescription) throws Exception {
        Dataset dataset;
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            DatasetLocUtils.DatasetLoc loc = DatasetLocUtils.resolveSmart((String)projectKey, (String)datasetName);
            boolean isLocal = loc.getProjectKey().equals(projectKey);
            if (!isLocal) {
                throw new IllegalStateException("Generate Dataset Metadata not available for foreign datasets");
            }
            Privileges.DatasetLevelPrivilegeType[] requiredPrivileges = saveDescription ? new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.WRITE_METADATA, Privileges.DatasetLevelPrivilegeType.WRITE_SCHEMA} : new Privileges.DatasetLevelPrivilegeType[]{Privileges.DatasetLevelPrivilegeType.READ_METADATA, Privileges.DatasetLevelPrivilegeType.READ_SCHEMA};
            this.permissionsService.checkDatasetPrivileges(authCtx, loc, requiredPrivileges);
            dataset = this.datasetAccessService.getMandatory(projectKey, datasetName);
        }
        JsonObject explanationOptions = new JsonObject();
        explanationOptions.addProperty("language", language);
        FutureResponse fr = this.aiDatasetExplanationService.startExplainingDataset(authCtx, dataset, explanationOptions.toString());
        fr = this.futureService.waitForFinalResponse(fr);
        if (!((AIDatasetExplanationService.ExplainDatasetFrontendResponse)fr.result).ok) {
            throw new ApplicativeException("Exception while generating dataset metadata", ((AIDatasetExplanationService.ExplainDatasetFrontendResponse)fr.result).reason);
        }
        String aiShortDesc = ((AIDatasetExplanationService.ExplainDatasetFrontendResponse)fr.result).shortDesc;
        String aiLongDesc = ((AIDatasetExplanationService.ExplainDatasetFrontendResponse)fr.result).longDesc;
        JsonElement aiColDesc = ((AIDatasetExplanationService.ExplainDatasetFrontendResponse)fr.result).colDesc;
        Map serializedColDesc = (Map)JSON.parse((JsonElement)aiColDesc, (TypeToken)new TypeToken<Map<String, String>>(){});
        if (saveDescription) {
            this.datasetDescriptionsService.setDatasetDescriptionsAndColumnDescriptions(authCtx, projectKey, datasetName, aiShortDesc, aiLongDesc, serializedColDesc);
        }
        HashMap<String, String> descriptions = new HashMap<String, String>();
        descriptions.put("description", aiLongDesc);
        descriptions.put("shortDesc", aiShortDesc);
        descriptions.put("schema", (String)aiColDesc);
        PublicAPIDatasetsMetadataController.writeJSON((HttpServletResponse)resp, descriptions);
    }
}

