/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.api.projects;

import com.dataiku.dip.analysis.docgen.helpers.MDGFileUtil;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.dataflow.FlowGraph;
import com.dataiku.dip.dataflow.FlowGraphService;
import com.dataiku.dip.dataflow.ProjectFlowGraph;
import com.dataiku.dip.dataflow.graph.FlowDataset;
import com.dataiku.dip.dataflow.graph.FlowImplicitRecipe;
import com.dataiku.dip.dataflow.graph.FlowLabelingTask;
import com.dataiku.dip.dataflow.graph.FlowRecipe;
import com.dataiku.dip.dataflow.graph.FlowRetrievableKnowledge;
import com.dataiku.dip.dataflow.graph.GraphNode;
import com.dataiku.dip.dataflow.graphtools.AbstractFlowTool;
import com.dataiku.dip.dataflow.graphtools.AutoSchemaPropagation;
import com.dataiku.dip.dataflow.graphtools.PropagateSchemaTool;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.graphicsexport.FlowDocumentGenerationService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.Privileges;
import com.dataiku.dip.security.auth.MetaAuthService;
import com.dataiku.dip.server.api.PublicAPIControllerBase;
import com.dataiku.dip.server.controllers.AuditedCall;
import com.dataiku.dip.server.controllers.NotFoundException;
import com.dataiku.dip.server.services.FlowToolsService;
import com.dataiku.dip.server.services.ITaggingService;
import com.dataiku.dip.server.services.ProjectsService;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.util.AnyLoc;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/publicapi/projects/{projectKey}/flow/"})
public class PublicAPIFlowController
extends PublicAPIControllerBase {
    @Autowired
    private MetaAuthService authService;
    @Autowired
    private ProjectsService projectsService;
    @Autowired
    private TransactionService transactionService;
    @Autowired
    private FlowToolsService flowToolsService;
    @Autowired
    private FlowGraphService flowGraphService;
    @Autowired
    private FlowDocumentGenerationService flowDocumentGenerationService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.api.projects.flow");

    @AuditedCall(value={"msgType", "project-flow-tool-start"})
    @RequestMapping(value={"/tools/"}, method={RequestMethod.POST})
    @ResponseBody
    public String startTool(HttpServletRequest req, @PathVariable String projectKey, @RequestParam String type, @RequestBody JsonObject obj) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        AbstractFlowTool.UserSessionsInProject ret = this.flowToolsService.startTool(authCtx, projectKey, type, obj);
        return ret.currentId;
    }

    @AuditedCall(value={"msgType", "project-flow-tool-update"})
    @RequestMapping(value={"/tools/{toolId}/update"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<AbstractFlowTool.FlowState> updateTool(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String toolId, @RequestBody JsonObject options) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        AbstractFlowTool.FlowTool th = (AbstractFlowTool.FlowTool)AbstractFlowTool.FlowTool.class.cast(this.flowToolsService.getHandler(authCtx, projectKey, toolId));
        return th.getUpdateFuture(authCtx, options);
    }

    @AuditedCall(value={"msgType", "project-flow-tool-get"})
    @RequestMapping(value={"/tools/{toolId}/state"}, method={RequestMethod.GET})
    @ResponseBody
    public AbstractFlowTool.FlowState getToolState(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String toolId, @RequestBody JsonObject options) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        AbstractFlowTool th = this.flowToolsService.getHandler(authCtx, projectKey, toolId);
        return th.getFlowState(options);
    }

    @AuditedCall(value={"msgType", "project-flow-tool-stop"})
    @RequestMapping(value={"/tools/{toolId}/stop"}, method={RequestMethod.POST})
    @ResponseBody
    public String stopTool(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String toolId) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        this.flowToolsService.stopTool(authCtx, projectKey, toolId);
        return "stopped";
    }

    @AuditedCall(value={"msgType", "project-flow-tool-action"})
    @RequestMapping(value={"/tools/{toolId}/action"}, method={RequestMethod.PUT})
    @ResponseBody
    public AbstractFlowTool.FlowState doAction(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String toolId, @RequestBody JsonObject actionObj) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        AbstractFlowTool th = this.flowToolsService.getHandler(authCtx, projectKey, toolId);
        if (th instanceof PropagateSchemaTool) {
            PropagateSchemaTool tool = (PropagateSchemaTool)th;
            PropagateSchemaToolAction action = (PropagateSchemaToolAction)JSON.parse((JsonElement)actionObj, PropagateSchemaToolAction.class);
            if (action.type == null) {
                throw new IllegalArgumentException("Propagate schema action type not specified");
            }
            switch (action.type) {
                case MARK_DATASET_AS_REBUILT: {
                    tool.markDatasetAsBeingRebuilt(action.name);
                    break;
                }
                case MARK_RECIPE_AS_OK: {
                    if (action.updated) {
                        tool.markRecipeAsOKAfterUpdate(action.name);
                        break;
                    }
                    tool.forceMarkRecipeOK(action.name, false);
                }
            }
        } else {
            throw new IllegalArgumentException("No action possible on tool of type " + th.getClass().getSimpleName());
        }
        return th.getFlowState(new JsonObject());
    }

    @AuditedCall(value={"msgType", "project-flow-tool-propagate-schema"})
    @RequestMapping(value={"/tools/propagate-schema/{datasetName}"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> propagateAutomaticallyFromDataset(HttpServletRequest req, @PathVariable String projectKey, @PathVariable String datasetName, @RequestBody PropagateSchemaAutomaticallyOptions options) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        AnyLoc loc = new AnyLoc(projectKey, datasetName);
        AutoSchemaPropagation propagation = new AutoSchemaPropagation(authCtx, projectKey, (List)Lists.newArrayList((Object[])new AnyLoc[]{loc}), options.recipeUpdateOptions, options.excludedRecipes, options.defaultPartitionValuesByDimension, options.partitionsByComputable, options.markAsOkRecipes);
        return propagation.propagateAsync(options.autoRebuild);
    }

    @AuditedCall(value={"msgType", "project-flow-tool-propagate-schema"})
    @RequestMapping(value={"/tools/propagate-schema/"}, method={RequestMethod.POST})
    @ResponseBody
    public FutureResponse<InfoMessage.InfoMessages> propagateAutomatically(HttpServletRequest req, @PathVariable String projectKey, @RequestBody PropagateSchemaAutomaticallyPayload payload) throws Exception {
        AuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.WRITE_CONF});
        }
        AutoSchemaPropagation propagation = new AutoSchemaPropagation(authCtx, projectKey, payload.sources, payload.options.recipeUpdateOptions, payload.options.excludedRecipes, payload.options.defaultPartitionValuesByDimension, payload.options.partitionsByComputable, payload.options.markAsOkRecipes);
        return propagation.propagateAsync(payload.options.autoRebuild);
    }

    @AuditedCall(value={"msgType", "project-flow-get-graph"})
    @RequestMapping(value={"/graph"}, method={RequestMethod.GET})
    @ResponseBody
    public SerializedFlowGraph getGraph(HttpServletRequest req, @PathVariable String projectKey) throws Exception {
        ProjectFlowGraph graph;
        try (Transaction t = this.transactionService.beginRead();){
            AuthCtx authCtx = this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm(authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
            graph = this.flowGraphService.getProjectGraphUnsafe(projectKey);
        }
        SerializedFlowGraph serializedFlowGraph = new SerializedFlowGraph(graph, projectKey);
        return serializedFlowGraph;
    }

    @AuditedCall(value={"msgType", "flow-document-generation", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/documentation/generate"}, method={RequestMethod.POST})
    public void generateDocumentation(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        File template = this.flowDocumentGenerationService.getDefaultTemplate();
        PublicAPIFlowController.writeJSON((HttpServletResponse)resp, (Object)this.flowDocumentGenerationService.generateDocument(authCtx, projectKey, Files.newInputStream(template.toPath(), new OpenOption[0])));
    }

    @AuditedCall(value={"msgType", "flow-document-generation", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/documentation/generate-with-template"}, method={RequestMethod.POST})
    public void generateDocumentation(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam(value="file") MultipartFile customTemplate) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        PublicAPIFlowController.writeJSON((HttpServletResponse)resp, (Object)this.flowDocumentGenerationService.generateDocument(authCtx, projectKey, customTemplate.getInputStream()));
    }

    @AuditedCall(value={"msgType", "flow-document-generation", "projectKey", "${projectKey}"})
    @RequestMapping(value={"/documentation/generate-with-template-in-folder"}, method={RequestMethod.POST})
    public void generateDocumentation(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @RequestParam String folderId, @RequestParam String path) throws Exception {
        DSSAuthCtx authCtx;
        try (Transaction t = this.transactionService.beginRead();){
            authCtx = (DSSAuthCtx)this.authService.getTicketOrKey(req);
            this.projectsService.checkPerm((AuthCtx)authCtx, projectKey, new Privileges.ProjectLevelPrivilegeType[]{Privileges.ProjectLevelPrivilegeType.READ_CONF});
        }
        File template = this.flowDocumentGenerationService.getTemplate(false, projectKey, folderId, path, (AuthCtx)authCtx);
        PublicAPIFlowController.writeJSON((HttpServletResponse)resp, (Object)this.flowDocumentGenerationService.generateDocument(authCtx, projectKey, Files.newInputStream(template.toPath(), new OpenOption[0])));
    }

    @AuditedCall(value={"msgType", "flow-document-download", "projectKey", "${projectKey}", "exportId", "${exportId}"})
    @RequestMapping(value={"/documentation/generated/{exportId}"}, method={RequestMethod.GET})
    public void downloadDocumentation(HttpServletRequest req, HttpServletResponse resp, @PathVariable String projectKey, @PathVariable String exportId) throws Exception {
        try (Transaction t = this.transactionService.beginRead();){
            this.authService.getTicketOrKey(req);
        }
        File flowDocumentation = this.flowDocumentGenerationService.getFdgFile(exportId);
        if (flowDocumentation == null) {
            throw new NotFoundException("Flow Documentation with id '" + exportId + "' doesn't exist or hasn't finished exporting");
        }
        MDGFileUtil.sendDocxDownload((File)flowDocumentation, (HttpServletResponse)resp);
    }

    public static class PropagateSchemaToolAction {
        public PropagateSchemaToolActionType type;
        public String name;
        public boolean updated;
    }

    public static enum PropagateSchemaToolActionType {
        MARK_RECIPE_AS_OK,
        MARK_DATASET_AS_REBUILT;

    }

    public static class PropagateSchemaAutomaticallyOptions {
        public JsonObject recipeUpdateOptions = new JsonObject();
        public Map<String, String> defaultPartitionValuesByDimension = new HashMap<String, String>();
        public Map<String, String> partitionsByComputable = new HashMap<String, String>();
        public Set<String> excludedRecipes = Sets.newHashSet();
        public Set<String> markAsOkRecipes = Sets.newHashSet();
        public boolean autoRebuild;
    }

    public static class PropagateSchemaAutomaticallyPayload {
        public PropagateSchemaAutomaticallyOptions options;
        public List<AnyLoc> sources = new ArrayList<AnyLoc>();
    }

    public static class SerializedFlowGraph<T extends SerializedFlowGraphNode, FG extends FlowGraph> {
        public Set<String> recipes = new HashSet<String>();
        public Set<String> labelingTasks = new HashSet<String>();
        public Set<String> knowledgeBanks = new HashSet<String>();
        public Set<String> implicitRecipes = new HashSet<String>();
        public Map<String, T> nodes = new HashMap<String, T>();
        public Set<String> datasets = new HashSet<String>();
        public Set<String> folders = new HashSet<String>();
        public Set<String> models = new HashSet<String>();
        public Set<String> stores = new HashSet<String>();
        public Set<String> evaluationStores = new HashSet<String>();
        public Set<String> streamingEndpoints = new HashSet<String>();

        SerializedFlowGraph() {
        }

        public SerializedFlowGraph(FG graph, String projectKey) {
            for (FlowRecipe recipe : ((FlowGraph)graph).recipes) {
                this.recipes.add(recipe.getRef(projectKey));
                T recipeNode = this.get((GraphNode)recipe, projectKey, SerializedFlowGraphNodeType.RUNNABLE_RECIPE, graph);
                ((SerializedFlowGraphNode)recipeNode).subType = recipe.getModel().type;
                this.nodes.put(recipe.getRef(projectKey), recipeNode);
            }
            for (FlowLabelingTask labelingTask : ((FlowGraph)graph).labelingTasks) {
                this.labelingTasks.add(labelingTask.getRef(projectKey));
                this.nodes.put(labelingTask.getRef(projectKey), this.get((GraphNode)labelingTask, projectKey, SerializedFlowGraphNodeType.RUNNABLE_LABELING_TASK, graph));
            }
            for (FlowRetrievableKnowledge kb : ((FlowGraph)graph).retrievableKnowledges.values()) {
                this.knowledgeBanks.add(kb.getRef(projectKey));
                this.nodes.put(kb.getRef(projectKey), this.get((GraphNode)kb, projectKey, SerializedFlowGraphNodeType.COMPUTABLE_RETRIEVABLE_KNOWLEDGE, graph));
            }
            for (FlowImplicitRecipe irecipe : ((FlowGraph)graph).implicitRecipes) {
                this.implicitRecipes.add(irecipe.getRef(projectKey));
                this.nodes.put(irecipe.getRef(projectKey), this.get((GraphNode)irecipe, projectKey, SerializedFlowGraphNodeType.RUNNABLE_IMPLICIT_RECIPE, graph));
            }
            for (FlowDataset computable : ((FlowGraph)graph).datasets.values()) {
                this.datasets.add(computable.getRef(projectKey));
                this.nodes.put(computable.getRef(projectKey), this.get((GraphNode)computable, projectKey, SerializedFlowGraphNodeType.COMPUTABLE_DATASET, graph));
            }
            for (FlowDataset computable : ((FlowGraph)graph).models.values()) {
                this.models.add(computable.getRef(projectKey));
                this.nodes.put(computable.getRef(projectKey), this.get((GraphNode)computable, projectKey, SerializedFlowGraphNodeType.COMPUTABLE_SAVED_MODEL, graph));
            }
            for (FlowDataset computable : ((FlowGraph)graph).evaluationStores.values()) {
                this.stores.add(computable.getRef(projectKey));
                this.nodes.put(computable.getRef(projectKey), this.get((GraphNode)computable, projectKey, SerializedFlowGraphNodeType.COMPUTABLE_MODEL_EVALUATION_STORE, graph));
            }
            for (FlowDataset computable : ((FlowGraph)graph).folders.values()) {
                this.folders.add(computable.getRef(projectKey));
                this.nodes.put(computable.getRef(projectKey), this.get((GraphNode)computable, projectKey, SerializedFlowGraphNodeType.COMPUTABLE_FOLDER, graph));
            }
            for (FlowDataset computable : ((FlowGraph)graph).streamingEndpoints.values()) {
                this.streamingEndpoints.add(computable.getRef(projectKey));
                this.nodes.put(computable.getRef(projectKey), this.get((GraphNode)computable, projectKey, SerializedFlowGraphNodeType.COMPUTABLE_STREAMING_ENDPOINT, graph));
            }
        }

        public T get(GraphNode graphNode, String projectKey, SerializedFlowGraphNodeType type, FG graph) {
            return (T)new SerializedFlowGraphNode(graphNode, projectKey, type);
        }
    }

    public static class SerializedFlowGraphNode {
        public SerializedFlowGraphNodeType type;
        public String subType;
        public String ref;
        public String fullId;
        protected List<String> predecessors = new ArrayList<String>();
        protected List<String> successors = new ArrayList<String>();

        SerializedFlowGraphNode() {
        }

        SerializedFlowGraphNode(GraphNode internalNode, String contextProjectKey, SerializedFlowGraphNodeType type) {
            this.ref = AnyLoc.resolveFull((String)internalNode.getFullId()).getSmartName(contextProjectKey);
            this.fullId = internalNode.getFullId();
            this.type = type;
            for (GraphNode snode : internalNode.getSuccessors()) {
                this.successors.add(snode.getRef(contextProjectKey));
            }
            for (GraphNode snode : internalNode.getPredecessors()) {
                this.predecessors.add(snode.getRef(contextProjectKey));
            }
        }
    }

    public static enum SerializedFlowGraphNodeType {
        RUNNABLE_RECIPE,
        RUNNABLE_LABELING_TASK,
        RUNNABLE_IMPLICIT_RECIPE,
        COMPUTABLE_DATASET,
        COMPUTABLE_SAVED_MODEL,
        COMPUTABLE_MODEL_EVALUATION_STORE,
        COMPUTABLE_RETRIEVABLE_KNOWLEDGE,
        COMPUTABLE_FOLDER,
        COMPUTABLE_STREAMING_ENDPOINT;


        public ITaggingService.TaggableType toTaggableType() {
            switch (this) {
                case RUNNABLE_RECIPE: 
                case RUNNABLE_IMPLICIT_RECIPE: {
                    return ITaggingService.TaggableType.RECIPE;
                }
                case RUNNABLE_LABELING_TASK: {
                    return ITaggingService.TaggableType.LABELING_TASK;
                }
                case COMPUTABLE_DATASET: {
                    return ITaggingService.TaggableType.DATASET;
                }
                case COMPUTABLE_SAVED_MODEL: {
                    return ITaggingService.TaggableType.SAVED_MODEL;
                }
                case COMPUTABLE_RETRIEVABLE_KNOWLEDGE: {
                    return ITaggingService.TaggableType.RETRIEVABLE_KNOWLEDGE;
                }
                case COMPUTABLE_FOLDER: {
                    return ITaggingService.TaggableType.MANAGED_FOLDER;
                }
                case COMPUTABLE_STREAMING_ENDPOINT: {
                    return ITaggingService.TaggableType.STREAMING_ENDPOINT;
                }
            }
            return null;
        }
    }
}

