/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.server.services.catalog.LuceneIndexManager;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.LuceneMultiMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.LuceneSecureIndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Document;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.MultiReader;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collectors;

public class LuceneMultiIndexManager
implements LuceneIndexManager {
    private final String indexName;
    private final LuceneMultiMappingsAnalyzer luceneMappingsAnalyzer;
    private final SortedMap<String, LuceneIndexManager> indexManagers;

    public LuceneMultiIndexManager(String indexName, LuceneMultiMappingsAnalyzer luceneMappingsAnalyzer, LuceneIndexManager ... indexManagers) {
        this.indexName = indexName;
        this.luceneMappingsAnalyzer = luceneMappingsAnalyzer;
        this.indexManagers = Arrays.stream(indexManagers).collect(Collectors.toMap(LuceneIndexManager::getIndexName, Function.identity(), new LuceneIndexManagerThrowMerger(), TreeMap::new));
    }

    @Override
    public LuceneMappingsAnalyzer getMappingsAnalyzer() {
        return this.luceneMappingsAnalyzer;
    }

    @Override
    public void commitIndexWriter() throws InterruptedException {
        for (LuceneIndexManager indexManager : this.indexManagers.values()) {
            indexManager.commitIndexWriter();
        }
    }

    @Override
    public void commitIndexWriterAndRefreshIndexSearcherOrWait() throws IOException, InterruptedException {
        for (LuceneIndexManager indexManager : this.indexManagers.values()) {
            indexManager.commitIndexWriterAndRefreshIndexSearcherOrWait();
        }
    }

    @Override
    public void clearIndex() throws InterruptedException {
        for (LuceneIndexManager indexManager : this.indexManagers.values()) {
            indexManager.clearIndex();
        }
    }

    @Override
    public IndexSearcher acquireIndexSearcher() throws IOException {
        HashMap<String, IndexSearcher> subIndexSearchers = new HashMap<String, IndexSearcher>(this.indexManagers.size());
        for (String indexName : this.indexManagers.keySet()) {
            subIndexSearchers.put(indexName, ((LuceneIndexManager)this.indexManagers.get(indexName)).acquireIndexSearcher());
        }
        return new LuceneMultiIndexSearcher(subIndexSearchers);
    }

    @Override
    public void releaseIndexSearcher(IndexSearcher indexSearcher) throws IOException {
        if (!(indexSearcher instanceof LuceneMultiIndexSearcher) || !this.indexManagers.keySet().equals(((LuceneMultiIndexSearcher)indexSearcher).getSubIndexSearchers().keySet())) {
            throw new IllegalStateException("Provided index searcher does not match the multi index manager");
        }
        for (String indexName : this.indexManagers.keySet()) {
            ((LuceneIndexManager)this.indexManagers.get(indexName)).releaseIndexSearcher(((LuceneMultiIndexSearcher)indexSearcher).getSubIndexSearchers().get(indexName));
        }
    }

    @Override
    public boolean refreshIndexSearcher() throws IOException {
        boolean refreshed = true;
        for (LuceneIndexManager indexManager : this.indexManagers.values()) {
            refreshed &= indexManager.refreshIndexSearcher();
        }
        return refreshed;
    }

    @Override
    public void refreshIndexSearcherOrWait() throws IOException {
        for (LuceneIndexManager indexManager : this.indexManagers.values()) {
            indexManager.refreshIndexSearcherOrWait();
        }
    }

    @Override
    public LuceneSecureIndexReader getSecureIndexReader(IndexSearcher indexSearcher) {
        return LuceneSecureIndexReader.fromIndexSearcher((LuceneMappingsAnalyzer)this.luceneMappingsAnalyzer, (IndexSearcher)indexSearcher);
    }

    @Override
    public void startRefreshThread() {
        for (LuceneIndexManager indexManager : this.indexManagers.values()) {
            indexManager.startRefreshThread();
        }
    }

    @Override
    public boolean indexExists() throws IOException {
        for (LuceneIndexManager indexManager : this.indexManagers.values()) {
            if (indexManager.indexExists()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public void addDocument(Document doc) throws IOException {
        throw new UnsupportedOperationException("Multi index manager does not own an index writer");
    }

    @Override
    public void addDocument(Document doc, String docId) throws IOException {
        throw new UnsupportedOperationException("Multi index manager does not own an index writer");
    }

    @Override
    public void deleteDocuments(Query query) throws IOException {
        throw new UnsupportedOperationException("Multi index manager does not own an index writer");
    }

    private static class LuceneIndexManagerThrowMerger
    implements BinaryOperator<LuceneIndexManager> {
        private LuceneIndexManagerThrowMerger() {
        }

        @Override
        public LuceneIndexManager apply(LuceneIndexManager im1, LuceneIndexManager im2) {
            throw new IllegalStateException("Indexes cannot share the same name: " + im1.getIndexName());
        }
    }

    private static class LuceneMultiIndexSearcher
    extends IndexSearcher {
        private final Map<String, IndexSearcher> subIndexSearchers;

        public LuceneMultiIndexSearcher(Map<String, IndexSearcher> subIndexSearchers) throws IOException {
            super((IndexReader)new MultiReader((IndexReader[])subIndexSearchers.values().stream().map(IndexSearcher::getIndexReader).toArray(IndexReader[]::new)));
            this.subIndexSearchers = subIndexSearchers;
        }

        public Map<String, IndexSearcher> getSubIndexSearchers() {
            return this.subIndexSearchers;
        }
    }
}

