/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.server.services.catalog.LuceneBufferedIndexer;
import com.dataiku.dip.server.services.catalog.LuceneIndexManager;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.LuceneSecureIndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.analysis.Analyzer;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Document;
import com.dataiku.dss.shadelib.org.apache.lucene.index.DirectoryReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexReader;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexWriter;
import com.dataiku.dss.shadelib.org.apache.lucene.index.IndexWriterConfig;
import com.dataiku.dss.shadelib.org.apache.lucene.search.CollectorManager;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ControlledRealTimeReopenThread;
import com.dataiku.dss.shadelib.org.apache.lucene.search.IndexSearcher;
import com.dataiku.dss.shadelib.org.apache.lucene.search.Query;
import com.dataiku.dss.shadelib.org.apache.lucene.search.ReferenceManager;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SearcherFactory;
import com.dataiku.dss.shadelib.org.apache.lucene.search.SearcherManager;
import com.dataiku.dss.shadelib.org.apache.lucene.search.TotalHitCountCollectorManager;
import com.dataiku.dss.shadelib.org.apache.lucene.search.similarities.BM25Similarity;
import com.dataiku.dss.shadelib.org.apache.lucene.search.similarities.Similarity;
import com.dataiku.dss.shadelib.org.apache.lucene.store.Directory;
import com.dataiku.dss.shadelib.org.apache.lucene.store.FSDirectory;
import java.io.IOException;
import java.nio.file.Path;

public class LuceneSingleIndexManager
implements LuceneIndexManager,
AutoCloseable {
    private final String indexName;
    private final Path indexPath;
    private final LuceneMappingsAnalyzer luceneMappingsAnalyzer;
    private final IndexWriter indexWriter;
    private final LuceneBufferedIndexer bufferedIndexer;
    private final SearcherManager searcherManager;
    private ControlledRealTimeReopenThread<IndexSearcher> refreshThread;
    private final Double periodicRefreshMaxTimeInSec;
    private final Double specificRefreshMinTimeInSec;

    public LuceneSingleIndexManager(String indexName, Path indexPath, LuceneMappingsAnalyzer luceneMappingsAnalyzer) throws IOException {
        this(indexName, indexPath, luceneMappingsAnalyzer, null, null);
    }

    public LuceneSingleIndexManager(String indexName, Path indexPath, LuceneMappingsAnalyzer luceneMappingsAnalyzer, Double periodicRefreshMaxTimeInSec, Double specificRefreshMinTimeInSec) throws IOException {
        BM25Similarity similarity = new BM25Similarity(DKUApp.getParams().getFloatParam("dku.catalog.BM25ParameterK1", 1.2f), DKUApp.getParams().getFloatParam("dku.catalog.BM25ParameterB", 0.75f), DKUApp.getParams().getBoolParam("dku.catalog.BM25DiscountOverlaps", true));
        this.indexName = indexName;
        this.indexPath = indexPath;
        this.luceneMappingsAnalyzer = luceneMappingsAnalyzer;
        this.indexWriter = LuceneSingleIndexManager.buildIndexWriter(indexPath, luceneMappingsAnalyzer, (Similarity)similarity);
        this.searcherManager = new SearcherManager(this.indexWriter, (SearcherFactory)new IndexSearcherFactory((Similarity)similarity));
        this.bufferedIndexer = new LuceneBufferedIndexer(this.indexWriter, this.luceneMappingsAnalyzer, indexName, DKUApp.getParams().getIntParam("dku.catalog.commitMaxDocumentCount", Integer.valueOf(50000)), DKUApp.getParams().getIntParam("dku.catalog.commitMaxTimeInSec", Integer.valueOf(300)), DKUApp.getParams().getIntParam("dku.catalog.queue.size", Integer.valueOf(10000000)));
        this.periodicRefreshMaxTimeInSec = periodicRefreshMaxTimeInSec;
        this.specificRefreshMinTimeInSec = specificRefreshMinTimeInSec;
    }

    @Override
    public LuceneMappingsAnalyzer getMappingsAnalyzer() {
        return this.luceneMappingsAnalyzer;
    }

    @Override
    public void commitIndexWriter() throws InterruptedException {
        this.bufferedIndexer.commit();
    }

    @Override
    public void commitIndexWriterAndRefreshIndexSearcherOrWait() throws IOException, InterruptedException {
        this.commitIndexWriter();
        this.refreshIndexSearcherOrWait();
    }

    @Override
    public void clearIndex() throws InterruptedException {
        this.bufferedIndexer.deleteAll();
    }

    @Override
    public IndexSearcher acquireIndexSearcher() throws IOException {
        return (IndexSearcher)this.searcherManager.acquire();
    }

    @Override
    public void releaseIndexSearcher(IndexSearcher indexSearcher) throws IOException {
        this.searcherManager.release((Object)indexSearcher);
    }

    @Override
    public boolean refreshIndexSearcher() throws IOException {
        return this.searcherManager.maybeRefresh();
    }

    @Override
    public void refreshIndexSearcherOrWait() throws IOException {
        this.searcherManager.maybeRefreshBlocking();
    }

    @Override
    public LuceneSecureIndexReader getSecureIndexReader(IndexSearcher indexSearcher) {
        return LuceneSecureIndexReader.fromIndexSearcher((LuceneMappingsAnalyzer)this.luceneMappingsAnalyzer, (IndexSearcher)indexSearcher);
    }

    @Override
    public boolean indexExists() throws IOException {
        return DirectoryReader.indexExists((Directory)FSDirectory.open((Path)this.indexPath));
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public void close() throws IOException {
        this.bufferedIndexer.close();
        if (this.refreshThread != null) {
            this.refreshThread.close();
            this.refreshThread = null;
        }
        this.searcherManager.close();
        this.indexWriter.close();
    }

    @Override
    public void startRefreshThread() {
        if (this.refreshThread != null) {
            return;
        }
        this.refreshThread = this.startRefreshThread(this.periodicRefreshMaxTimeInSec == null ? DKUApp.getParams().getDoubleParam("dku.catalog.periodicRefreshMaxTimeInSec", 10.0) : this.periodicRefreshMaxTimeInSec.doubleValue(), this.specificRefreshMinTimeInSec == null ? DKUApp.getParams().getDoubleParam("dku.catalog.specificRefreshMinTimeInSec", 0.1) : this.specificRefreshMinTimeInSec.doubleValue());
    }

    private ControlledRealTimeReopenThread<IndexSearcher> startRefreshThread(double periodicRefreshMaxTimeInSec, double specificRefreshMinTimeInSec) {
        if (this.refreshThread != null) {
            throw new IllegalStateException("An indexing thread is already started");
        }
        ControlledRealTimeReopenThread indexThread = new ControlledRealTimeReopenThread(this.indexWriter, (ReferenceManager)this.searcherManager, periodicRefreshMaxTimeInSec, specificRefreshMinTimeInSec);
        indexThread.setName("catalog-refresh-" + this.getIndexName());
        indexThread.setPriority(Math.max(1, Thread.currentThread().getPriority() - 1));
        indexThread.setDaemon(true);
        indexThread.start();
        return indexThread;
    }

    private static IndexWriter buildIndexWriter(Path indexPath, LuceneMappingsAnalyzer luceneMappingsAnalyzer, Similarity similarity) throws IOException {
        FSDirectory directory = FSDirectory.open((Path)indexPath);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)luceneMappingsAnalyzer.getPerFieldAnalyzerWrapper());
        indexWriterConfig.setSimilarity(similarity);
        return new IndexWriter((Directory)directory, indexWriterConfig);
    }

    @Override
    public void addDocument(Document doc) throws IOException, InterruptedException {
        this.bufferedIndexer.add(doc);
    }

    @Override
    public void addDocument(Document doc, String docId) throws IOException, InterruptedException {
        this.bufferedIndexer.add(doc, docId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDocuments(Query query) throws IOException, InterruptedException {
        int totalHitCount = 0;
        IndexSearcher indexSearcher = this.acquireIndexSearcher();
        try {
            TotalHitCountCollectorManager collectorManager = new TotalHitCountCollectorManager();
            totalHitCount = (Integer)indexSearcher.search(query, (CollectorManager)collectorManager);
        }
        finally {
            this.releaseIndexSearcher(indexSearcher);
            indexSearcher = null;
        }
        if (totalHitCount > 0) {
            this.bufferedIndexer.delete(query, totalHitCount);
        }
    }

    private static class IndexSearcherFactory
    extends SearcherFactory {
        private final Similarity similarity;

        public IndexSearcherFactory(Similarity similarity) {
            this.similarity = similarity;
        }

        public IndexSearcher newSearcher(IndexReader indexReader, IndexReader previousIndexReader) {
            IndexSearcher indexSearcher = new IndexSearcher(indexReader);
            indexSearcher.setSimilarity(this.similarity);
            return indexSearcher;
        }
    }
}

