/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.server.services.catalog.pages;

import com.dataiku.dip.server.notifications.backend.BackendEvent;
import com.dataiku.dip.server.services.PagesSettingsSearchService;
import com.dataiku.dip.server.services.catalog.AbstractIndexingQueueHandler;
import com.dataiku.dip.server.services.catalog.AbstractSearchService;
import com.dataiku.dip.server.services.catalog.LuceneIndexManager;
import com.dataiku.dip.server.services.catalog.LuceneMappingsAnalyzer;
import com.dataiku.dip.server.services.catalog.pages.PagesSettingsCatalogService;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss.shadelib.org.apache.lucene.document.Document;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class PagesSettingsIndexingQueueHandler
extends AbstractIndexingQueueHandler {
    @Autowired
    private PagesSettingsSearchService pagesSettingsSearchService;
    @Autowired
    @Qualifier(value="pageMappingsAnalyzer")
    private LuceneMappingsAnalyzer pageLuceneMappingsAnalyzer;
    @Autowired
    @Qualifier(value="pageIndexManager")
    private LuceneIndexManager pageIndexManager;
    private static final DKULogger logger = DKULogger.getLogger((String)PagesSettingsIndexingQueueHandler.class.getName());
    public static final Set<String> FACETS = Set.of("scope");

    public PagesSettingsIndexingQueueHandler() {
        super("pages-settings-queue-handler");
    }

    @Override
    public void handleQueueEvent(BackendEvent event) throws Exception {
        String name = event.getName();
        if ("lucene-init-index".equals(name)) {
            TimeUnit.MILLISECONDS.sleep(AbstractSearchService.INITIAL_DELAY);
            this.pagesSettingsSearchService.refreshSettingsFile();
            this.indexAll();
        } else if ("page-settings-force-index-all".equals(name)) {
            logger.info((Object)"Force a re-index of all plugins/pages");
            this.pageIndexManager.clearIndex();
            this.pagesSettingsSearchService.refreshSettingsFile();
            this.indexAll();
        }
    }

    private void indexAll() throws IOException, InterruptedException {
        for (PagesSettingsSearchService.PageSettings page : this.pagesSettingsSearchService.list()) {
            this.indexPage(page);
        }
        logger.debug((Object)"Complete reindexing done");
        this.pageIndexManager.commitIndexWriterAndRefreshIndexSearcherOrWait();
        this.initialized = true;
    }

    private void indexPage(PagesSettingsSearchService.PageSettings page) throws IOException, InterruptedException {
        Document doc = new Document();
        this.pageLuceneMappingsAnalyzer.indexStringField(doc, "url", page.url, PagesSettingsCatalogService.TYPE);
        this.pageLuceneMappingsAnalyzer.indexStringField(doc, "name", page.label, PagesSettingsCatalogService.TYPE);
        this.pageLuceneMappingsAnalyzer.indexStringField(doc, "path", page.path, PagesSettingsCatalogService.TYPE);
        this.pageLuceneMappingsAnalyzer.indexStringField(doc, "scope", page.scope, PagesSettingsCatalogService.TYPE);
        this.pageLuceneMappingsAnalyzer.indexStringField(doc, "permission", page.permission == null ? "__DKU__NULL__VALUE__" : page.permission, PagesSettingsCatalogService.TYPE);
        this.pageLuceneMappingsAnalyzer.indexStringField(doc, "_type", PagesSettingsCatalogService.TYPE, PagesSettingsCatalogService.TYPE);
        this.pageIndexManager.addDocument(doc);
    }
}

