/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.scoring.pipelines.uncertainty;

import com.dataiku.scoring.Try;
import com.dataiku.scoring.builders.AlgorithmBuilding;
import com.dataiku.scoring.builders.BuildUtils;
import com.dataiku.scoring.linalg.Vector;
import com.dataiku.scoring.models.Regressor;
import com.dataiku.scoring.pipelines.uncertainty.Interval;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.logging.Logger;

public class PredictionIntervalModel
implements Serializable {
    public static final String PREDICTION_INTERVAL_MODEL_FILE = "dss_prediction_intervals_model.gz";
    private static final String PREDICTION_INTERVAL_PARAMS_FILE = "prediction_intervals_params.json";
    Regressor regressor;
    Params params;
    private static final Logger logger = Logger.getLogger("dku.scoring.pipelines.uncertainty");

    public PredictionIntervalModel(Regressor regressor, Params predictionIntervalParams) {
        this.regressor = regressor;
        this.params = predictionIntervalParams;
    }

    public Try<Interval> computeInterval(Vector features, Double prediction) {
        Try<Double> residuals = this.regressor.predict(features);
        if (residuals.isError()) {
            return Try.failure(residuals.getMessage());
        }
        double lower = prediction - Math.abs(residuals.get() * this.params.q);
        double upper = prediction + Math.abs(residuals.get() * this.params.q);
        return Try.success(new Interval(lower, upper));
    }

    public static PredictionIntervalModel importFromResourcesOrNull(URL resources) {
        try {
            Params predictionIntervalParams = BuildUtils.parseURL(new URL(resources, PREDICTION_INTERVAL_PARAMS_FILE), Params.class);
            Regressor regressor = (Regressor)predictionIntervalParams.algorithm_name.builder.importFrom(resources, AlgorithmBuilding.AlgorithmType.REGRESSION, PREDICTION_INTERVAL_MODEL_FILE);
            return new PredictionIntervalModel(regressor, predictionIntervalParams);
        }
        catch (IOException e) {
            logger.info("Could not load prediction intervals, assuming they are not available. Cause: " + e.getMessage());
            return null;
        }
    }

    public static class Params
    implements Serializable {
        public Double q;
        public AlgorithmBuilding algorithm_name;
    }
}

