/*
 * Decompiled with CFR 0.152.
 */
package com.BoxOfC.LevenshteinAutomaton;

import com.BoxOfC.LevenshteinAutomaton.Position;
import com.BoxOfC.LevenshteinAutomaton.State;
import java.util.Arrays;

public class ParametricState {
    private final int[] memberPositionBoundaryOffsetArray;
    private final int[] memberPositionEArray;
    private final boolean[] memberPositionTArray;
    private int transitionBoundaryOffset = 0;

    public ParametricState(State state) {
        Position[] stateMemberPositionArray = state.getMemberPositions();
        int memberPositionCount = stateMemberPositionArray.length;
        this.memberPositionBoundaryOffsetArray = new int[memberPositionCount];
        this.memberPositionEArray = new int[memberPositionCount];
        this.memberPositionTArray = new boolean[memberPositionCount];
        for (int i = 0; i < memberPositionCount; ++i) {
            this.memberPositionBoundaryOffsetArray[i] = stateMemberPositionArray[i].getI() - stateMemberPositionArray[0].getI();
            this.memberPositionEArray[i] = stateMemberPositionArray[i].getE();
            this.memberPositionTArray[i] = stateMemberPositionArray[i].getT();
        }
    }

    public ParametricState(State state, int transitionBoundaryOffset) {
        this(state);
        this.transitionBoundaryOffset = transitionBoundaryOffset;
    }

    public int getLargestPositionOffset() {
        return this.memberPositionBoundaryOffsetArray[this.memberPositionBoundaryOffsetArray.length - 1];
    }

    public int getTransitionBoundaryOffset() {
        return this.transitionBoundaryOffset;
    }

    public State createActualState(int minimalBoundary) {
        int memberPositionCount = this.memberPositionBoundaryOffsetArray.length;
        Position[] actualStateMemberPositionArray = new Position[memberPositionCount];
        for (int i = 0; i < memberPositionCount; ++i) {
            int currentBoundaryOffset = this.memberPositionBoundaryOffsetArray[i];
            int currentE = this.memberPositionEArray[i];
            boolean currentT = this.memberPositionTArray[i];
            actualStateMemberPositionArray[i] = new Position(minimalBoundary + currentBoundaryOffset, currentE, currentT);
        }
        return new State(actualStateMemberPositionArray);
    }

    public boolean equals(Object obj) {
        boolean areEqual;
        boolean bl = areEqual = this == obj;
        if (!areEqual && obj != null && obj.getClass().equals(ParametricState.class)) {
            ParametricState pState = (ParametricState)obj;
            areEqual = Arrays.equals(this.memberPositionBoundaryOffsetArray, pState.memberPositionBoundaryOffsetArray) && Arrays.equals(this.memberPositionEArray, pState.memberPositionEArray) && Arrays.equals(this.memberPositionTArray, pState.memberPositionTArray);
        }
        return areEqual;
    }

    public int hashCode() {
        int hash = 7;
        hash = 61 * hash + Arrays.hashCode(this.memberPositionBoundaryOffsetArray);
        hash = 61 * hash + Arrays.hashCode(this.memberPositionEArray);
        hash = 61 * hash + Arrays.hashCode(this.memberPositionTArray);
        return hash;
    }

    public String toString() {
        String returnString = "i" + (this.memberPositionTArray[0] ? "(t)" : "") + "#" + this.memberPositionEArray[0] + ")";
        int memberPositionCount = this.memberPositionBoundaryOffsetArray.length;
        for (int i = 1; i < memberPositionCount; ++i) {
            returnString = returnString + " (i + " + this.memberPositionBoundaryOffsetArray[i] + ")" + (this.memberPositionTArray[i] ? "(t)" : "") + "(#" + this.memberPositionEArray[i] + ")";
        }
        if (this.transitionBoundaryOffset != 0) {
            returnString = returnString + " " + this.transitionBoundaryOffset;
        }
        return returnString;
    }
}

