/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.BufferedHttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.BinaryDataHelper;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.FluxByteBufferContent;
import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.Objects;

public abstract class HttpResponse
implements Closeable {
    private final HttpRequest request;

    protected HttpResponse(HttpRequest request) {
        this.request = request;
    }

    public abstract int getStatusCode();

    @Deprecated
    public abstract String getHeaderValue(String var1);

    public String getHeaderValue(HttpHeaderName headerName) {
        return this.getHeaders().getValue(headerName);
    }

    public abstract HttpHeaders getHeaders();

    public abstract Flux<ByteBuffer> getBody();

    public BinaryData getBodyAsBinaryData() {
        String contentLength = this.getHeaderValue(HttpHeaderName.CONTENT_LENGTH);
        Flux<ByteBuffer> body = this.getBody();
        if (CoreUtils.isNullOrEmpty(contentLength)) {
            return BinaryDataHelper.createBinaryData(new FluxByteBufferContent(body));
        }
        try {
            return BinaryDataHelper.createBinaryData(new FluxByteBufferContent(body, Long.parseLong(contentLength)));
        }
        catch (NumberFormatException ignored) {
            return BinaryDataHelper.createBinaryData(new FluxByteBufferContent(body));
        }
    }

    public abstract Mono<byte[]> getBodyAsByteArray();

    public abstract Mono<String> getBodyAsString();

    public abstract Mono<String> getBodyAsString(Charset var1);

    public Mono<InputStream> getBodyAsInputStream() {
        return this.getBodyAsByteArray().map(ByteArrayInputStream::new);
    }

    public final HttpRequest getRequest() {
        return this.request;
    }

    public HttpResponse buffer() {
        return new BufferedHttpResponse(this);
    }

    public Mono<Void> writeBodyToAsync(AsynchronousByteChannel channel) {
        Objects.requireNonNull(channel, "'channel' must not be null");
        Flux<ByteBuffer> body = this.getBody();
        if (body != null) {
            return FluxUtil.writeToAsynchronousByteChannel(body, channel);
        }
        return Mono.empty();
    }

    public void writeBodyTo(WritableByteChannel channel) throws IOException {
        Flux<ByteBuffer> body = this.getBody();
        if (body != null) {
            Mono.using(() -> this, ignored -> FluxUtil.writeToWritableByteChannel(body, channel), HttpResponse::close).block();
        }
    }

    @Override
    public void close() {
    }
}

