/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpClient;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeader;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaders;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation.BinaryDataRequestBody;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation.OkHttpAsyncBufferedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation.OkHttpAsyncResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation.OkHttpFluxRequestBody;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation.OkHttpProgressReportingRequestBody;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation.PerCallTimeoutCall;
import com.dataiku.dss.shadelibazure.com.azure.core.http.okhttp.implementation.ResponseTimeoutListenerFactory;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.BinaryDataContent;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.BinaryDataHelper;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.util.FluxByteBufferContent;
import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Contexts;
import com.dataiku.dss.shadelibazure.com.azure.core.util.ProgressReporter;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.okhttp3.Call;
import com.dataiku.dss.shadelibazure.okhttp3.Callback;
import com.dataiku.dss.shadelibazure.okhttp3.EventListener;
import com.dataiku.dss.shadelibazure.okhttp3.MediaType;
import com.dataiku.dss.shadelibazure.okhttp3.OkHttpClient;
import com.dataiku.dss.shadelibazure.okhttp3.Request;
import com.dataiku.dss.shadelibazure.okhttp3.RequestBody;
import com.dataiku.dss.shadelibazure.okhttp3.Response;
import com.dataiku.dss.shadelibazure.okhttp3.ResponseBody;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.MonoSink;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.UncheckedIOException;
import java.time.Duration;

class OkHttpAsyncHttpClient
implements HttpClient {
    private static final ClientLogger LOGGER = new ClientLogger(OkHttpAsyncHttpClient.class);
    private static final byte[] EMPTY_BODY = new byte[0];
    private static final RequestBody EMPTY_REQUEST_BODY = RequestBody.create(EMPTY_BODY);
    final OkHttpClient httpClient;
    private final Duration responseTimeout;

    OkHttpAsyncHttpClient(OkHttpClient httpClient, Duration responseTimeout) {
        EventListener.Factory factory2 = httpClient.eventListenerFactory();
        this.httpClient = httpClient.newBuilder().eventListenerFactory(new ResponseTimeoutListenerFactory(factory2)).build();
        this.responseTimeout = responseTimeout;
    }

    @Override
    public Mono<HttpResponse> send(HttpRequest request) {
        return this.send(request, Context.NONE);
    }

    @Override
    public Mono<HttpResponse> send(HttpRequest request, Context context) {
        boolean eagerlyReadResponse = (Boolean)context.getData("azure-eagerly-read-response").orElse(false);
        boolean ignoreResponseBody = (Boolean)context.getData("azure-ignore-response-body").orElse(false);
        boolean eagerlyConvertHeaders = (Boolean)context.getData("azure-eagerly-convert-headers").orElse(false);
        Duration perCallTimeout = (Duration)context.getData("azure-response-timeout").filter(timeoutDuration -> timeoutDuration instanceof Duration).orElse(this.responseTimeout);
        ProgressReporter progressReporter = Contexts.with(context).getHttpRequestProgressReporter();
        return Mono.create(sink2 -> sink2.onRequest(value -> Mono.fromCallable(() -> this.toOkHttpRequest(request, progressReporter, perCallTimeout)).subscribe(okHttpRequest -> {
            try {
                Call call = this.httpClient.newCall((Request)okHttpRequest);
                call.enqueue(new OkHttpCallback((MonoSink<HttpResponse>)sink2, request, eagerlyReadResponse, ignoreResponseBody, eagerlyConvertHeaders));
                sink2.onCancel(call::cancel);
            }
            catch (Exception ex) {
                sink2.error(ex);
            }
        }, sink2::error)));
    }

    @Override
    public HttpResponse sendSync(HttpRequest request, Context context) {
        boolean eagerlyReadResponse = (Boolean)context.getData("azure-eagerly-read-response").orElse(false);
        boolean ignoreResponseBody = (Boolean)context.getData("azure-ignore-response-body").orElse(false);
        boolean eagerlyConvertHeaders = (Boolean)context.getData("azure-eagerly-convert-headers").orElse(false);
        Duration perCallTimeout = (Duration)context.getData("azure-response-timeout").filter(timeoutDuration -> timeoutDuration instanceof Duration).orElse(this.responseTimeout);
        ProgressReporter progressReporter = Contexts.with(context).getHttpRequestProgressReporter();
        Request okHttpRequest = this.toOkHttpRequest(request, progressReporter, perCallTimeout);
        Call call = null;
        try {
            call = this.httpClient.newCall(okHttpRequest);
            Response okHttpResponse = call.execute();
            return OkHttpAsyncHttpClient.toHttpResponse(request, okHttpResponse, eagerlyReadResponse, ignoreResponseBody, eagerlyConvertHeaders);
        }
        catch (IOException e) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(OkHttpAsyncHttpClient.mapIOException(e, call)));
        }
    }

    private static IOException mapIOException(IOException e, Call call) {
        if (call == null) {
            return e;
        }
        PerCallTimeoutCall perCallTimeoutCall = call.request().tag(PerCallTimeoutCall.class);
        if (perCallTimeoutCall != null && perCallTimeoutCall.isTimedOut()) {
            InterruptedIOException i = new InterruptedIOException("timedout");
            i.addSuppressed(e);
            return i;
        }
        return e;
    }

    private Request toOkHttpRequest(HttpRequest request, ProgressReporter progressReporter, Duration perCallTimeout) {
        Request.Builder requestBuilder = new Request.Builder().url(request.getUrl());
        if (perCallTimeout != null) {
            requestBuilder.tag(PerCallTimeoutCall.class, new PerCallTimeoutCall(perCallTimeout.toMillis()));
        }
        if (request.getHeaders() != null) {
            for (HttpHeader hdr : request.getHeaders()) {
                hdr.getValuesList().forEach(value -> requestBuilder.addHeader(hdr.getName(), (String)value));
            }
        }
        if (request.getHttpMethod() == HttpMethod.GET) {
            return requestBuilder.get().build();
        }
        if (request.getHttpMethod() == HttpMethod.HEAD) {
            return requestBuilder.head().build();
        }
        RequestBody okHttpRequestBody = this.toOkHttpRequestBody(request.getBodyAsBinaryData(), request.getHeaders());
        if (progressReporter != null) {
            okHttpRequestBody = new OkHttpProgressReportingRequestBody(okHttpRequestBody, progressReporter);
        }
        return requestBuilder.method(request.getHttpMethod().toString(), okHttpRequestBody).build();
    }

    private RequestBody toOkHttpRequestBody(BinaryData bodyContent, HttpHeaders headers) {
        if (bodyContent == null) {
            return EMPTY_REQUEST_BODY;
        }
        String contentType = headers.getValue(HttpHeaderName.CONTENT_TYPE);
        MediaType mediaType = contentType == null ? null : MediaType.parse(contentType);
        BinaryDataContent content = BinaryDataHelper.getContent(bodyContent);
        long effectiveContentLength = OkHttpAsyncHttpClient.getRequestContentLength(content, headers);
        if (content instanceof FluxByteBufferContent) {
            return new OkHttpFluxRequestBody(content, effectiveContentLength, mediaType, this.httpClient.callTimeoutMillis());
        }
        return new BinaryDataRequestBody(bodyContent, mediaType, effectiveContentLength);
    }

    private static long getRequestContentLength(BinaryDataContent content, HttpHeaders headers) {
        Long contentLength = content.getLength();
        if (contentLength == null) {
            String contentLengthHeaderValue = headers.getValue(HttpHeaderName.CONTENT_LENGTH);
            contentLength = contentLengthHeaderValue != null ? Long.valueOf(Long.parseLong(contentLengthHeaderValue)) : Long.valueOf(-1L);
        }
        return contentLength;
    }

    private static HttpResponse toHttpResponse(HttpRequest request, Response response, boolean eagerlyReadResponse, boolean ignoreResponseBody, boolean eagerlyConvertHeaders) throws IOException {
        if (eagerlyReadResponse || ignoreResponseBody) {
            try (ResponseBody body = response.body();){
                byte[] bytes = body != null ? body.bytes() : EMPTY_BODY;
                OkHttpAsyncBufferedResponse okHttpAsyncBufferedResponse = new OkHttpAsyncBufferedResponse(response, request, bytes, eagerlyConvertHeaders);
                return okHttpAsyncBufferedResponse;
            }
        }
        return new OkHttpAsyncResponse(response, request, eagerlyConvertHeaders);
    }

    private static class OkHttpCallback
    implements Callback {
        private final MonoSink<HttpResponse> sink;
        private final HttpRequest request;
        private final boolean eagerlyReadResponse;
        private final boolean ignoreResponseBody;
        private final boolean eagerlyConvertHeaders;

        OkHttpCallback(MonoSink<HttpResponse> sink2, HttpRequest request, boolean eagerlyReadResponse, boolean ignoreResponseBody, boolean eagerlyConvertHeaders) {
            this.sink = sink2;
            this.request = request;
            this.eagerlyReadResponse = eagerlyReadResponse;
            this.ignoreResponseBody = ignoreResponseBody;
            this.eagerlyConvertHeaders = eagerlyConvertHeaders;
        }

        @Override
        public void onFailure(Call call, IOException e) {
            if (e.getSuppressed().length == 1) {
                Throwable suppressed = e.getSuppressed()[0];
                if (suppressed instanceof IOException) {
                    this.sink.error(OkHttpAsyncHttpClient.mapIOException((IOException)suppressed, call));
                } else {
                    this.sink.error(suppressed);
                }
            } else {
                this.sink.error(OkHttpAsyncHttpClient.mapIOException(e, call));
            }
        }

        @Override
        public void onResponse(Call call, Response response) {
            try {
                this.sink.success(OkHttpAsyncHttpClient.toHttpResponse(this.request, response, this.eagerlyReadResponse, this.ignoreResponseBody, this.eagerlyConvertHeaders));
            }
            catch (IOException ex) {
                this.sink.error(ex);
            }
        }
    }
}

