/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http.rest;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterableBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.util.paging.PageRetrieverSync;
import java.util.ArrayList;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class PagedIterable<T>
extends PagedIterableBase<T, PagedResponse<T>> {
    private final PagedFlux<T> pagedFlux;
    private final Function<Integer, PagedResponse<T>> firstPageRetriever;
    private final BiFunction<String, Integer, PagedResponse<T>> nextPageRetriever;

    public PagedIterable(PagedFlux<T> pagedFlux) {
        super(pagedFlux);
        this.pagedFlux = pagedFlux;
        this.firstPageRetriever = null;
        this.nextPageRetriever = null;
    }

    public PagedIterable(Supplier<PagedResponse<T>> firstPageRetriever) {
        this(firstPageRetriever, null);
    }

    public PagedIterable(Function<Integer, PagedResponse<T>> firstPageRetriever) {
        this(firstPageRetriever, (String token, Integer pageSize) -> null);
    }

    public PagedIterable(Supplier<PagedResponse<T>> firstPageRetriever, Function<String, PagedResponse<T>> nextPageRetriever) {
        this(() -> (arg_0, arg_1) -> PagedIterable.lambda$new$1((Supplier)firstPageRetriever, nextPageRetriever, arg_0, arg_1), (Integer pageSize) -> (PagedResponse)firstPageRetriever.get(), (String continuationToken, Integer pageSize) -> (PagedResponse)nextPageRetriever.apply((String)continuationToken));
    }

    public PagedIterable(Function<Integer, PagedResponse<T>> firstPageRetriever, BiFunction<String, Integer, PagedResponse<T>> nextPageRetriever) {
        this(() -> (continuationToken, pageSize) -> continuationToken == null ? (PagedResponse)firstPageRetriever.apply(pageSize) : (PagedResponse)nextPageRetriever.apply((String)continuationToken, pageSize), firstPageRetriever, nextPageRetriever);
    }

    public <S> PagedIterable<S> mapPage(Function<T, S> mapper) {
        if (this.pagedFlux != null) {
            return new PagedIterable<S>(this.pagedFlux.mapPage(mapper));
        }
        Function<Integer, PagedResponse<T>> firstMappedPageRetriever = pageSize -> {
            PagedResponse<T> firstPageResponse = this.firstPageRetriever.apply((Integer)pageSize);
            PagedResponse firstMappedPageResponse = this.mapPagedResponse(firstPageResponse, mapper);
            return firstMappedPageResponse;
        };
        BiFunction<String, Integer, PagedResponse<T>> nextMappedPageRetriever = (continuationToken, pageSize) -> {
            PagedResponse<T> nextPageResponse = this.nextPageRetriever.apply((String)continuationToken, (Integer)pageSize);
            PagedResponse nextMappedPageResponse = this.mapPagedResponse(nextPageResponse, mapper);
            return nextMappedPageResponse;
        };
        return new PagedIterable<T>(firstMappedPageRetriever, nextMappedPageRetriever);
    }

    private PagedIterable(Supplier<PageRetrieverSync<String, PagedResponse<T>>> provider, Function<Integer, PagedResponse<T>> firstPageRetriever, BiFunction<String, Integer, PagedResponse<T>> nextPageRetriever) {
        super(provider);
        this.pagedFlux = null;
        this.firstPageRetriever = firstPageRetriever;
        this.nextPageRetriever = nextPageRetriever;
    }

    private <S> PagedResponse<S> mapPagedResponse(PagedResponse<T> pagedResponse, Function<T, S> mapper) {
        if (pagedResponse == null) {
            return null;
        }
        return new PagedResponseBase(pagedResponse.getRequest(), pagedResponse.getStatusCode(), pagedResponse.getHeaders(), pagedResponse.getValue().stream().map(mapper).collect(Collectors.toCollection(() -> new ArrayList(pagedResponse.getValue().size()))), (String)pagedResponse.getContinuationToken(), null);
    }

    private static /* synthetic */ PagedResponse lambda$new$1(Supplier firstPageRetriever, Function nextPageRetriever, String continuationToken, Integer pageSize) {
        return continuationToken == null ? (PagedResponse)firstPageRetriever.get() : (PagedResponse)nextPageRetriever.apply(continuationToken);
    }
}

