/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.polling;

import com.dataiku.dss.shadelibazure.com.azure.core.exception.AzureException;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeader;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpHeaderName;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipeline;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpRequest;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.ImplUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.serializer.DefaultJsonSerializer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.BinaryData;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.UrlBuilder;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.LongRunningOperationStatus;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingStrategyOptions;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollingUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPollingStrategy;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.implementation.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.implementation.PollingUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.ObjectSerializer;
import com.dataiku.dss.shadelibazure.com.azure.core.util.serializer.TypeReference;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Objects;

public class SyncOperationResourcePollingStrategy<T, U>
implements SyncPollingStrategy<T, U> {
    private static final ClientLogger LOGGER = new ClientLogger(SyncOperationResourcePollingStrategy.class);
    private static final HttpHeaderName DEFAULT_OPERATION_LOCATION_HEADER = HttpHeaderName.fromString("Operation-Location");
    private static final TypeReference<PollResult> POLL_RESULT_TYPE_REFERENCE = TypeReference.createInstance(PollResult.class);
    private final HttpPipeline httpPipeline;
    private final ObjectSerializer serializer;
    private final String endpoint;
    private final HttpHeaderName operationLocationHeaderName;
    private final Context context;
    private final String serviceVersion;

    public SyncOperationResourcePollingStrategy(HttpPipeline httpPipeline) {
        this(DEFAULT_OPERATION_LOCATION_HEADER, new PollingStrategyOptions(httpPipeline));
    }

    public SyncOperationResourcePollingStrategy(HttpPipeline httpPipeline, ObjectSerializer serializer, String operationLocationHeaderName) {
        this(httpPipeline, serializer, operationLocationHeaderName, Context.NONE);
    }

    public SyncOperationResourcePollingStrategy(HttpPipeline httpPipeline, ObjectSerializer serializer, String operationLocationHeaderName, Context context) {
        this(httpPipeline, null, serializer, operationLocationHeaderName, context);
    }

    public SyncOperationResourcePollingStrategy(HttpPipeline httpPipeline, String endpoint, ObjectSerializer serializer, String operationLocationHeaderName, Context context) {
        this(operationLocationHeaderName == null ? null : HttpHeaderName.fromString(operationLocationHeaderName), new PollingStrategyOptions(httpPipeline).setEndpoint(endpoint).setSerializer(serializer).setContext(context));
    }

    public SyncOperationResourcePollingStrategy(HttpHeaderName operationLocationHeaderName, PollingStrategyOptions pollingStrategyOptions) {
        Objects.requireNonNull(pollingStrategyOptions, "'pollingStrategyOptions' cannot be null");
        this.httpPipeline = pollingStrategyOptions.getHttpPipeline();
        this.endpoint = pollingStrategyOptions.getEndpoint();
        this.serializer = pollingStrategyOptions.getSerializer() != null ? pollingStrategyOptions.getSerializer() : new DefaultJsonSerializer();
        this.operationLocationHeaderName = operationLocationHeaderName == null ? DEFAULT_OPERATION_LOCATION_HEADER : operationLocationHeaderName;
        this.serviceVersion = pollingStrategyOptions.getServiceVersion();
        this.context = pollingStrategyOptions.getContext() == null ? Context.NONE : pollingStrategyOptions.getContext();
    }

    @Override
    public boolean canPoll(Response<?> initialResponse) {
        return PollingUtil.operationResourceCanPoll(initialResponse, this.operationLocationHeaderName, this.endpoint, LOGGER);
    }

    @Override
    public PollResponse<T> onInitialResponse(Response<?> response, PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        HttpHeader operationLocationHeader = response.getHeaders().get(this.operationLocationHeaderName);
        HttpHeader locationHeader = response.getHeaders().get(HttpHeaderName.LOCATION);
        if (operationLocationHeader != null) {
            pollingContext.setData(this.operationLocationHeaderName.getCaseSensitiveName(), PollingUtils.getAbsolutePath(operationLocationHeader.getValue(), this.endpoint, LOGGER));
        }
        if (locationHeader != null) {
            pollingContext.setData("Location", PollingUtils.getAbsolutePath(locationHeader.getValue(), this.endpoint, LOGGER));
        }
        pollingContext.setData("httpMethod", response.getRequest().getHttpMethod().name());
        pollingContext.setData("requestURL", response.getRequest().getUrl().toString());
        if (response.getStatusCode() == 200 || response.getStatusCode() == 201 || response.getStatusCode() == 202 || response.getStatusCode() == 204) {
            Duration retryAfter = ImplUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
            return new PollResponse<T>(LongRunningOperationStatus.IN_PROGRESS, PollingUtils.convertResponseSync(response.getValue(), this.serializer, pollResponseType), retryAfter);
        }
        throw LOGGER.logExceptionAsError(new AzureException(String.format("Operation failed or cancelled with status code %d, '%s' header: %s, and response body: %s", response.getStatusCode(), this.operationLocationHeaderName, operationLocationHeader, PollingUtils.serializeResponseSync(response.getValue(), this.serializer))));
    }

    @Override
    public PollResponse<T> poll(PollingContext<T> pollingContext, TypeReference<T> pollResponseType) {
        String url = pollingContext.getData(this.operationLocationHeaderName.getCaseSensitiveName());
        url = this.setServiceVersionQueryParam(url);
        HttpRequest request = new HttpRequest(HttpMethod.GET, url);
        try (HttpResponse response = this.httpPipeline.sendSync(request, this.context);){
            BinaryData responseBody = response.getBodyAsBinaryData();
            PollResult pollResult = PollingUtils.deserializeResponseSync(responseBody, this.serializer, POLL_RESULT_TYPE_REFERENCE);
            String resourceLocation = pollResult.getResourceLocation();
            if (resourceLocation != null) {
                pollingContext.setData("resourceLocation", PollingUtils.getAbsolutePath(resourceLocation, this.endpoint, LOGGER));
            }
            pollingContext.setData("pollResponseBody", responseBody.toString());
            Duration retryAfter = ImplUtils.getRetryAfterFromHeaders(response.getHeaders(), OffsetDateTime::now);
            PollResponse<T> pollResponse = new PollResponse<T>(pollResult.getStatus(), PollingUtils.deserializeResponseSync(responseBody, this.serializer, pollResponseType), retryAfter);
            return pollResponse;
        }
    }

    @Override
    public U getResult(PollingContext<T> pollingContext, TypeReference<U> resultType) {
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.FAILED) {
            throw LOGGER.logExceptionAsError(new AzureException("Long running operation failed."));
        }
        if (pollingContext.getLatestResponse().getStatus() == LongRunningOperationStatus.USER_CANCELLED) {
            throw LOGGER.logExceptionAsError(new AzureException("Long running operation cancelled."));
        }
        String finalGetUrl = pollingContext.getData("resourceLocation");
        if (finalGetUrl == null) {
            String httpMethod = pollingContext.getData("httpMethod");
            if (HttpMethod.PUT.name().equalsIgnoreCase(httpMethod) || HttpMethod.PATCH.name().equalsIgnoreCase(httpMethod)) {
                finalGetUrl = pollingContext.getData("requestURL");
            } else if (HttpMethod.POST.name().equalsIgnoreCase(httpMethod)) {
                finalGetUrl = pollingContext.getData("Location");
            } else {
                throw LOGGER.logExceptionAsError(new AzureException("Cannot get final result"));
            }
        }
        if (finalGetUrl == null) {
            String latestResponseBody = pollingContext.getData("pollResponseBody");
            return PollingUtils.deserializeResponseSync(BinaryData.fromString(latestResponseBody), this.serializer, resultType);
        }
        finalGetUrl = this.setServiceVersionQueryParam(finalGetUrl);
        HttpRequest request = new HttpRequest(HttpMethod.GET, finalGetUrl);
        try (HttpResponse response = this.httpPipeline.sendSync(request, this.context);){
            BinaryData responseBody = response.getBodyAsBinaryData();
            U u = PollingUtils.deserializeResponseSync(responseBody, this.serializer, resultType);
            return u;
        }
    }

    private String setServiceVersionQueryParam(String url) {
        if (!CoreUtils.isNullOrEmpty(this.serviceVersion)) {
            UrlBuilder urlBuilder = UrlBuilder.parse(url);
            urlBuilder.setQueryParameter("api-version", this.serviceVersion);
            url = urlBuilder.toString();
        }
        return url;
    }
}

