/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.ManagedIdentityServiceCredential;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClient;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class AksExchangeTokenCredential
extends ManagedIdentityServiceCredential {
    private static final ClientLogger LOGGER = new ClientLogger(AksExchangeTokenCredential.class);

    AksExchangeTokenCredential(String clientId, IdentityClient identityClient) {
        super(clientId, identityClient, "AZURE AKS TOKEN EXCHANGE");
    }

    @Override
    public Mono<AccessToken> authenticate(TokenRequestContext request) {
        if (this.getClientId() == null) {
            return Mono.error(LOGGER.logExceptionAsError(new IllegalStateException("The client id is not configured via 'AZURE_CLIENT_ID' environment variable or through the credential builder. Please ensure client id is provided to authenticate via token exchange in AKS environment.")));
        }
        return this.identityClient.authenticateWithManagedIdentityConfidentialClient(request);
    }
}

