/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.ManagedIdentityServiceCredential;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClient;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;

class ServiceFabricMsiCredential
extends ManagedIdentityServiceCredential {
    private static final ClientLogger LOGGER = new ClientLogger(ServiceFabricMsiCredential.class);
    private final String identityEndpoint;
    private final String identityHeader;
    private final String identityServerThumbprint;
    private final IdentityClient identityClient;

    ServiceFabricMsiCredential(String clientId, IdentityClient identityClient) {
        super(clientId, identityClient, "AZURE SERVICE FABRIC IMDS ENDPOINT");
        Configuration configuration = Configuration.getGlobalConfiguration().clone();
        this.identityEndpoint = configuration.get("IDENTITY_ENDPOINT");
        this.identityHeader = configuration.get("IDENTITY_HEADER");
        this.identityServerThumbprint = configuration.get("IDENTITY_SERVER_THUMBPRINT");
        this.identityClient = identityClient;
        if (this.identityEndpoint != null) {
            this.validateEndpointProtocol(this.identityEndpoint, "Identity", LOGGER);
        }
    }

    @Override
    public Mono<AccessToken> authenticate(TokenRequestContext request) {
        return this.identityClient.authenticateWithManagedIdentityMsalClient(request);
    }
}

