/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.credential.AccessToken;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenCredential;
import com.dataiku.dss.shadelibazure.com.azure.core.credential.TokenRequestContext;
import com.dataiku.dss.shadelibazure.com.azure.core.exception.ClientAuthenticationException;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.CredentialUnavailableException;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClient;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientBuilder;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.IdentityClientOptions;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.MsalToken;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.VisualStudioCacheAccessor;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.LoggingUtil;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class VisualStudioCodeCredential
implements TokenCredential {
    private final IdentityClient identityClient;
    private final AtomicReference<MsalToken> cachedToken;
    private final String cloudInstance;
    private static final ClientLogger LOGGER = new ClientLogger(VisualStudioCodeCredential.class);
    private static final String TROUBLESHOOTING = "VisualStudioCodeCredential is affected by known issues. See https://aka.ms/azsdk/java/identity/troubleshoot#troubleshoot-visualstudiocodecredential-authentication-issues for more information.";

    VisualStudioCodeCredential(String tenantId, IdentityClientOptions identityClientOptions) {
        IdentityClientOptions options = identityClientOptions == null ? new IdentityClientOptions() : identityClientOptions;
        VisualStudioCacheAccessor accessor = new VisualStudioCacheAccessor();
        Map<String, String> userSettings = accessor.getUserSettingsDetails();
        this.cloudInstance = userSettings.get("cloud");
        if (CoreUtils.isNullOrEmpty(options.getAuthorityHost())) {
            options.setAuthorityHost(accessor.getAzureAuthHost(this.cloudInstance));
        }
        String tenant = !CoreUtils.isNullOrEmpty(tenantId) ? tenantId : userSettings.getOrDefault("tenant", "common");
        this.identityClient = new IdentityClientBuilder().tenantId(tenant).clientId("aebc6443-996d-45c2-90f0-388ff96faa56").identityClientOptions(options).build();
        this.cachedToken = new AtomicReference();
    }

    @Override
    public Mono<AccessToken> getToken(TokenRequestContext request) {
        return Mono.defer(() -> {
            if (this.cachedToken.get() != null) {
                return this.identityClient.authenticateWithPublicClientCache(request, this.cachedToken.get().getAccount()).onErrorResume(t -> Mono.empty());
            }
            return Mono.empty();
        }).switchIfEmpty(Mono.defer(() -> this.identityClient.authenticateWithVsCodeCredential(request, this.cloudInstance))).map(msalToken -> {
            this.cachedToken.set((MsalToken)msalToken);
            return msalToken;
        }).doOnNext(token -> LoggingUtil.logTokenSuccess(LOGGER, request)).doOnError(error -> {
            Throwable other = null;
            other = error instanceof CredentialUnavailableException ? new CredentialUnavailableException(TROUBLESHOOTING, (Throwable)error) : (error instanceof ClientAuthenticationException ? new ClientAuthenticationException(TROUBLESHOOTING, null, (Throwable)error) : error);
            LoggingUtil.logTokenError(LOGGER, this.identityClient.getIdentityClientOptions(), request, other);
        });
    }
}

