/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.annotation.BodyParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Delete;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ExpectedResponses;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Get;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HeaderParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Headers;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Host;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.HostParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.PathParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Post;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.Put;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.QueryParam;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ReturnType;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceInterface;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.ServiceMethod;
import com.dataiku.dss.shadelibazure.com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedResponseBase;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.Response;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.RestProxy;
import com.dataiku.dss.shadelibazure.com.azure.core.management.exception.ManagementException;
import com.dataiku.dss.shadelibazure.com.azure.core.management.polling.PollResult;
import com.dataiku.dss.shadelibazure.com.azure.core.util.Context;
import com.dataiku.dss.shadelibazure.com.azure.core.util.FluxUtil;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.PollerFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.util.polling.SyncPoller;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.ConfigurationServicesClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.ConfigurationServiceResourceInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.fluent.models.ConfigurationServiceSettingsValidateResultInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.implementation.AppPlatformManagementClientImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ConfigurationServiceResourceCollection;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.ConfigurationServiceSettings;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Flux;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class ConfigurationServicesClientImpl
implements ConfigurationServicesClient {
    private final ConfigurationServicesService service;
    private final AppPlatformManagementClientImpl client;

    ConfigurationServicesClientImpl(AppPlatformManagementClientImpl client) {
        this.service = RestProxy.create(ConfigurationServicesService.class, client.getHttpPipeline(), client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ConfigurationServiceResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String configurationServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (configurationServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configurationServiceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<ConfigurationServiceResourceInner>> getWithResponseAsync(String resourceGroupName, String serviceName, String configurationServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (configurationServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configurationServiceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationServiceResourceInner> getAsync(String resourceGroupName, String serviceName, String configurationServiceName) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, configurationServiceName).flatMap(res -> Mono.justOrEmpty((ConfigurationServiceResourceInner)res.getValue()));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ConfigurationServiceResourceInner> getWithResponse(String resourceGroupName, String serviceName, String configurationServiceName, Context context) {
        return this.getWithResponseAsync(resourceGroupName, serviceName, configurationServiceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationServiceResourceInner get(String resourceGroupName, String serviceName, String configurationServiceName) {
        return this.getWithResponse(resourceGroupName, serviceName, configurationServiceName, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (configurationServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceName is required and cannot be null."));
        }
        if (configurationServiceResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceResource is required and cannot be null."));
        }
        configurationServiceResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configurationServiceName, configurationServiceResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (configurationServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceName is required and cannot be null."));
        }
        if (configurationServiceResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceResource is required and cannot be null."));
        }
        configurationServiceResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configurationServiceName, configurationServiceResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ConfigurationServiceResourceInner>, ConfigurationServiceResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConfigurationServiceResourceInner.class), (Type)((Object)ConfigurationServiceResourceInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConfigurationServiceResourceInner>, ConfigurationServiceResourceInner> beginCreateOrUpdateAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConfigurationServiceResourceInner.class), (Type)((Object)ConfigurationServiceResourceInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConfigurationServiceResourceInner>, ConfigurationServiceResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConfigurationServiceResourceInner>, ConfigurationServiceResourceInner> beginCreateOrUpdate(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationServiceResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConfigurationServiceResourceInner> createOrUpdateAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationServiceResourceInner createOrUpdate(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource) {
        return this.createOrUpdateAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationServiceResourceInner createOrUpdate(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource, Context context) {
        return this.createOrUpdateAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String configurationServiceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (configurationServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configurationServiceName, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String serviceName, String configurationServiceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (configurationServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configurationServiceName, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String configurationServiceName) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, configurationServiceName);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String serviceName, String configurationServiceName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, serviceName, configurationServiceName, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String configurationServiceName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, configurationServiceName).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String serviceName, String configurationServiceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, configurationServiceName, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String configurationServiceName) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, configurationServiceName).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String serviceName, String configurationServiceName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, serviceName, configurationServiceName, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String configurationServiceName) {
        this.deleteAsync(resourceGroupName, serviceName, configurationServiceName).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String serviceName, String configurationServiceName, Context context) {
        this.deleteAsync(resourceGroupName, serviceName, configurationServiceName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationServiceResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ConfigurationServiceResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationServiceResourceCollection)res.getValue()).value(), ((ConfigurationServiceResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationServiceResourceInner>> listSinglePageAsync(String resourceGroupName, String serviceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, "application/json", context).map(res -> new PagedResponseBase<Object, ConfigurationServiceResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationServiceResourceCollection)res.getValue()).value(), ((ConfigurationServiceResourceCollection)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<ConfigurationServiceResourceInner> listAsync(String resourceGroupName, String serviceName) {
        return new PagedFlux<ConfigurationServiceResourceInner>(() -> this.listSinglePageAsync(resourceGroupName, serviceName), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<ConfigurationServiceResourceInner> listAsync(String resourceGroupName, String serviceName, Context context) {
        return new PagedFlux<ConfigurationServiceResourceInner>(() -> this.listSinglePageAsync(resourceGroupName, serviceName, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationServiceResourceInner> list(String resourceGroupName, String serviceName) {
        return new PagedIterable<ConfigurationServiceResourceInner>(this.listAsync(resourceGroupName, serviceName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<ConfigurationServiceResourceInner> list(String resourceGroupName, String serviceName, Context context) {
        return new PagedIterable<ConfigurationServiceResourceInner>(this.listAsync(resourceGroupName, serviceName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceSettings settings) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (configurationServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceName is required and cannot be null."));
        }
        if (settings == null) {
            return Mono.error(new IllegalArgumentException("Parameter settings is required and cannot be null."));
        }
        settings.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configurationServiceName, settings, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateWithResponseAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceSettings settings, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (configurationServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceName is required and cannot be null."));
        }
        if (settings == null) {
            return Mono.error(new IllegalArgumentException("Parameter settings is required and cannot be null."));
        }
        settings.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validate(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configurationServiceName, settings, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ConfigurationServiceSettingsValidateResultInner>, ConfigurationServiceSettingsValidateResultInner> beginValidateAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceSettings settings) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateWithResponseAsync(resourceGroupName, serviceName, configurationServiceName, settings);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConfigurationServiceSettingsValidateResultInner.class), (Type)((Object)ConfigurationServiceSettingsValidateResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConfigurationServiceSettingsValidateResultInner>, ConfigurationServiceSettingsValidateResultInner> beginValidateAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceSettings settings, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateWithResponseAsync(resourceGroupName, serviceName, configurationServiceName, settings, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConfigurationServiceSettingsValidateResultInner.class), (Type)((Object)ConfigurationServiceSettingsValidateResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConfigurationServiceSettingsValidateResultInner>, ConfigurationServiceSettingsValidateResultInner> beginValidate(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceSettings settings) {
        return this.beginValidateAsync(resourceGroupName, serviceName, configurationServiceName, settings).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConfigurationServiceSettingsValidateResultInner>, ConfigurationServiceSettingsValidateResultInner> beginValidate(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceSettings settings, Context context) {
        return this.beginValidateAsync(resourceGroupName, serviceName, configurationServiceName, settings, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationServiceSettingsValidateResultInner> validateAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceSettings settings) {
        return this.beginValidateAsync(resourceGroupName, serviceName, configurationServiceName, settings).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConfigurationServiceSettingsValidateResultInner> validateAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceSettings settings, Context context) {
        return this.beginValidateAsync(resourceGroupName, serviceName, configurationServiceName, settings, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationServiceSettingsValidateResultInner validate(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceSettings settings) {
        return this.validateAsync(resourceGroupName, serviceName, configurationServiceName, settings).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationServiceSettingsValidateResultInner validate(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceSettings settings, Context context) {
        return this.validateAsync(resourceGroupName, serviceName, configurationServiceName, settings, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> validateResourceWithResponseAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (configurationServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceName is required and cannot be null."));
        }
        if (configurationServiceResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceResource is required and cannot be null."));
        }
        configurationServiceResource.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validateResource(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configurationServiceName, configurationServiceResource, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> validateResourceWithResponseAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serviceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter serviceName is required and cannot be null."));
        }
        if (configurationServiceName == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceName is required and cannot be null."));
        }
        if (configurationServiceResource == null) {
            return Mono.error(new IllegalArgumentException("Parameter configurationServiceResource is required and cannot be null."));
        }
        configurationServiceResource.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validateResource(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), resourceGroupName, serviceName, configurationServiceName, configurationServiceResource, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<ConfigurationServiceSettingsValidateResultInner>, ConfigurationServiceSettingsValidateResultInner> beginValidateResourceAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateResourceWithResponseAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConfigurationServiceSettingsValidateResultInner.class), (Type)((Object)ConfigurationServiceSettingsValidateResultInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<ConfigurationServiceSettingsValidateResultInner>, ConfigurationServiceSettingsValidateResultInner> beginValidateResourceAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.validateResourceWithResponseAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource, context);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)ConfigurationServiceSettingsValidateResultInner.class), (Type)((Object)ConfigurationServiceSettingsValidateResultInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConfigurationServiceSettingsValidateResultInner>, ConfigurationServiceSettingsValidateResultInner> beginValidateResource(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource) {
        return this.beginValidateResourceAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<ConfigurationServiceSettingsValidateResultInner>, ConfigurationServiceSettingsValidateResultInner> beginValidateResource(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource, Context context) {
        return this.beginValidateResourceAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ConfigurationServiceSettingsValidateResultInner> validateResourceAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource) {
        return this.beginValidateResourceAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<ConfigurationServiceSettingsValidateResultInner> validateResourceAsync(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource, Context context) {
        return this.beginValidateResourceAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationServiceSettingsValidateResultInner validateResource(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource) {
        return this.validateResourceAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public ConfigurationServiceSettingsValidateResultInner validateResource(String resourceGroupName, String serviceName, String configurationServiceName, ConfigurationServiceResourceInner configurationServiceResource, Context context) {
        return this.validateResourceAsync(resourceGroupName, serviceName, configurationServiceName, configurationServiceResource, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationServiceResourceInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase<Object, ConfigurationServiceResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationServiceResourceCollection)res.getValue()).value(), ((ConfigurationServiceResourceCollection)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<ConfigurationServiceResourceInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase<Object, ConfigurationServiceResourceInner>(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((ConfigurationServiceResourceCollection)res.getValue()).value(), ((ConfigurationServiceResourceCollection)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AppPlatformManagemen")
    public static interface ConfigurationServicesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationServiceResourceInner>> get(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="configurationServiceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="configurationServiceName") String var6, @BodyParam(value="application/json") ConfigurationServiceResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="configurationServiceName") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationServiceResourceCollection>> list(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}/validate")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validate(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="configurationServiceName") String var6, @BodyParam(value="application/json") ConfigurationServiceSettings var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AppPlatform/Spring/{serviceName}/configurationServices/{configurationServiceName}/validateResource")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> validateResource(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serviceName") String var5, @PathParam(value="configurationServiceName") String var6, @BodyParam(value="application/json") ConfigurationServiceResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<ConfigurationServiceResourceCollection>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

